/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.ChainedServletFilter;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.ApiTokenProperty;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ldap.DefaultInitialDirContextFactory;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.ldap.search.FilterBasedLdapUserSearch;
import org.acegisecurity.providers.ProviderManager;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.authenticator.BindAuthenticator2;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.reverse_proxy_auth.Messages;
import org.jenkinsci.plugins.reverse_proxy_auth.ReverseProxySearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.DefaultReverseProxyAuthenticator;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthenticationProvider;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthoritiesPopulatorImpl;
import org.jenkinsci.plugins.reverse_proxy_auth.data.GroupSearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.data.UserSearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;
import org.jenkinsci.plugins.reverse_proxy_auth.service.ProxyLDAPAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.service.ProxyLDAPUserDetailsService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.dao.DataAccessException;

public class ReverseProxySecurityRealm
extends SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(ReverseProxySecurityRealm.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="May be used in system groovy scripts")
    public static String GROUP_SEARCH = System.getProperty("hudson.security.LDAPSecurityRealm.groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");
    private static final int CHECK_INTERVAL = 15;
    private Secret managerPasswordSecret;
    @Deprecated
    private transient String managerPassword;
    private ReverseProxySearchTemplate proxyTemplate;
    private transient LdapTemplate ldapTemplate;
    private transient Hashtable<String, GrantedAuthority[]> authContext;
    private transient Hashtable<String, Long> authorityUpdateCache;
    public final String server;
    public final String rootDN;
    public final boolean inhibitInferRootDN;
    public final String userSearchBase;
    public final String userSearch;
    public final String groupSearchBase;
    public final String groupSearchFilter;
    public final String groupMembershipFilter;
    public String groupNameAttribute;
    public final String managerDN;
    public final int updateInterval;
    public transient GrantedAuthority[] authorities = new GrantedAuthority[0];
    @CheckForNull
    public final String forwardedUser;
    public String retrievedUser;
    public final String headerGroups;
    public final String headerGroupsDelimiter;
    public final boolean disableLdapEmailResolver;
    private final String displayNameLdapAttribute;
    private final String emailAddressLdapAttribute;
    public final String customLogInUrl;
    public final String customLogOutUrl;

    @DataBoundConstructor
    public ReverseProxySecurityRealm(String forwardedUser, String headerGroups, String headerGroupsDelimiter, String customLogInUrl, String customLogOutUrl, String server, String rootDN, boolean inhibitInferRootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String groupNameAttribute, String managerDN, Secret managerPassword, Integer updateInterval, boolean disableLdapEmailResolver, String displayNameLdapAttribute, String emailAddressLdapAttribute) {
        this.forwardedUser = Util.fixEmptyAndTrim((String)forwardedUser);
        this.headerGroups = headerGroups;
        this.headerGroupsDelimiter = !StringUtils.isBlank((String)headerGroupsDelimiter) ? headerGroupsDelimiter.trim() : "|";
        this.customLogInUrl = !StringUtils.isBlank((String)customLogInUrl) ? customLogInUrl : null;
        this.customLogOutUrl = !StringUtils.isBlank((String)customLogOutUrl) ? customLogOutUrl : null;
        this.server = Util.fixEmptyAndTrim((String)server);
        this.managerDN = Util.fixEmpty((String)managerDN);
        this.managerPasswordSecret = managerPassword;
        this.inhibitInferRootDN = inhibitInferRootDN;
        if (this.server != null) {
            if (!inhibitInferRootDN && Util.fixEmptyAndTrim((String)rootDN) == null) {
                rootDN = Util.fixNull((String)this.inferRootDN(server));
            }
            this.rootDN = rootDN.trim();
        } else {
            this.rootDN = null;
        }
        this.userSearchBase = Util.fixNull((String)userSearchBase).trim();
        userSearch = Util.fixEmptyAndTrim((String)userSearch);
        this.userSearch = userSearch != null ? userSearch : "uid={0}";
        this.groupSearchBase = Util.fixEmptyAndTrim((String)groupSearchBase);
        this.groupSearchFilter = Util.fixEmptyAndTrim((String)groupSearchFilter);
        this.groupMembershipFilter = Util.fixEmptyAndTrim((String)groupMembershipFilter);
        this.groupNameAttribute = Util.fixEmptyAndTrim((String)groupNameAttribute);
        this.updateInterval = updateInterval == null || updateInterval <= 0 ? 15 : updateInterval;
        this.authorities = new GrantedAuthority[0];
        this.disableLdapEmailResolver = disableLdapEmailResolver;
        this.displayNameLdapAttribute = displayNameLdapAttribute;
        this.emailAddressLdapAttribute = emailAddressLdapAttribute;
    }

    public String getForwardedUser() {
        return this.forwardedUser;
    }

    public String getHeaderGroups() {
        return this.headerGroups;
    }

    public String getHeaderGroupsDelimiter() {
        return this.headerGroupsDelimiter;
    }

    @CheckForNull
    public String getServerUrl() {
        if (this.server == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : this.server.split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(ReverseProxySecurityRealm.addPrefix(s));
        }
        return buf.toString();
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public String getGroupMembershipFilter() {
        return this.groupMembershipFilter;
    }

    public String getGroupNameAttribute() {
        return this.groupNameAttribute;
    }

    public void setGroupNameAttribute(String groupNameAttribute) {
        this.groupNameAttribute = groupNameAttribute;
    }

    public String getDisplayNameLdapAttribute() {
        return this.displayNameLdapAttribute;
    }

    public String getEmailAddressLdapAttribute() {
        return this.emailAddressLdapAttribute;
    }

    protected Object readResolve() {
        if (this.managerPassword != null) {
            this.managerPasswordSecret = Secret.fromString((String)Scrambler.descramble((String)this.managerPassword));
        }
        return this;
    }

    private String inferRootDN(String server) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.managerDN != null && this.getManagerPassword() != null) {
                props.put("java.naming.security.principal", this.managerDN);
                props.put("java.naming.security.credentials", this.getManagerPassword().getPlainText());
            }
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.provider.url", ReverseProxySecurityRealm.toProviderUrl(Util.fixNull((String)this.getServerUrl()), ""));
            InitialDirContext ctx = new InitialDirContext(props);
            Attributes atts = ctx.getAttributes("");
            Attribute a = atts.get("defaultNamingContext");
            if (a != null && a.get() != null) {
                return a.get().toString();
            }
            a = atts.get("namingcontexts");
            if (a == null) {
                LOGGER.warning("namingcontexts attribute not found in root DSE of " + server);
                return null;
            }
            return a.get().toString();
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to LDAP to infer Root DN for " + server, e);
            return null;
        }
    }

    @Nullable
    public static String toProviderUrl(@CheckForNull String serverUrl, @CheckForNull String rootDN) {
        if (serverUrl == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : serverUrl.split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            s = ReverseProxySecurityRealm.addPrefix(s);
            buf.append(s);
            if (!s.endsWith("/")) {
                buf.append('/');
            }
            buf.append(Util.fixNull((String)rootDN));
        }
        return buf.toString();
    }

    public Secret getManagerPassword() {
        return this.managerPasswordSecret;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public String getLDAPURL() {
        return ReverseProxySecurityRealm.toProviderUrl(this.getServerUrl(), Util.fixNull((String)this.rootDN));
    }

    public Filter createFilter(FilterConfig filterConfig) {
        Filter filter = new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                String uidpassword;
                int idx;
                HttpServletRequest r = (HttpServletRequest)request;
                String authorization = null;
                String userFromApiToken = null;
                authorization = r.getHeader("Authorization");
                if (authorization != null && authorization.toLowerCase().startsWith("basic ") && (idx = (uidpassword = Scrambler.descramble((String)authorization.substring(6))).indexOf(58)) >= 0) {
                    ApiTokenProperty t;
                    String username = uidpassword.substring(0, idx);
                    String password = uidpassword.substring(idx + 1);
                    User u = User.get((String)username, (boolean)false);
                    if (u != null && (t = (ApiTokenProperty)u.getProperty(ApiTokenProperty.class)) != null && t.matchesPassword(password)) {
                        userFromApiToken = username;
                    }
                }
                String userFromHeader = null;
                Authentication auth = Jenkins.ANONYMOUS;
                if (ReverseProxySecurityRealm.this.forwardedUser != null && (userFromHeader = r.getHeader(ReverseProxySecurityRealm.this.forwardedUser)) != null || userFromApiToken != null) {
                    LOGGER.log(Level.FINE, "USER LOGGED IN: {0}", userFromHeader);
                    if (userFromHeader == null) {
                        userFromHeader = userFromApiToken;
                    }
                    if (ReverseProxySecurityRealm.this.authContext == null) {
                        ReverseProxySecurityRealm.this.authContext = new Hashtable();
                    }
                    if (ReverseProxySecurityRealm.this.getLDAPURL() != null) {
                        GrantedAuthority[] storedGrants = (GrantedAuthority[])ReverseProxySecurityRealm.this.authContext.get(userFromHeader);
                        if (storedGrants != null && storedGrants.length > 1) {
                            ReverseProxySecurityRealm.this.authorities = ReverseProxySecurityRealm.this.retrieveAuthoritiesIfNecessary(userFromHeader, storedGrants);
                        } else {
                            HashSet<Object> tempLocalAuthorities;
                            try {
                                LdapUserDetails userDetails = (LdapUserDetails)ReverseProxySecurityRealm.this.loadUserByUsername(userFromHeader);
                                ReverseProxySecurityRealm.this.authorities = userDetails.getAuthorities();
                                tempLocalAuthorities = new HashSet<GrantedAuthority>(Arrays.asList(ReverseProxySecurityRealm.this.authorities));
                                tempLocalAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                                ReverseProxySecurityRealm.this.authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                            }
                            catch (UsernameNotFoundException e) {
                                LOGGER.log(Level.WARNING, "User not found in the LDAP directory: " + e.getMessage());
                                tempLocalAuthorities = new HashSet();
                                tempLocalAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                                ReverseProxySecurityRealm.this.authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                            }
                        }
                    } else {
                        String groups = r.getHeader(ReverseProxySecurityRealm.this.headerGroups);
                        ArrayList<Object> localAuthorities = new ArrayList<Object>();
                        localAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                        if (groups != null) {
                            StringTokenizer tokenizer = new StringTokenizer(groups, ReverseProxySecurityRealm.this.headerGroupsDelimiter);
                            while (tokenizer.hasMoreTokens()) {
                                String token = tokenizer.nextToken().trim();
                                localAuthorities.add(new GrantedAuthorityImpl(token));
                            }
                        }
                        ReverseProxySecurityRealm.this.authorities = localAuthorities.toArray(new GrantedAuthority[0]);
                        UserSearchTemplate searchTemplate = new UserSearchTemplate(userFromHeader);
                        Set<String> foundAuthorities = ReverseProxySecurityRealm.this.proxyTemplate.searchForSingleAttributeValues(searchTemplate, ReverseProxySecurityRealm.this.authorities);
                        HashSet<GrantedAuthorityImpl> tempLocalAuthorities = new HashSet<GrantedAuthorityImpl>();
                        String[] authString = foundAuthorities.toArray(new String[0]);
                        for (int i = 0; i < authString.length; ++i) {
                            tempLocalAuthorities.add(new GrantedAuthorityImpl(authString[i]));
                        }
                        ReverseProxySecurityRealm.this.authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                        ReverseProxySecurityRealm.this.authContext.put(userFromHeader, ReverseProxySecurityRealm.this.authorities);
                        auth = new UsernamePasswordAuthenticationToken((Object)userFromHeader, (Object)"", ReverseProxySecurityRealm.this.authorities);
                    }
                    ReverseProxySecurityRealm.this.authContext.put(userFromHeader, ReverseProxySecurityRealm.this.authorities);
                    auth = new UsernamePasswordAuthenticationToken((Object)userFromHeader, (Object)"", ReverseProxySecurityRealm.this.authorities);
                }
                ReverseProxySecurityRealm.this.retrievedUser = userFromHeader;
                SecurityContextHolder.getContext().setAuthentication(auth);
                chain.doFilter((ServletRequest)r, response);
            }

            public void destroy() {
            }
        };
        Filter defaultFilter = super.createFilter(filterConfig);
        return new ChainedServletFilter(new Filter[]{defaultFilter, filter});
    }

    public boolean canLogOut() {
        return this.customLogOutUrl != null;
    }

    public String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        if (this.customLogOutUrl == null) {
            return super.getPostLogOutUrl(req, auth);
        }
        return this.customLogOutUrl;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() throws DataAccessException {
        if (this.getLDAPURL() == null) {
            this.proxyTemplate = new ReverseProxySearchTemplate();
            DefaultReverseProxyAuthenticator authenticator = new DefaultReverseProxyAuthenticator(this.retrievedUser, this.authorities);
            ReverseProxyAuthoritiesPopulatorImpl authoritiesPopulator = new ReverseProxyAuthoritiesPopulatorImpl(this.authContext);
            ProviderManager pm = new ProviderManager();
            ArrayList<ReverseProxyAuthenticationProvider> providers = new ArrayList<ReverseProxyAuthenticationProvider>();
            providers.add(new ReverseProxyAuthenticationProvider(authenticator, authoritiesPopulator));
            RememberMeAuthenticationProvider rmap = new RememberMeAuthenticationProvider();
            rmap.setKey(Jenkins.getInstance().getSecretKey());
            providers.add((ReverseProxyAuthenticationProvider)rmap);
            AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
            aap.setKey("anonymous");
            providers.add((ReverseProxyAuthenticationProvider)aap);
            pm.setProviders(providers);
            return new SecurityRealm.SecurityComponents((AuthenticationManager)pm, (UserDetailsService)new ReverseProxyUserDetailsService(authoritiesPopulator));
        }
        DefaultInitialDirContextFactory dirContextFactory = new DefaultInitialDirContextFactory(this.getLDAPURL());
        if (this.managerDN != null && this.getManagerPassword() != null) {
            dirContextFactory.setManagerDn(this.managerDN);
            dirContextFactory.setManagerPassword(Util.fixEmptyAndTrim((String)this.getManagerPassword().getPlainText()));
        }
        dirContextFactory.setExtraEnvVars(Collections.singletonMap("java.naming.referral", "follow"));
        this.ldapTemplate = new LdapTemplate((InitialDirContextFactory)dirContextFactory);
        FilterBasedLdapUserSearch ldapUserSearch = new FilterBasedLdapUserSearch(this.userSearchBase, this.userSearch, (InitialDirContextFactory)dirContextFactory);
        ldapUserSearch.setSearchSubtree(true);
        BindAuthenticator2 bindAuthenticator = new BindAuthenticator2((InitialDirContextFactory)dirContextFactory);
        bindAuthenticator.setUserSearch((LdapUserSearch)ldapUserSearch);
        ProxyLDAPAuthoritiesPopulator authoritiesPopulator = new ProxyLDAPAuthoritiesPopulator((InitialDirContextFactory)dirContextFactory, this.groupSearchBase);
        authoritiesPopulator.setSearchSubtree(true);
        authoritiesPopulator.setGroupSearchFilter("(| (member={0}) (uniqueMember={0}) (memberUid={1}))");
        ProviderManager pm = new ProviderManager();
        ArrayList<Object> providers = new ArrayList<Object>();
        LdapAuthenticationProvider authenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)authoritiesPopulator);
        providers.add(authenticationProvider);
        RememberMeAuthenticationProvider rmap = new RememberMeAuthenticationProvider();
        rmap.setKey(Jenkins.getInstance().getSecretKey());
        providers.add(rmap);
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("anonymous");
        providers.add(aap);
        pm.setProviders(providers);
        if (this.groupMembershipFilter != null || this.groupNameAttribute != null) {
            if (this.groupMembershipFilter != null) {
                authoritiesPopulator.setGroupSearchFilter(this.groupMembershipFilter);
            }
            if (this.groupNameAttribute != null) {
                authoritiesPopulator.setGroupRoleAttribute(this.groupNameAttribute);
            }
        }
        return new SecurityRealm.SecurityComponents((AuthenticationManager)pm, (UserDetailsService)new ProxyLDAPUserDetailsService((LdapUserSearch)ldapUserSearch, (LdapAuthoritiesPopulator)authoritiesPopulator));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        UserDetails userDetails = this.getSecurityComponents().userDetails.loadUserByUsername(username);
        if (userDetails instanceof LdapUserDetails) {
            this.updateLdapUserDetails((LdapUserDetails)userDetails);
        }
        return userDetails;
    }

    public LdapUserDetails updateLdapUserDetails(LdapUserDetails d) {
        LOGGER.log(Level.FINEST, "displayNameLdapAttribute" + this.displayNameLdapAttribute);
        LOGGER.log(Level.FINEST, "disableLdapEmailResolver" + this.disableLdapEmailResolver);
        LOGGER.log(Level.FINEST, "emailAddressLdapAttribute" + this.emailAddressLdapAttribute);
        if (d.getAttributes() == null) {
            LOGGER.log(Level.FINEST, "getAttributes is null");
        } else {
            Attribute attribute;
            User u = User.get((String)d.getUsername());
            if (!StringUtils.isBlank((String)this.displayNameLdapAttribute)) {
                LOGGER.log(Level.FINEST, "Getting user details from LDAP attributes");
                try {
                    attribute = d.getAttributes().get(this.displayNameLdapAttribute);
                    String displayName = attribute == null ? null : (String)attribute.get();
                    LOGGER.log(Level.FINEST, "displayName is " + displayName);
                    if (StringUtils.isNotBlank((String)displayName)) {
                        u.setFullName(displayName);
                    }
                }
                catch (NamingException e) {
                    LOGGER.log(Level.FINEST, "Could not retrieve display name attribute", e);
                }
            }
            if (!this.disableLdapEmailResolver && !StringUtils.isBlank((String)this.emailAddressLdapAttribute)) {
                try {
                    String mailAddress;
                    attribute = d.getAttributes().get(this.emailAddressLdapAttribute);
                    String string = mailAddress = attribute == null ? null : (String)attribute.get();
                    if (StringUtils.isNotBlank((String)mailAddress)) {
                        LOGGER.log(Level.FINEST, "mailAddress is " + mailAddress);
                        Mailer.UserProperty existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class);
                        if (existing == null || !existing.hasExplicitlyConfiguredAddress()) {
                            LOGGER.log(Level.FINEST, "user mail address has been changed");
                            u.addProperty((UserProperty)new Mailer.UserProperty(mailAddress));
                        }
                    }
                }
                catch (NamingException e) {
                    LOGGER.log(Level.FINEST, "Could not retrieve email address attribute", e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
                }
            }
        }
        return d;
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        Set groups;
        if (this.getLDAPURL() != null) {
            String searchBase = this.groupSearchBase != null ? this.groupSearchBase : "";
            String searchFilter = this.groupSearchFilter != null ? this.groupSearchFilter : GROUP_SEARCH;
            groups = this.ldapTemplate.searchForSingleAttributeValues(searchBase, searchFilter, (Object[])new String[]{groupname}, "cn");
        } else {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            GrantedAuthority[] authorities = this.authContext != null ? this.authContext.get(auth.getName()) : null;
            GroupSearchTemplate searchTemplate = new GroupSearchTemplate(groupname);
            groups = this.proxyTemplate.searchForSingleAttributeValues(searchTemplate, authorities);
        }
        if (groups.isEmpty()) {
            throw new UsernameNotFoundException(groupname);
        }
        return new GroupDetails(){

            public String getName() {
                return (String)groups.iterator().next();
            }
        };
    }

    private GrantedAuthority[] retrieveAuthoritiesIfNecessary(String userFromHeader, GrantedAuthority[] storedGrants) {
        GrantedAuthority[] authorities = storedGrants;
        if (this.getLDAPURL() != null) {
            long current = System.currentTimeMillis();
            if (this.authorityUpdateCache != null && this.authorityUpdateCache.containsKey(userFromHeader)) {
                long lastTime = this.authorityUpdateCache.get(userFromHeader);
                long check = (current - lastTime) / 1000L / 60L;
                if (check >= (long)this.updateInterval) {
                    LOGGER.log(Level.INFO, "The check interval reached the threshold of " + check + "min, will now update the authorities");
                    LdapUserDetails userDetails = (LdapUserDetails)this.loadUserByUsername(userFromHeader);
                    authorities = userDetails.getAuthorities();
                    HashSet<GrantedAuthority> tempLocalAuthorities = new HashSet<GrantedAuthority>(Arrays.asList(authorities));
                    tempLocalAuthorities.add(AUTHENTICATED_AUTHORITY);
                    authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                    this.authorityUpdateCache.put(userFromHeader, current);
                    LOGGER.log(Level.INFO, "Authorities for user " + userFromHeader + " have been updated.");
                }
            } else {
                if (this.authorityUpdateCache == null) {
                    this.authorityUpdateCache = new Hashtable();
                }
                this.authorityUpdateCache.put(userFromHeader, current);
            }
        }
        return authorities;
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    public static class ReverseProxyUserDetailsService
    implements UserDetailsService {
        private final ReverseProxyAuthoritiesPopulator authoritiesPopulator;

        public ReverseProxyUserDetailsService(ReverseProxyAuthoritiesPopulator authoritiesPopulator) {
            this.authoritiesPopulator = authoritiesPopulator;
        }

        public ReverseProxyUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            try {
                ReverseProxyUserDetails proxyUser = new ReverseProxyUserDetails();
                proxyUser.setUsername(username);
                GrantedAuthority[] localAuthorities = this.authoritiesPopulator.getGrantedAuthorities(proxyUser);
                proxyUser.setAuthorities(localAuthorities);
                return proxyUser;
            }
            catch (LdapDataAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to search LDAP for username=" + username, e);
                throw new UserMayOrMayNotExistException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Extension
    public static class ProxyLDAPDescriptor
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return Messages.ReverseProxySecurityRealm_DisplayName();
        }

        public FormValidation doServerCheck(@QueryParameter String server, @QueryParameter String managerDN, @QueryParameter String managerPassword) {
            String trimmedServer = Util.fixEmptyAndTrim((String)server);
            if (trimmedServer == null) {
                return FormValidation.error((String)"Server is null or empty");
            }
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (managerDN != null && managerDN.trim().length() > 0 && !"undefined".equals(managerDN)) {
                    props.put("java.naming.security.principal", managerDN);
                }
                if (managerPassword != null && managerPassword.trim().length() > 0 && !"undefined".equals(managerPassword)) {
                    props.put("java.naming.security.credentials", managerPassword);
                }
                props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                props.put("java.naming.provider.url", ReverseProxySecurityRealm.toProviderUrl(trimmedServer, ""));
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.getAttributes("");
                return FormValidation.ok();
            }
            catch (NamingException e) {
                Matcher m = Pattern.compile("(ldaps?://)?([^:]+)(?:\\:(\\d+))?(\\s+(ldaps?://)?([^:]+)(?:\\:(\\d+))?)*").matcher(trimmedServer.trim());
                if (!m.matches()) {
                    return FormValidation.error((String)Messages.ReverseProxySecurityRealm_SyntaxOfServerField());
                }
                try {
                    int port;
                    InetAddress adrs = InetAddress.getByName(m.group(2));
                    int n = port = m.group(1) != null ? 636 : 389;
                    if (m.group(3) != null) {
                        port = Integer.parseInt(m.group(3));
                    }
                    Socket s = new Socket(adrs, port);
                    s.close();
                }
                catch (UnknownHostException x) {
                    return FormValidation.error((String)Messages.ReverseProxySecurityRealm_UnknownHost(x.getMessage()));
                }
                catch (IOException x) {
                    return FormValidation.error((Throwable)x, (String)Messages.ReverseProxySecurityRealm_UnableToConnect(trimmedServer, x.getMessage()));
                }
                return FormValidation.error((Throwable)e, (String)Messages.ReverseProxySecurityRealm_UnableToConnect(trimmedServer, e));
            }
            catch (NumberFormatException x) {
                return FormValidation.error((String)Messages.ReverseProxySecurityRealm_InvalidPortNumber());
            }
        }
    }
}

