/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth;

import groovy.lang.Binding;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.GroupDetails;
import hudson.security.LDAPSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import hudson.util.spring.BeanBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.ApiTokenProperty;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.reverse_proxy_auth.Messages;
import org.jenkinsci.plugins.reverse_proxy_auth.ReverseProxySearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.auth.ReverseProxyAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.data.GroupSearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.data.UserSearchTemplate;
import org.jenkinsci.plugins.reverse_proxy_auth.model.ReverseProxyUserDetails;
import org.jenkinsci.plugins.reverse_proxy_auth.service.ProxyLDAPAuthoritiesPopulator;
import org.jenkinsci.plugins.reverse_proxy_auth.service.ProxyLDAPUserDetailsService;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseProxySecurityRealm
extends SecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(ReverseProxySecurityRealm.class.getName());
    public static String GROUP_SEARCH = System.getProperty(LDAPSecurityRealm.class.getName() + ".groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");
    private static final int CHECK_INTERVAL = 15;
    private final String managerPassword;
    private ReverseProxySearchTemplate proxyTemplate;
    private transient LdapTemplate ldapTemplate;
    private final Hashtable<String, GrantedAuthority[]> authContext;
    private Hashtable<String, Long> authorityUpdateCache;
    public final String server;
    public final String rootDN;
    public final boolean inhibitInferRootDN;
    public final String userSearchBase;
    public final String userSearch;
    public final String groupSearchBase;
    public final String groupSearchFilter;
    public final String groupMembershipFilter;
    public final String managerDN;
    public final int updateInterval;
    public transient GrantedAuthority[] authorities = new GrantedAuthority[0];
    public final String forwardedUser;
    public String retrievedUser;
    public final String headerGroups;
    public final String headerGroupsDelimiter;
    public final boolean disableLdapEmailResolver;
    private final String displayNameLdapAttribute;
    private final String emailAddressLdapAttribute;

    @DataBoundConstructor
    public ReverseProxySecurityRealm(String forwardedUser, String headerGroups, String headerGroupsDelimiter, String server, String rootDN, boolean inhibitInferRootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, Integer updateInterval, boolean disableLdapEmailResolver, String displayNameLdapAttribute, String emailAddressLdapAttribute) {
        this.forwardedUser = Util.fixEmptyAndTrim((String)forwardedUser);
        this.headerGroups = headerGroups;
        this.headerGroupsDelimiter = !StringUtils.isBlank((String)headerGroupsDelimiter) ? headerGroupsDelimiter.trim() : "|";
        this.server = Util.fixEmptyAndTrim((String)server);
        this.managerDN = Util.fixEmpty((String)managerDN);
        this.managerPassword = Scrambler.scramble((String)Util.fixEmpty((String)managerPassword));
        this.inhibitInferRootDN = inhibitInferRootDN;
        if (this.server != null) {
            if (!inhibitInferRootDN && Util.fixEmptyAndTrim((String)rootDN) == null) {
                rootDN = Util.fixNull((String)this.inferRootDN(server));
            }
            this.rootDN = rootDN.trim();
        } else {
            this.rootDN = null;
        }
        this.userSearchBase = Util.fixNull((String)userSearchBase).trim();
        userSearch = Util.fixEmptyAndTrim((String)userSearch);
        this.userSearch = userSearch != null ? userSearch : "uid={0}";
        this.groupSearchBase = Util.fixEmptyAndTrim((String)groupSearchBase);
        this.groupSearchFilter = Util.fixEmptyAndTrim((String)groupSearchFilter);
        this.groupMembershipFilter = Util.fixEmptyAndTrim((String)groupMembershipFilter);
        this.updateInterval = updateInterval == null || updateInterval <= 0 ? 15 : updateInterval;
        this.authorities = new GrantedAuthority[0];
        this.authContext = new Hashtable();
        this.authorityUpdateCache = new Hashtable();
        this.disableLdapEmailResolver = disableLdapEmailResolver;
        this.displayNameLdapAttribute = displayNameLdapAttribute;
        this.emailAddressLdapAttribute = emailAddressLdapAttribute;
    }

    public String getForwardedUser() {
        return this.forwardedUser;
    }

    public String getHeaderGroups() {
        return this.headerGroups;
    }

    public String getHeaderGroupsDelimiter() {
        return this.headerGroupsDelimiter;
    }

    public String getServerUrl() {
        if (this.server == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : this.server.split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(ReverseProxySecurityRealm.addPrefix(s));
        }
        return buf.toString();
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public String getGroupMembershipFilter() {
        return this.groupMembershipFilter;
    }

    public String getDisplayNameLdapAttribute() {
        return this.displayNameLdapAttribute;
    }

    public String getEmailAddressLdapAttribute() {
        return this.emailAddressLdapAttribute;
    }

    private String inferRootDN(String server) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.managerDN != null) {
                props.put("java.naming.security.principal", this.managerDN);
                props.put("java.naming.security.credentials", this.getManagerPassword());
            }
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.provider.url", ReverseProxySecurityRealm.toProviderUrl(Util.fixNull((String)this.getServerUrl()), ""));
            InitialDirContext ctx = new InitialDirContext(props);
            Attributes atts = ctx.getAttributes("");
            Attribute a = atts.get("defaultNamingContext");
            if (a != null && a.get() != null) {
                return a.get().toString();
            }
            a = atts.get("namingcontexts");
            if (a == null) {
                LOGGER.warning("namingcontexts attribute not found in root DSE of " + server);
                return null;
            }
            return a.get().toString();
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to LDAP to infer Root DN for " + server, e);
            return null;
        }
    }

    public static String toProviderUrl(String serverUrl, String rootDN) {
        if (serverUrl == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : serverUrl.split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            s = ReverseProxySecurityRealm.addPrefix(s);
            buf.append(s);
            if (!s.endsWith("/")) {
                buf.append('/');
            }
            buf.append(Util.fixNull((String)rootDN));
        }
        return buf.toString();
    }

    public String getManagerPassword() {
        return Scrambler.descramble((String)this.managerPassword);
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public String getLDAPURL() {
        return ReverseProxySecurityRealm.toProviderUrl(this.getServerUrl(), Util.fixNull((String)this.rootDN));
    }

    public Filter createFilter(FilterConfig filterConfig) {
        return new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                String uidpassword;
                int idx;
                HttpServletRequest r = (HttpServletRequest)request;
                String authorization = null;
                String userFromApiToken = null;
                authorization = r.getHeader("Authorization");
                if (authorization != null && authorization.toLowerCase().startsWith("basic ") && (idx = (uidpassword = Scrambler.descramble((String)authorization.substring(6))).indexOf(58)) >= 0) {
                    String username = uidpassword.substring(0, idx);
                    String password = uidpassword.substring(idx + 1);
                    User u = User.get((String)username, (boolean)false);
                    ApiTokenProperty t = (ApiTokenProperty)u.getProperty(ApiTokenProperty.class);
                    if (t != null && t.matchesPassword(password)) {
                        userFromApiToken = username;
                    }
                }
                String userFromHeader = null;
                Authentication auth = Hudson.ANONYMOUS;
                if (ReverseProxySecurityRealm.this.forwardedUser != null && (userFromHeader = r.getHeader(ReverseProxySecurityRealm.this.forwardedUser)) != null || userFromApiToken != null) {
                    if (userFromHeader == null && userFromApiToken != null) {
                        userFromHeader = userFromApiToken;
                    }
                    if (ReverseProxySecurityRealm.this.getLDAPURL() != null) {
                        GrantedAuthority[] storedGrants = (GrantedAuthority[])ReverseProxySecurityRealm.this.authContext.get(userFromHeader);
                        if (storedGrants != null && storedGrants.length > 1) {
                            ReverseProxySecurityRealm.this.authorities = ReverseProxySecurityRealm.this.retrieveAuthoritiesIfNecessary(userFromHeader, storedGrants);
                        } else {
                            HashSet<Object> tempLocalAuthorities;
                            try {
                                LdapUserDetails userDetails = (LdapUserDetails)ReverseProxySecurityRealm.this.loadUserByUsername(userFromHeader);
                                ReverseProxySecurityRealm.this.authorities = userDetails.getAuthorities();
                                tempLocalAuthorities = new HashSet<GrantedAuthority>(Arrays.asList(ReverseProxySecurityRealm.this.authorities));
                                tempLocalAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                                ReverseProxySecurityRealm.this.authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                            }
                            catch (UsernameNotFoundException e) {
                                LOGGER.log(Level.WARNING, "User not found in the LDAP directory: " + e.getMessage());
                                tempLocalAuthorities = new HashSet();
                                tempLocalAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                                ReverseProxySecurityRealm.this.authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                            }
                        }
                    } else {
                        String groups = r.getHeader(ReverseProxySecurityRealm.this.headerGroups);
                        ArrayList<Object> localAuthorities = new ArrayList<Object>();
                        localAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
                        if (groups != null) {
                            StringTokenizer tokenizer = new StringTokenizer(groups, ReverseProxySecurityRealm.this.headerGroupsDelimiter);
                            while (tokenizer.hasMoreTokens()) {
                                String token = tokenizer.nextToken().trim();
                                localAuthorities.add(new GrantedAuthorityImpl(token));
                            }
                        }
                        ReverseProxySecurityRealm.this.authorities = localAuthorities.toArray(new GrantedAuthority[0]);
                        UserSearchTemplate searchTemplate = new UserSearchTemplate(userFromHeader);
                        Set<String> foundAuthorities = ReverseProxySecurityRealm.this.proxyTemplate.searchForSingleAttributeValues(searchTemplate, ReverseProxySecurityRealm.this.authorities);
                        HashSet<GrantedAuthorityImpl> tempLocalAuthorities = new HashSet<GrantedAuthorityImpl>();
                        String[] authString = foundAuthorities.toArray(new String[0]);
                        for (int i = 0; i < authString.length; ++i) {
                            tempLocalAuthorities.add(new GrantedAuthorityImpl(authString[i]));
                        }
                        ReverseProxySecurityRealm.this.authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                        ReverseProxySecurityRealm.this.authContext.put(userFromHeader, ReverseProxySecurityRealm.this.authorities);
                        auth = new UsernamePasswordAuthenticationToken((Object)userFromHeader, (Object)"", ReverseProxySecurityRealm.this.authorities);
                    }
                    ReverseProxySecurityRealm.this.authContext.put(userFromHeader, ReverseProxySecurityRealm.this.authorities);
                    auth = new UsernamePasswordAuthenticationToken((Object)userFromHeader, (Object)"", ReverseProxySecurityRealm.this.authorities);
                }
                ReverseProxySecurityRealm.this.retrievedUser = userFromHeader;
                SecurityContextHolder.getContext().setAuthentication(auth);
                chain.doFilter((ServletRequest)r, response);
            }

            public void destroy() {
            }
        };
    }

    public boolean canLogOut() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        Binding binding = new Binding();
        binding.setVariable("instance", (Object)this);
        BeanBuilder builder = new BeanBuilder(Jenkins.getInstance().pluginManager.uberClassLoader);
        String fileName = this.getLDAPURL() != null ? "ReverseProxyLDAPSecurityRealm.groovy" : "ReverseProxySecurityRealm.groovy";
        try {
            File override = new File(Jenkins.getInstance().getRootDir(), fileName);
            builder.parse((InputStream)(override.exists() ? new AutoCloseInputStream((InputStream)new FileInputStream(override)) : ((Object)((Object)this)).getClass().getResourceAsStream(fileName)), binding);
        }
        catch (FileNotFoundException e) {
            throw new Error("Failed to load " + fileName, e);
        }
        WebApplicationContext appContext = builder.createApplicationContext();
        if (this.getLDAPURL() == null) {
            this.proxyTemplate = new ReverseProxySearchTemplate();
            return new SecurityRealm.SecurityComponents((AuthenticationManager)ReverseProxySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext), (UserDetailsService)new ReverseProxyUserDetailsService(appContext));
        }
        this.ldapTemplate = new LdapTemplate((InitialDirContextFactory)ReverseProxySecurityRealm.findBean(InitialDirContextFactory.class, (ApplicationContext)appContext));
        if (this.groupMembershipFilter != null) {
            ProxyLDAPAuthoritiesPopulator authoritiesPopulator = (ProxyLDAPAuthoritiesPopulator)((Object)ReverseProxySecurityRealm.findBean(ProxyLDAPAuthoritiesPopulator.class, (ApplicationContext)appContext));
            authoritiesPopulator.setGroupSearchFilter(this.groupMembershipFilter);
        }
        return new SecurityRealm.SecurityComponents((AuthenticationManager)ReverseProxySecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext), (UserDetailsService)new ProxyLDAPUserDetailsService(this, appContext));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        UserDetails userDetails = this.getSecurityComponents().userDetails.loadUserByUsername(username);
        if (userDetails instanceof LdapUserDetails) {
            this.updateLdapUserDetails((LdapUserDetails)userDetails);
        }
        return userDetails;
    }

    public LdapUserDetails updateLdapUserDetails(LdapUserDetails d) {
        LOGGER.log(Level.FINEST, "displayNameLdapAttribute" + this.displayNameLdapAttribute);
        LOGGER.log(Level.FINEST, "disableLdapEmailResolver" + this.disableLdapEmailResolver);
        LOGGER.log(Level.FINEST, "emailAddressLdapAttribute" + this.emailAddressLdapAttribute);
        if (d.getAttributes() == null) {
            LOGGER.log(Level.FINEST, "getAttributes is null");
        } else {
            Attribute attribute;
            User u = User.get((String)d.getUsername());
            if (!StringUtils.isBlank((String)this.displayNameLdapAttribute)) {
                LOGGER.log(Level.FINEST, "Getting user details from LDAP attributes");
                try {
                    attribute = d.getAttributes().get(this.displayNameLdapAttribute);
                    String displayName = attribute == null ? null : (String)attribute.get();
                    LOGGER.log(Level.FINEST, "displayName is " + displayName);
                    if (StringUtils.isNotBlank((String)displayName)) {
                        u.setFullName(displayName);
                    }
                }
                catch (NamingException e) {
                    LOGGER.log(Level.FINEST, "Could not retrieve display name attribute", e);
                }
            }
            if (!this.disableLdapEmailResolver && !StringUtils.isBlank((String)this.emailAddressLdapAttribute)) {
                try {
                    String mailAddress;
                    attribute = d.getAttributes().get(this.emailAddressLdapAttribute);
                    String string = mailAddress = attribute == null ? null : (String)attribute.get();
                    if (StringUtils.isNotBlank((String)mailAddress)) {
                        LOGGER.log(Level.FINEST, "mailAddress is " + mailAddress);
                        Mailer.UserProperty existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class);
                        if (existing == null || !existing.hasExplicitlyConfiguredAddress()) {
                            LOGGER.log(Level.FINEST, "user mail address has been changed");
                            u.addProperty((UserProperty)new Mailer.UserProperty(mailAddress));
                        }
                    }
                }
                catch (NamingException e) {
                    LOGGER.log(Level.FINEST, "Could not retrieve email address attribute", e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
                }
            }
        }
        return d;
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        Set groups;
        if (this.getLDAPURL() != null) {
            String searchBase = this.groupSearchBase != null ? this.groupSearchBase : "";
            String searchFilter = this.groupSearchFilter != null ? this.groupSearchFilter : GROUP_SEARCH;
            groups = this.ldapTemplate.searchForSingleAttributeValues(searchBase, searchFilter, (Object[])new String[]{groupname}, "cn");
        } else {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            GrantedAuthority[] authorities = this.authContext.get(auth.getName());
            GroupSearchTemplate searchTemplate = new GroupSearchTemplate(groupname);
            groups = this.proxyTemplate.searchForSingleAttributeValues(searchTemplate, authorities);
        }
        if (groups.isEmpty()) {
            throw new UsernameNotFoundException(groupname);
        }
        return new GroupDetails(){

            public String getName() {
                return (String)groups.iterator().next();
            }
        };
    }

    public <T> T extractBean(Class<T> type, WebApplicationContext appContext) {
        Object returnedObj = ReverseProxySecurityRealm.findBean(type, (ApplicationContext)appContext);
        return (T)returnedObj;
    }

    private GrantedAuthority[] retrieveAuthoritiesIfNecessary(String userFromHeader, GrantedAuthority[] storedGrants) {
        GrantedAuthority[] authorities = storedGrants;
        if (this.getLDAPURL() != null) {
            long current = System.currentTimeMillis();
            if (this.authorityUpdateCache != null && this.authorityUpdateCache.containsKey(userFromHeader)) {
                long lastTime = this.authorityUpdateCache.get(userFromHeader);
                long check = (current - lastTime) / 1000L / 60L;
                if (check >= (long)this.updateInterval) {
                    LOGGER.log(Level.INFO, "The check interval reached the threshold of " + check + "min, will now update the authorities");
                    LdapUserDetails userDetails = (LdapUserDetails)this.loadUserByUsername(userFromHeader);
                    authorities = userDetails.getAuthorities();
                    HashSet<GrantedAuthority> tempLocalAuthorities = new HashSet<GrantedAuthority>(Arrays.asList(authorities));
                    tempLocalAuthorities.add(AUTHENTICATED_AUTHORITY);
                    authorities = tempLocalAuthorities.toArray(new GrantedAuthority[0]);
                    this.authorityUpdateCache.put(userFromHeader, current);
                    LOGGER.log(Level.INFO, "Authorities for user " + userFromHeader + " have been updated.");
                }
            } else {
                if (this.authorityUpdateCache == null) {
                    this.authorityUpdateCache = new Hashtable();
                }
                this.authorityUpdateCache.put(userFromHeader, current);
            }
        }
        return authorities;
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    public static class ReverseProxyUserDetailsService
    implements UserDetailsService {
        private final ReverseProxyAuthoritiesPopulator authoritiesPopulator;

        public ReverseProxyUserDetailsService(WebApplicationContext appContext) {
            this.authoritiesPopulator = (ReverseProxyAuthoritiesPopulator)SecurityRealm.findBean(ReverseProxyAuthoritiesPopulator.class, (ApplicationContext)appContext);
        }

        public ReverseProxyUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            try {
                ReverseProxyUserDetails proxyUser = new ReverseProxyUserDetails();
                proxyUser.setUsername(username);
                GrantedAuthority[] localAuthorities = this.authoritiesPopulator.getGrantedAuthorities(proxyUser);
                proxyUser.setAuthorities(localAuthorities);
                return proxyUser;
            }
            catch (LdapDataAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to search LDAP for username=" + username, e);
                throw new UserMayOrMayNotExistException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ProxyLDAPDescriptor
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return Messages.ReverseProxySecurityRealm_DisplayName();
        }

        public FormValidation doServerCheck(@QueryParameter String server, @QueryParameter String managerDN, @QueryParameter String managerPassword) {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (managerDN != null && managerDN.trim().length() > 0 && !"undefined".equals(managerDN)) {
                    props.put("java.naming.security.principal", managerDN);
                }
                if (managerPassword != null && managerPassword.trim().length() > 0 && !"undefined".equals(managerPassword)) {
                    props.put("java.naming.security.credentials", managerPassword);
                }
                props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                props.put("java.naming.provider.url", ReverseProxySecurityRealm.toProviderUrl(server, ""));
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.getAttributes("");
                return FormValidation.ok();
            }
            catch (NamingException e) {
                Matcher m = Pattern.compile("(ldaps?://)?([^:]+)(?:\\:(\\d+))?(\\s+(ldaps?://)?([^:]+)(?:\\:(\\d+))?)*").matcher(server.trim());
                if (!m.matches()) {
                    return FormValidation.error((String)hudson.security.Messages.LDAPSecurityRealm_SyntaxOfServerField());
                }
                try {
                    int port;
                    InetAddress adrs = InetAddress.getByName(m.group(2));
                    int n = port = m.group(1) != null ? 636 : 389;
                    if (m.group(3) != null) {
                        port = Integer.parseInt(m.group(3));
                    }
                    Socket s = new Socket(adrs, port);
                    s.close();
                }
                catch (UnknownHostException x) {
                    return FormValidation.error((String)hudson.security.Messages.LDAPSecurityRealm_UnknownHost((Object)x.getMessage()));
                }
                catch (IOException x) {
                    return FormValidation.error((Throwable)x, (String)hudson.security.Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)x.getMessage()));
                }
                return FormValidation.error((Throwable)e, (String)hudson.security.Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)e));
            }
            catch (NumberFormatException x) {
                return FormValidation.error((String)hudson.security.Messages.LDAPSecurityRealm_InvalidPortNumber());
            }
        }
    }
}

