/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.model;

import com.michelin.cio.jenkins.plugin.requests.model.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.Request;
import hudson.model.Item;
import hudson.model.Job;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class RenameJobRequest
extends Request {
    private String newName;
    private static final Logger LOGGER = Logger.getLogger(RenameJobRequest.class.getName());

    public RenameJobRequest(String requestType, String username, String project, String projectFullName, String newName) {
        super(requestType, username, project, projectFullName, newName);
        this.newName = newName;
    }

    @Override
    public String getMessage() {
        return Messages.RenameJobRequest_message(this.project, this.newName);
    }

    public String getNewName() {
        return this.newName;
    }

    @Override
    public boolean execute(Item item) {
        boolean success = false;
        try {
            if (Jenkins.get().hasPermission(Item.DELETE) && Jenkins.get().hasPermission(Item.CREATE)) {
                ((Job)item).renameTo(this.newName);
                success = true;
                LOGGER.log(Level.INFO, "The jobs {0} has been properly renamed in {1}", new Object[]{item.getName(), this.newName});
            } else {
                this.errorMessage = "The current user " + this.username + " has no permission to rename the job";
                LOGGER.log(Level.FINE, "The current user {0} has no permission to RENAME the job", new Object[]{this.username});
            }
        }
        catch (NullPointerException e) {
            this.errorMessage = e.getMessage();
            LOGGER.log(Level.SEVERE, "Unable to rename the job " + item.getName(), e.getMessage());
        }
        catch (IOException e) {
            this.errorMessage = e.getMessage();
            LOGGER.log(Level.SEVERE, "Unable to rename the job " + item.getName(), e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.errorMessage = e.getMessage();
            LOGGER.log(Level.SEVERE, "Unable to rename the job " + item.getName(), e.getMessage());
        }
        return success;
    }
}

