/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.queuecleanup;

import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.PeriodicWork;
import hudson.model.Queue;
import hudson.util.FormValidation;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"queue-cleanup"})
public class QueueCleanup
extends PeriodicWork
implements Describable<QueueCleanup> {
    private static final String PERIOD_KEY = QueueCleanup.class.getName() + ".period";
    private static final Logger LOGGER = Logger.getLogger(QueueCleanup.class.getName());
    private static final Integer QUEUE_CLEANUP_PERIOD;

    public long getRecurrencePeriod() {
        return (long)QUEUE_CLEANUP_PERIOD.intValue() * 3600000L;
    }

    protected void doRun() throws Exception {
        String pattern = this.getDescriptor().getItemPattern();
        int timeout = this.getDescriptor().getTimeout();
        long timeoutMillis = (long)timeout * 3600000L;
        LOGGER.log(Level.INFO, "Queue clenaup started. Max time to wait is {0} hours. Pattern is {1}", new String[]{Integer.toString(timeout), pattern});
        Queue queue = Jenkins.getActiveInstance().getQueue();
        if (queue != null) {
            Queue.Item[] items = queue.getItems();
            long currTime = System.currentTimeMillis();
            for (Queue.Item item : items) {
                long inQueue = currTime - item.getInQueueSince();
                if (inQueue <= timeoutMillis || !item.task.getDisplayName().matches(pattern)) continue;
                queue.cancel(item);
                LOGGER.log(Level.WARNING, "Item {0} removed from queue after {1}", new String[]{item.task.getFullDisplayName(), Util.getTimeSpanString((long)inQueue)});
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    static {
        Integer period = 1;
        try {
            period = Integer.valueOf(System.getProperty(PERIOD_KEY, period.toString()));
        }
        catch (NumberFormatException e) {
            LOGGER.warning(String.format("Cannot convert string %s to integer, using dafault %d", System.getProperty(PERIOD_KEY), period));
        }
        finally {
            QUEUE_CLEANUP_PERIOD = period;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<QueueCleanup> {
        private int timeout = 24;
        private String itemPattern = ".*";

        public DescriptorImpl() {
            super(QueueCleanup.class);
            this.load();
        }

        public int getTimeout() {
            return this.timeout < 1 ? 24 : this.timeout;
        }

        public String getItemPattern() {
            try {
                Pattern.compile(this.itemPattern);
            }
            catch (PatternSyntaxException ex) {
                return ".*";
            }
            return this.itemPattern;
        }

        @DataBoundSetter
        public void setItemPattern(String itemPattern) {
            this.itemPattern = itemPattern;
        }

        @DataBoundSetter
        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try {
                this.timeout = Integer.parseInt(formData.getString("timeout"));
            }
            catch (NumberFormatException e) {
                this.timeout = 24;
            }
            this.itemPattern = formData.getString("itemPattern");
            this.save();
            return true;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckItemPattern(@QueryParameter String itemPattern) {
            try {
                Pattern.compile(itemPattern);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException ex) {
                return FormValidation.errorWithMarkup((String)("Not a regular expression: <pre>" + ex.getMessage() + "</pre>"));
            }
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckTimeout(@QueryParameter String timeout) {
            try {
                if (Integer.parseInt(timeout) > 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Not a positive number");
        }

        public String getDisplayName() {
            return "Queue cleanup";
        }
    }
}

