/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotPublisher;
import hudson.plugins.plot.PlotReport;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PlotAction
implements Action,
StaplerProxy {
    private final Job<?, ?> project;
    private PlotPublisher publisher;

    public PlotAction(AbstractProject<?, ?> project, PlotPublisher publisher) {
        this.project = project;
        this.publisher = publisher;
    }

    public PlotAction(Job<?, ?> job, List<Plot> plots) {
        this.project = job;
        this.publisher = new PlotPublisher();
        if (plots != null) {
            this.publisher.setPlots(plots);
        }
    }

    public String getIconFileName() {
        return "graph.png";
    }

    public String getDisplayName() {
        return Messages.Plot_Action_DisplayName();
    }

    public String getUrlName() {
        return Messages.Plot_UrlName();
    }

    public boolean hasPlots() throws IOException {
        return CollectionUtils.isNotEmpty(this.publisher.getPlots());
    }

    @Deprecated
    public AbstractProject<?, ?> getProject() {
        return this.project instanceof AbstractProject ? (AbstractProject)this.project : null;
    }

    public Job<?, ?> getJob() {
        return this.project;
    }

    public List<String> getOriginalGroups() {
        return this.publisher.getOriginalGroups();
    }

    public String getUrlGroup(String originalGroup) {
        return this.publisher.originalGroupToUrlEncodedGroup(originalGroup);
    }

    public PlotReport getDynamic(String group, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return new PlotReport(this.project, this.publisher.urlGroupToOriginalGroup(this.getUrlGroup(group)), this.publisher.getPlots(this.getUrlGroup(group)));
    }

    public Object getTarget() {
        List<String> groups = this.getOriginalGroups();
        if (groups != null && groups.size() == 1) {
            return new PlotReport(this.project, groups.get(0), this.publisher.getPlots(this.getUrlGroup(groups.get(0))));
        }
        return this;
    }
}

