/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.PlotPoint;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.SeriesFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CSVSeries
extends Series {
    private static final transient Logger LOGGER = Logger.getLogger(CSVSeries.class.getName());
    private static final transient Level DEFAULT_LOG_LEVEL = Level.FINEST;
    private static final transient Pattern PAT_SEMICOLON_ENCLOSURE = Pattern.compile("\"(.*?)\"");
    private static final transient Pattern PAT_COMMA = Pattern.compile(",");
    private Set<String> strExclusionSet;
    private Set<Integer> colExclusionSet;
    private InclusionFlag inclusionFlag = InclusionFlag.OFF;
    private String exclusionValues;
    private List<String> exclusionValuesList;
    private String url;
    private boolean displayTableFlag;

    @DataBoundConstructor
    public CSVSeries(String file, String url, String inclusionFlag, String exclusionValues, boolean displayTableFlag) {
        super(file, "", "csv");
        this.url = url;
        this.displayTableFlag = displayTableFlag;
        this.exclusionValues = exclusionValues;
        if (this.exclusionValues == null) {
            this.inclusionFlag = InclusionFlag.OFF;
        } else {
            this.inclusionFlag = InclusionFlag.valueOf(inclusionFlag);
            this.exclusionValuesList = new ArrayList<String>();
            Matcher m = PAT_SEMICOLON_ENCLOSURE.matcher(this.exclusionValues);
            int results = 0;
            while (m.find()) {
                this.exclusionValuesList.add(m.group().replaceAll("\"", ""));
                ++results;
            }
            if (results == 0) {
                this.exclusionValuesList = Arrays.asList(PAT_COMMA.split(this.exclusionValues));
            }
        }
        this.loadExclusionSet();
    }

    public String getInclusionFlag() {
        return ObjectUtils.toString((Object)((Object)this.inclusionFlag));
    }

    public String getExclusionValues() {
        return this.exclusionValues;
    }

    public List<String> getExclusionValuesList() {
        return this.exclusionValuesList;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getDisplayTableFlag() {
        return this.displayTableFlag;
    }

    @Override
    public List<PlotPoint> loadSeries(FilePath workspaceRootDir, int buildNumber, PrintStream logger) {
        Object[] seriesFiles;
        List<PlotPoint> plotPoints = null;
        try {
            seriesFiles = workspaceRootDir.list(this.getFile());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception trying to retrieve series files", e);
            return null;
        }
        if (ArrayUtils.isEmpty((Object[])seriesFiles)) {
            LOGGER.info("No plot data file found: " + workspaceRootDir.getName() + " " + this.getFile());
            return null;
        }
        for (Object seriesFile : seriesFiles) {
            List<PlotPoint> seriesList = this.loadSeriesFile((FilePath)seriesFile, buildNumber);
            if (seriesList == null) continue;
            if (plotPoints != null) {
                plotPoints.addAll(seriesList);
                continue;
            }
            plotPoints = seriesList;
        }
        return plotPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<PlotPoint> loadSeriesFile(FilePath seriesFile, int buildNumber) {
        CSVReader reader = null;
        InputStream in = null;
        InputStreamReader inputReader = null;
        try {
            ArrayList<PlotPoint> ret = new ArrayList<PlotPoint>();
            try {
                if (LOGGER.isLoggable(DEFAULT_LOG_LEVEL)) {
                    LOGGER.log(DEFAULT_LOG_LEVEL, "Loading plot series data from: " + this.getFile());
                }
                in = seriesFile.read();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception reading plot series data from " + seriesFile, e);
                List<PlotPoint> list = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        LOGGER.log(Level.SEVERE, "Failed to close series reader", e2);
                    }
                }
                IOUtils.closeQuietly((Reader)inputReader);
                IOUtils.closeQuietly((InputStream)in);
                return list;
            }
            if (LOGGER.isLoggable(DEFAULT_LOG_LEVEL)) {
                LOGGER.log(DEFAULT_LOG_LEVEL, "Loaded CSV Plot file: " + this.getFile());
            }
            inputReader = new InputStreamReader(in, Charset.defaultCharset().name());
            reader = new CSVReader((Reader)inputReader);
            String[] headerLine = reader.readNext();
            int lineNum = 0;
            while (true) {
                String[] nextLine;
                if ((nextLine = reader.readNext()) != null) {
                    if (nextLine.length == 1 && nextLine[0].length() == 0) continue;
                } else {
                    ArrayList<PlotPoint> arrayList = ret;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Failed to close series reader", e);
                        }
                    }
                    IOUtils.closeQuietly((Reader)inputReader);
                    IOUtils.closeQuietly((InputStream)in);
                    return arrayList;
                }
                for (int index = 0; index < nextLine.length; ++index) {
                    String label = null;
                    String yvalue = nextLine[index].trim();
                    if (yvalue.trim().length() == 0) continue;
                    if (index < headerLine.length) {
                        label = headerLine[index].trim();
                    }
                    if (label == null || label.length() <= 0) {
                        label = "" + index;
                    }
                    if (!this.excludePoint(label, index)) {
                        PlotPoint point = new PlotPoint(yvalue, this.getUrl(this.url, label, index, buildNumber), label);
                        if (LOGGER.isLoggable(DEFAULT_LOG_LEVEL)) {
                            LOGGER.log(DEFAULT_LOG_LEVEL, "CSV Point: [" + index + ":" + lineNum + "]" + point);
                        }
                        ret.add(point);
                        continue;
                    }
                    if (!LOGGER.isLoggable(DEFAULT_LOG_LEVEL)) continue;
                    LOGGER.log(DEFAULT_LOG_LEVEL, "excluded CSV Column: " + index + " : " + label);
                }
                ++lineNum;
            }
        }
        catch (IOException ioe) {
            block28: {
                try {
                    LOGGER.log(Level.SEVERE, "Exception loading series", ioe);
                    if (reader == null) break block28;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Failed to close series reader", e);
                        }
                    }
                    IOUtils.closeQuietly(inputReader);
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to close series reader", e);
                }
            }
            IOUtils.closeQuietly(inputReader);
            IOUtils.closeQuietly((InputStream)in);
            return null;
        }
    }

    private boolean excludePoint(String label, int index) {
        boolean retVal;
        if (this.inclusionFlag == null || this.inclusionFlag == InclusionFlag.OFF) {
            return false;
        }
        switch (this.inclusionFlag) {
            case INCLUDE_BY_STRING: {
                retVal = !this.checkExclusionSet(label);
                break;
            }
            case EXCLUDE_BY_STRING: {
                retVal = this.checkExclusionSet(label);
                break;
            }
            case INCLUDE_BY_COLUMN: {
                retVal = !this.colExclusionSet.contains(index);
                break;
            }
            case EXCLUDE_BY_COLUMN: {
                retVal = this.colExclusionSet.contains(index);
                break;
            }
            default: {
                retVal = false;
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest((retVal ? "excluded" : "included") + " CSV Column: " + index + " : " + label);
        }
        return retVal;
    }

    private boolean checkExclusionSet(String label) {
        if (this.strExclusionSet.contains(label)) {
            return true;
        }
        for (String s : this.strExclusionSet) {
            if (!this.checkPatternIsValid(s) || !label.matches(s)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPatternIsValid(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private void loadExclusionSet() {
        if (this.inclusionFlag == InclusionFlag.OFF) {
            return;
        }
        if (this.exclusionValues == null) {
            this.inclusionFlag = InclusionFlag.OFF;
            return;
        }
        switch (this.inclusionFlag) {
            case INCLUDE_BY_STRING: 
            case EXCLUDE_BY_STRING: {
                this.strExclusionSet = new HashSet<String>();
                break;
            }
            case INCLUDE_BY_COLUMN: 
            case EXCLUDE_BY_COLUMN: {
                this.colExclusionSet = new HashSet<Integer>();
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, "Failed to initialize columns exclusions set.");
            }
        }
        block10: for (String str : this.exclusionValuesList) {
            if (str == null || str.length() <= 0) continue;
            switch (this.inclusionFlag) {
                case INCLUDE_BY_STRING: 
                case EXCLUDE_BY_STRING: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest((Object)((Object)this.inclusionFlag) + " CSV Column: " + str);
                    }
                    this.strExclusionSet.add(str);
                    continue block10;
                }
                case INCLUDE_BY_COLUMN: 
                case EXCLUDE_BY_COLUMN: {
                    try {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest((Object)((Object)this.inclusionFlag) + " CSV Column: " + str);
                        }
                        this.colExclusionSet.add(Integer.valueOf(str));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.SEVERE, "Exception converting to integer", nfe);
                    }
                    continue block10;
                }
            }
            LOGGER.log(Level.SEVERE, "Failed to identify columns exclusions.");
        }
    }

    @Override
    public Descriptor<Series> getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Series> {
        public String getDisplayName() {
            return Messages.Plot_CsvSeries();
        }

        public Series newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return SeriesFactory.createSeries(formData, req);
        }
    }

    public static enum InclusionFlag {
        OFF,
        INCLUDE_BY_STRING,
        EXCLUDE_BY_STRING,
        INCLUDE_BY_COLUMN,
        EXCLUDE_BY_COLUMN;

    }
}

