/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.PropertiesSeries;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.XMLSeries;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class SeriesFactory {
    private SeriesFactory() {
    }

    public static Series createSeries(JSONObject formData, StaplerRequest req) {
        String file = formData.getString("file");
        formData = formData.getJSONObject("fileType");
        formData.put("file", (Object)file);
        String type = formData.getString("value");
        Class typeClass = null;
        if ("properties".equals(type)) {
            typeClass = PropertiesSeries.class;
        } else if ("csv".equals(type)) {
            typeClass = CSVSeries.class;
        } else if ("xml".equals(type)) {
            typeClass = XMLSeries.class;
        }
        return typeClass != null ? (Series)((Object)req.bindJSON(typeClass, formData)) : null;
    }

    public static List<Series> createSeriesList(Object data, StaplerRequest req) {
        JSONArray list = SeriesFactory.getArray(data);
        ArrayList<Series> result = new ArrayList<Series>();
        for (Object series : list) {
            result.add(SeriesFactory.createSeries((JSONObject)series, req));
        }
        return result;
    }

    public static JSONArray getArray(Object data) {
        JSONArray result;
        if (data instanceof JSONArray) {
            result = (JSONArray)data;
        } else {
            result = new JSONArray();
            if (data != null) {
                result.add(data);
            }
        }
        return result;
    }
}

