/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.PlotBuildAction;
import hudson.plugins.plot.PropertiesSeries;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.XMLSeries;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PlotBuilder
extends Builder
implements SimpleBuildStep {
    private final String group;
    private final String title;
    private final String numBuilds;
    private final String yaxis;
    private final String style;
    private final Boolean useDescr;
    private final Boolean exclZero;
    private final Boolean logarithmic;
    private final Boolean keepRecords;
    private final String yaxisMinimum;
    private final String yaxisMaximum;
    public String csvFileName;
    public List<Series> series;
    public List<CSVSeries> csvSeries;
    public List<PropertiesSeries> propertiesSeries;
    public List<XMLSeries> xmlSeries;
    private List<Plot> plots;

    @DataBoundConstructor
    public PlotBuilder(String group, String title, String numBuilds, String yaxis, String style, Boolean useDescr, Boolean exclZero, Boolean logarithmic, Boolean keepRecords, String yaxisMinimum, String yaxisMaximum, String csvFileName, List<CSVSeries> csvSeries, List<PropertiesSeries> propertiesSeries, List<XMLSeries> xmlSeries) {
        this.group = group;
        this.title = title;
        this.numBuilds = numBuilds;
        this.yaxis = yaxis;
        this.style = style;
        this.useDescr = useDescr;
        this.exclZero = exclZero;
        this.logarithmic = logarithmic;
        this.keepRecords = keepRecords;
        this.yaxisMinimum = yaxisMinimum;
        this.yaxisMaximum = yaxisMaximum;
        this.csvFileName = csvFileName;
        this.csvSeries = csvSeries;
        this.propertiesSeries = propertiesSeries;
        this.xmlSeries = xmlSeries;
        this.series = new ArrayList<Series>();
        if (csvSeries != null) {
            this.series.addAll(csvSeries);
        }
        if (xmlSeries != null) {
            this.series.addAll(xmlSeries);
        }
        if (propertiesSeries != null) {
            this.series.addAll(propertiesSeries);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getTitle() {
        return this.title;
    }

    public String getNumBuilds() {
        return this.numBuilds;
    }

    public String getYaxis() {
        return this.yaxis;
    }

    public String getStyle() {
        return this.style;
    }

    public Boolean getUseDescr() {
        return this.useDescr;
    }

    public Boolean getExclZero() {
        return this.exclZero;
    }

    public Boolean getLogarithmic() {
        return this.logarithmic;
    }

    public Boolean getKeepRecords() {
        return this.keepRecords;
    }

    public String getYaxisMinimum() {
        return this.yaxisMinimum;
    }

    public String getYaxisMaximum() {
        return this.yaxisMaximum;
    }

    public List<Series> getSeries() {
        return this.series;
    }

    public List<CSVSeries> getCsvSeries() {
        return this.csvSeries;
    }

    public List<PropertiesSeries> getPropertiesSeries() {
        return this.propertiesSeries;
    }

    public List<XMLSeries> getXmlSeries() {
        return this.xmlSeries;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        this.plots = new ArrayList<Plot>();
        Plot plot = new Plot(this.title, this.yaxis, this.group, this.numBuilds, this.csvFileName, this.style, false, false, false, false, this.yaxisMinimum, this.yaxisMaximum);
        plot.series = this.series;
        plot.addBuild(build, listener.getLogger(), workspace);
        this.plots.add(plot);
        PlotBuildAction buildAction = (PlotBuildAction)build.getAction(PlotBuildAction.class);
        if (buildAction == null) {
            build.addAction((Action)new PlotBuildAction(build, this.plots));
        } else {
            buildAction.addPlots(this.plots);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"plot"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getCsvFileName() {
            return "plot-" + UUID.randomUUID().toString() + ".csv";
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.isEmpty()) {
                return FormValidation.error((String)"Please set a group");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the group too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Plot_Publisher_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

