/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import hudson.model.AbstractProject;
import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.Messages;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.Series;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotReport {
    private static final Logger LOGGER = Logger.getLogger(PlotReport.class.getName());
    private final AbstractProject<?, ?> project;
    private List<Plot> plots;
    private String group;

    public PlotReport(AbstractProject<?, ?> project, String group, List<Plot> plots) {
        Collections.sort(plots);
        this.plots = plots;
        this.group = group;
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public List<Plot> getPlots() {
        return this.plots;
    }

    public void doGetPlot(StaplerRequest req, StaplerResponse rsp) {
        String i = req.getParameter("index");
        Plot plot = this.getPlot(i);
        try {
            plot.plotGraph(req, rsp);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Exception plotting graph", ioe);
        }
    }

    public void doGetPlotMap(StaplerRequest req, StaplerResponse rsp) {
        String i = req.getParameter("index");
        Plot plot = this.getPlot(i);
        try {
            plot.plotGraphMap(req, rsp);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Exception plotting graph", ioe);
        }
    }

    public boolean getDisplayTableFlag(int i) {
        Plot plot = this.getPlot(i);
        if (CollectionUtils.isNotEmpty(plot.getSeries())) {
            Series series = plot.getSeries().get(0);
            return series instanceof CSVSeries && ((CSVSeries)series).getDisplayTableFlag();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getTable(int i) {
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        Plot plot = this.getPlot(i);
        File plotFile = new File(this.project.getRootDir(), plot.getCsvFileName());
        if (!plotFile.exists()) {
            return tableData;
        }
        CSVReader reader = null;
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(plotFile));
            reader.readNext();
            reader.readNext();
            ArrayList<String> header = new ArrayList<String>();
            header.add(Messages.Plot_Build() + " #");
            tableData.add(header);
            while ((nextLine = reader.readNext()) != null) {
                String buildNumber = nextLine[2];
                if (this.project.getBuildByNumber(Integer.parseInt(buildNumber)) == null) continue;
                String seriesLabel = nextLine[1];
                int n = header.lastIndexOf(seriesLabel);
                if (n <= 0) {
                    n = header.size();
                    header.add(seriesLabel);
                }
                List<String> tableRow = null;
                for (int j = 1; j < tableData.size(); ++j) {
                    List r = (List)tableData.get(j);
                    if (!StringUtils.equals((String)((String)r.get(0)), (String)buildNumber)) continue;
                    tableRow = r;
                    break;
                }
                if (tableRow == null) {
                    tableRow = new ArrayList<String>();
                    tableRow.add(buildNumber);
                    tableData.add(tableRow);
                }
                String value = nextLine[0];
                if (n < tableRow.size()) {
                    tableRow.set(n, value);
                    continue;
                }
                for (int j = tableRow.size(); j < n; ++j) {
                    tableRow.add("");
                }
                tableRow.add(value);
            }
            int lastColumn = ((List)tableData.get(0)).size();
            for (List list : tableData) {
                for (int j = list.size(); j < lastColumn; ++j) {
                    list.add("");
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Exception reading csv file", ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return tableData;
    }

    private Plot getPlot(int i) {
        Plot p = this.plots.get(i);
        p.setProject(this.project);
        return p;
    }

    private Plot getPlot(String i) {
        try {
            return this.getPlot(Integer.valueOf(i));
        }
        catch (NumberFormatException ignore) {
            LOGGER.log(Level.SEVERE, "Exception converting to integer", ignore);
            return null;
        }
    }
}

