/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.PropertiesSeries;
import hudson.plugins.plot.Series;
import hudson.plugins.plot.XMLSeries;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class SeriesFactory {
    public static Series createSeries(JSONObject formData, StaplerRequest req) {
        String file = formData.getString("file");
        formData = formData.getJSONObject("fileType");
        formData.put("file", (Object)file);
        String type = formData.getString("value");
        Class typeClass = null;
        if ("properties".equals(type)) {
            typeClass = PropertiesSeries.class;
        } else if ("csv".equals(type)) {
            typeClass = CSVSeries.class;
        } else if ("xml".equals(type)) {
            typeClass = XMLSeries.class;
        }
        return typeClass != null ? (Series)req.bindJSON(typeClass, formData) : null;
    }

    public static Series[] createSeriesList(Object data, StaplerRequest req) {
        JSONArray list = SeriesFactory.getArray(data);
        Series[] result = new Series[list.size()];
        int i = 0;
        for (Object series : list) {
            result[i++] = SeriesFactory.createSeries((JSONObject)series, req);
        }
        return result;
    }

    public static JSONArray getArray(Object data) {
        JSONArray result;
        if (data instanceof JSONArray) {
            result = (JSONArray)data;
        } else {
            result = new JSONArray();
            if (data != null) {
                result.add(data);
            }
        }
        return result;
    }
}

