/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.plot;

import au.com.bytecode.opencsv.CSVReader;
import hudson.model.Project;
import hudson.plugins.plot.CSVSeries;
import hudson.plugins.plot.Plot;
import hudson.plugins.plot.Series;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class PlotReport {
    private static final Logger LOGGER = Logger.getLogger(PlotReport.class.getName());
    private final Project project;
    private Plot[] plots;
    private String group;

    public PlotReport(Project project, String group, Plot[] plots) {
        Arrays.sort(plots);
        this.plots = plots;
        this.group = group;
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public String getGroup() {
        return this.group;
    }

    public Plot[] getPlots() {
        return this.plots;
    }

    public void doGetPlot(StaplerRequest req, StaplerResponse rsp) {
        String i = req.getParameter("index");
        Plot plot = this.getPlot(i);
        try {
            plot.plotGraph(req, rsp);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "Exception plotting graph", ioe);
        }
    }

    public void doGetPlotMap(StaplerRequest req, StaplerResponse rsp) {
        String i = req.getParameter("index");
        Plot plot = this.getPlot(i);
        try {
            plot.plotGraphMap(req, rsp);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "Exception plotting graph", ioe);
        }
    }

    public boolean getDisplayTableFlag(int i) {
        Plot plot = this.getPlot(Integer.toString(i));
        if (plot.getSeries() != null) {
            Series series = plot.getSeries()[0];
            return series instanceof CSVSeries && ((CSVSeries)series).getDisplayTableFlag();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTable(int i) {
        ArrayList tableData = new ArrayList();
        Plot plot = this.getPlot("" + i);
        File tableFile = new File(this.project.getRootDir(), "table_" + plot.getCsvFileName());
        if (!tableFile.exists()) {
            return tableData;
        }
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new FileReader(tableFile));
            tableData = (ArrayList)reader.readAll();
        }
        catch (IOException ioe) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return tableData;
    }

    private Plot getPlot(String i) {
        try {
            Plot p = this.plots[Integer.valueOf(i)];
            p.setProject(this.project);
            return p;
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }
}

