/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.kohsuke.stapler.DataBoundConstructor;

public class LoadRunnerParser
extends AbstractParser {
    private String resultQuery = "select     cast(([Start Time] - [Time Zone] + e.[End Time] - e.Value)*1000 as decimal) as timeStamp,     cast(e.Value*1000 as decimal) as elapsed,     [Event Name] as label,     case [Transaction End Status] when 'Pass' then 'true' end as success from Event_meter e join Event_map on Event_map.[Event ID] = e.[Event ID] join TransactionEndStatus on TransactionEndStatus.Status1 = e.Status1 join Result on Result.[Result ID] = e.[Result ID]where [Event Type] = 'Transaction'";

    @DataBoundConstructor
    public LoadRunnerParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.mdb";
    }

    protected String jdbcUrlForFile(File reportFile) throws ClassNotFoundException {
        Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
        return String.format("jdbc:ucanaccess://%s;mirrorFolder=java.io.tmpdir;immediatelyReleaseResources=true", reportFile.getAbsolutePath());
    }

    protected HttpSample getSample(ResultSet res) throws SQLException {
        HttpSample sample = new HttpSample();
        sample.setDate(new Date(res.getLong(1)));
        sample.setDuration(res.getLong(2));
        sample.setUri(res.getString(3));
        sample.setSuccessful(Boolean.parseBoolean(res.getString(4)));
        return sample;
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        PerformanceReport report = new PerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setReportFileName(reportFile.getName());
        try (Connection con = DriverManager.getConnection(this.jdbcUrlForFile(reportFile));
             Statement stmt = con.createStatement();
             ResultSet res = stmt.executeQuery(this.getResultQuery());){
            while (res.next()) {
                report.addSample(this.getSample(res));
            }
        }
        return report;
    }

    protected String getResultQuery() {
        return this.resultQuery;
    }

    protected void setResultQuery(String resultQuery) {
        this.resultQuery = resultQuery;
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "LoadRunner";
        }
    }
}

