/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.Extension;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.reports.PerformanceReport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import javax.xml.parsers.SAXParserFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMeterParser
extends AbstractParser {
    @DataBoundConstructor
    public JMeterParser(String glob) {
        super(glob);
    }

    @Override
    public String getDefaultGlobPattern() {
        return "**/*.jtl";
    }

    @Override
    PerformanceReport parse(File reportFile) throws Exception {
        boolean isXml = JMeterParser.isXmlFile(reportFile);
        if (isXml) {
            return this.parseXml(reportFile);
        }
        return this.parseCsv(reportFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXmlFile(File file) throws IOException {
        try (BufferedReader reader = null;){
            String firstLine;
            reader = new BufferedReader(new FileReader(file));
            while ((firstLine = reader.readLine()) != null) {
                if (firstLine.trim().length() == 0) continue;
                boolean bl = firstLine != null && firstLine.toLowerCase().trim().startsWith("<?xml ");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    PerformanceReport parseXml(File reportFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        final PerformanceReport report = new PerformanceReport();
        report.setExcludeResponseTime(this.excludeResponseTime);
        report.setReportFileName(reportFile.getName());
        factory.newSAXParser().parse(reportFile, new DefaultHandler(){
            HttpSample currentSample;
            int counter = 0;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!"httpSample".equalsIgnoreCase(qName) && !"sample".equalsIgnoreCase(qName)) {
                    return;
                }
                HttpSample sample = new HttpSample();
                String dateValue = attributes.getValue("ts") != null ? attributes.getValue("ts") : attributes.getValue("timeStamp");
                sample.setDate(new Date(Long.valueOf(dateValue)));
                String durationValue = attributes.getValue("t") != null ? attributes.getValue("t") : attributes.getValue("time");
                sample.setDuration(Long.valueOf(durationValue));
                String successfulValue = attributes.getValue("s") != null ? attributes.getValue("s") : attributes.getValue("success");
                sample.setSuccessful(Boolean.parseBoolean(successfulValue));
                String uriValue = attributes.getValue("lb") != null ? attributes.getValue("lb") : attributes.getValue("label");
                sample.setUri(uriValue);
                String httpCodeValue = attributes.getValue("rc") != null && attributes.getValue("rc").length() <= 3 ? attributes.getValue("rc") : "0";
                sample.setHttpCode(httpCodeValue);
                String sizeInKbValue = attributes.getValue("by") != null ? attributes.getValue("by") : "0";
                sample.setSizeInKb(Double.valueOf(sizeInKbValue) / 1024.0);
                if (this.counter == 0) {
                    this.currentSample = sample;
                }
                ++this.counter;
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                if ("httpSample".equalsIgnoreCase(qName) || "sample".equalsIgnoreCase(qName)) {
                    if (this.counter == 1) {
                        try {
                            report.addSample(this.currentSample);
                        }
                        catch (SAXException e) {
                            e.printStackTrace();
                        }
                    }
                    --this.counter;
                }
            }
        });
        return report;
    }

    PerformanceReport parseCsv(File reportFile) throws Exception {
        JMeterCsvParser delegate = new JMeterCsvParser(this.glob);
        return delegate.parse(reportFile);
    }

    @Extension
    public static class DescriptorImpl
    extends PerformanceReportParserDescriptor {
        public String getDisplayName() {
            return "JMeter";
        }
    }
}

