/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.parsers;

import hudson.plugins.performance.parsers.IagoParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.JUnitParser;
import hudson.plugins.performance.parsers.JmeterSummarizerParser;
import hudson.plugins.performance.parsers.TaurusParser;
import hudson.plugins.performance.parsers.WrkSummarizerParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserDetector {
    /*
     * Loose catch block
     */
    public static String detect(String reportPath) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(new File(reportPath)));
        Throwable throwable = null;
        String line = reader.readLine();
        if (line == null) {
            throw new IllegalArgumentException("File " + reportPath + " is empty");
        }
        if (line.startsWith("<?xml")) {
            String string = ParserDetector.detectXMLFileType(reportPath);
            return string;
        }
        if (ParserDetector.isIagoFileType(line)) {
            String string = IagoParser.class.getSimpleName();
            return string;
        }
        if (ParserDetector.isWRKFileType(line)) {
            String string = WrkSummarizerParser.class.getSimpleName();
            return string;
        }
        if (ParserDetector.isJMeterCSVFileType(line)) {
            String string = JMeterCsvParser.class.getSimpleName();
            return string;
        }
        if (ParserDetector.isJMeterSummarizerFileType(line, reader)) {
            String string = JmeterSummarizerParser.class.getSimpleName();
            return string;
        }
        String string = ParserDetector.detectXMLFileType(reportPath);
        return string;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            if (reader != null) {
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    private static boolean isIagoFileType(String line) {
        String patternString = "INF \\[.*\\] stats:.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private static boolean isWRKFileType(String line) {
        String patternString = "Running .*s test @.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(line);
        return matcher.matches();
    }

    private static boolean isJMeterCSVFileType(String header) {
        String line = header.toLowerCase();
        return line.contains("timestamp") && line.contains("elapsed") && (line.contains("url") || line.contains("label"));
    }

    private static boolean isJMeterSummarizerFileType(String firstLine, BufferedReader reader) throws IOException {
        String line = firstLine;
        String pattern = "Summariser: Generate Summary Results";
        if (line.contains(pattern)) {
            return true;
        }
        line = reader.readLine();
        while (line != null) {
            if (line.contains(pattern)) {
                return true;
            }
            line = reader.readLine();
        }
        return false;
    }

    private static String detectXMLFileType(String reportPath) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(reportPath);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            if (ParserDetector.docContainsTag(doc, xpath, "testResults")) {
                return JMeterParser.class.getSimpleName();
            }
            if (ParserDetector.docContainsTag(doc, xpath, "testsuite")) {
                return JUnitParser.class.getSimpleName();
            }
            if (ParserDetector.docContainsTag(doc, xpath, "FinalStatus")) {
                return TaurusParser.class.getSimpleName();
            }
            throw new IllegalArgumentException("Unknown xml file format");
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException ex) {
            throw new RuntimeException("XML parsing error: ", ex);
        }
    }

    private static boolean docContainsTag(Document doc, XPath xpath, String tagName) throws XPathExpressionException {
        XPathExpression expr = xpath.compile("//" + tagName);
        NodeList list = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        return list.getLength() > 0;
    }
}

