/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.performance.Messages;
import hudson.plugins.performance.PerformanceReportMap;
import hudson.plugins.performance.actions.ExternalBuildReportAction;
import hudson.plugins.performance.actions.PerformanceBuildAction;
import hudson.plugins.performance.actions.PerformanceProjectAction;
import hudson.plugins.performance.constraints.AbstractConstraint;
import hudson.plugins.performance.constraints.ConstraintChecker;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.ConstraintFactory;
import hudson.plugins.performance.constraints.blocks.PreviousResultsBlock;
import hudson.plugins.performance.constraints.blocks.TestCaseBlock;
import hudson.plugins.performance.cookie.CookieHandler;
import hudson.plugins.performance.data.ConstraintSettings;
import hudson.plugins.performance.data.HttpSample;
import hudson.plugins.performance.data.PerformanceReportPosition;
import hudson.plugins.performance.data.TaurusFinalStats;
import hudson.plugins.performance.descriptors.ConstraintDescriptor;
import hudson.plugins.performance.descriptors.PerformanceReportParserDescriptor;
import hudson.plugins.performance.details.GraphConfigurationDetail;
import hudson.plugins.performance.details.TestSuiteReportDetail;
import hudson.plugins.performance.details.TrendReportDetail;
import hudson.plugins.performance.parsers.AbstractParser;
import hudson.plugins.performance.parsers.IagoParser;
import hudson.plugins.performance.parsers.JMeterCsvParser;
import hudson.plugins.performance.parsers.JMeterParser;
import hudson.plugins.performance.parsers.JUnitParser;
import hudson.plugins.performance.parsers.JmeterSummarizerParser;
import hudson.plugins.performance.parsers.ParserFactory;
import hudson.plugins.performance.parsers.PerformanceReportParser;
import hudson.plugins.performance.parsers.TaurusParser;
import hudson.plugins.performance.parsers.WrkSummarizerParser;
import hudson.plugins.performance.reports.AbstractReport;
import hudson.plugins.performance.reports.ConstraintReport;
import hudson.plugins.performance.reports.PerformanceReport;
import hudson.plugins.performance.reports.ThroughputReport;
import hudson.plugins.performance.reports.UriReport;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PerformancePublisher
extends Recorder
implements SimpleBuildStep {
    public static final double THRESHOLD_TOLERANCE = 1.0E-8;
    private int errorFailedThreshold = -1;
    private int errorUnstableThreshold = -1;
    private String errorUnstableResponseTimeThreshold = "";
    private double relativeFailedThresholdPositive = 0.0;
    private double relativeFailedThresholdNegative = 0.0;
    private double relativeUnstableThresholdPositive = 0.0;
    private double relativeUnstableThresholdNegative = 0.0;
    private int nthBuildNumber = 0;
    private String configType = "ART";
    private String graphType = "ART";
    private boolean modeOfThreshold = false;
    private boolean failBuildIfNoResultFile = true;
    private boolean compareBuildPrevious = false;
    public static final String ART = "ART";
    public static final String MRT = "MRT";
    public static final String PRT = "PRT";
    public String optionType = "ART";
    File xmlfile = null;
    String xmlDir = null;
    String xml = "";
    private static final String archive_directory = "archive";
    private boolean modePerformancePerTestCase = false;
    private boolean excludeResponseTime;
    private transient String filename;
    private boolean modeThroughput;
    private boolean modeEvaluation = false;
    private List<? extends AbstractConstraint> constraints;
    private boolean ignoreFailedBuilds;
    private boolean ignoreUnstableBuilds;
    private boolean persistConstraintLog;
    @Deprecated
    private transient List<PerformanceReportParser> parsers;
    private String sourceDataFiles;

    @Restricted(value={NoExternalUse.class})
    public PerformancePublisher(String sourceDataFiles, int errorFailedThreshold, int errorUnstableThreshold, String errorUnstableResponseTimeThreshold, double relativeFailedThresholdPositive, double relativeFailedThresholdNegative, double relativeUnstableThresholdPositive, double relativeUnstableThresholdNegative, int nthBuildNumber, boolean modePerformancePerTestCase, String configType, boolean modeOfThreshold, boolean failBuildIfNoResultFile, boolean compareBuildPrevious, boolean modeThroughput, List<PerformanceReportParser> parsers) {
        this.parsers = parsers;
        this.sourceDataFiles = sourceDataFiles;
        this.migrateParsers();
        this.errorFailedThreshold = errorFailedThreshold;
        this.errorUnstableThreshold = errorUnstableThreshold;
        this.errorUnstableResponseTimeThreshold = errorUnstableResponseTimeThreshold;
        this.relativeFailedThresholdPositive = relativeFailedThresholdPositive;
        this.relativeFailedThresholdNegative = relativeFailedThresholdNegative;
        this.relativeUnstableThresholdPositive = relativeUnstableThresholdPositive;
        this.relativeUnstableThresholdNegative = relativeUnstableThresholdNegative;
        this.nthBuildNumber = nthBuildNumber;
        this.configType = configType;
        this.optionType = configType;
        this.modeOfThreshold = modeOfThreshold;
        this.failBuildIfNoResultFile = failBuildIfNoResultFile;
        this.compareBuildPrevious = compareBuildPrevious;
        this.modePerformancePerTestCase = modePerformancePerTestCase;
        this.modeThroughput = modeThroughput;
    }

    @DataBoundConstructor
    public PerformancePublisher(String sourceDataFiles) {
        this.sourceDataFiles = sourceDataFiles;
    }

    public static File getPerformanceReport(Run<?, ?> build, String parserDisplayName, String performanceReportName) {
        return new File(build.getRootDir(), PerformanceReportMap.getPerformanceReportFileRelativePath(parserDisplayName, PerformancePublisher.getPerformanceReportBuildFileName(performanceReportName)));
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PerformanceProjectAction((Job<?, ?>)project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public static String getPerformanceReportBuildFileName(String performanceReportWorkspaceName) {
        Pattern p;
        Matcher matcher;
        String result = performanceReportWorkspaceName;
        if (performanceReportWorkspaceName != null && (matcher = (p = Pattern.compile("-[0-9]*\\.xml")).matcher(performanceReportWorkspaceName)).find()) {
            result = matcher.replaceAll(".xml");
        }
        return result;
    }

    protected static List<FilePath> locatePerformanceReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            String[] parts2 = includes.split("\\s*[;:,]+\\s*");
            ArrayList<FilePath> files = new ArrayList<FilePath>();
            for (String path : parts2) {
                FilePath[] ret = workspace.list(path);
                if (ret.length <= 0) continue;
                files.addAll(Arrays.asList(ret));
            }
            if (!files.isEmpty()) {
                return files;
            }
        }
        catch (IOException parts2) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/*")));
                continue;
            }
            files.add(src);
        }
        if (!files.isEmpty()) {
            return files;
        }
        File directFile = new File(includes);
        if (directFile.exists()) {
            files.add(new FilePath(directFile));
        }
        return files;
    }

    protected List<PerformanceReportParser> getParsers(Run<?, ?> build, FilePath workspace, PrintStream logger, EnvVars env) throws IOException, InterruptedException {
        ArrayList<PerformanceReportParser> parsers = new ArrayList<PerformanceReportParser>();
        if (this.sourceDataFiles != null) {
            for (String filePath : this.sourceDataFiles.split(";")) {
                if (filePath.isEmpty()) continue;
                try {
                    parsers.add(ParserFactory.getParser(build, workspace, logger, filePath, env));
                }
                catch (IOException ex) {
                    logger.println("Cannot detect file type because of error: " + ex.getMessage());
                }
            }
        }
        return parsers;
    }

    private void migrateParsers() {
        if (this.parsers != null && !this.parsers.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (PerformanceReportParser p : this.parsers) {
                builder.append(p.glob).append(';');
            }
            builder.setLength(builder.length() - 1);
            this.sourceDataFiles = this.sourceDataFiles == null || this.sourceDataFiles.equals("") ? builder.toString() : this.sourceDataFiles + ";" + builder.toString();
            this.parsers = null;
        }
    }

    public Object readResolve() {
        if (this.parsers == null) {
            this.parsers = new ArrayList<PerformanceReportParser>();
        }
        if (this.filename != null) {
            this.parsers.add(new JMeterParser(this.filename));
            this.filename = null;
        }
        this.migrateParsers();
        return this;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        run.setResult(Result.SUCCESS);
        List<PerformanceReportParser> parsers = this.getParsers(run, workspace, listener.getLogger(), run.getEnvironment(listener));
        if (!parsers.isEmpty()) {
            this.prepareParsers(parsers);
            Collection<PerformanceReport> parsedReports = this.prepareEvaluation(run, workspace, listener, parsers);
            if (parsedReports == null) {
                return;
            }
            if (!this.modeEvaluation) {
                this.evaluateInStandardMode(run, workspace, parsedReports, listener, parsers);
            } else {
                this.evaluateInExpertMode(run, listener);
            }
        } else if (this.failBuildIfNoResultFile) {
            run.setResult(Result.FAILURE);
        }
    }

    public Collection<PerformanceReport> prepareEvaluation(Run<?, ?> run, FilePath workspace, TaskListener listener, List<PerformanceReportParser> parsers) throws IOException, InterruptedException {
        PerformanceBuildAction a = new PerformanceBuildAction(run, listener.getLogger(), parsers);
        run.addAction((Action)a);
        Collection<PerformanceReport> parsedReports = this.locatePerformanceReports(run, workspace, listener, parsers);
        if (parsedReports == null) {
            return null;
        }
        this.addExternalReportActionsToBuild(run, parsers);
        for (PerformanceReport r : parsedReports) {
            r.setBuildAction(a);
        }
        return parsedReports;
    }

    private void addExternalReportActionsToBuild(Run<?, ?> run, List<PerformanceReportParser> parsers) {
        for (PerformanceReportParser parser : parsers) {
            if (parser.reportURL == null || parser.reportURL.isEmpty()) continue;
            run.addAction((Action)new ExternalBuildReportAction(parser.reportURL));
        }
    }

    private Collection<PerformanceReport> locatePerformanceReports(Run<?, ?> run, FilePath workspace, TaskListener listener, List<PerformanceReportParser> parsers) throws IOException, InterruptedException {
        ArrayList<PerformanceReport> performanceReports = new ArrayList<PerformanceReport>();
        PrintStream logger = listener.getLogger();
        EnvVars env = run.getEnvironment(listener);
        for (PerformanceReportParser parser : parsers) {
            String glob = parser.glob;
            glob = env.expand(glob);
            logger.println("Performance: Recording " + parser.getReportName() + " reports '" + glob + "'");
            List<FilePath> files = PerformancePublisher.locatePerformanceReports(workspace, glob);
            if (files.isEmpty()) {
                if (run.getResult().isWorseThan(Result.UNSTABLE)) {
                    return null;
                }
                if (this.failBuildIfNoResultFile) {
                    run.setResult(Result.FAILURE);
                }
                logger.println("Performance: no " + parser.getReportName() + " files matching '" + glob + "' have been found. Has the report generated?. Setting Build to " + run.getResult());
                return null;
            }
            List<File> localReports = this.copyReportsToMaster(run, logger, files, parser.getDescriptor().getDisplayName());
            performanceReports.addAll(parser.parse(run, localReports, listener));
        }
        return performanceReports;
    }

    private void prepareParsers(Collection<PerformanceReportParser> performanceReportParsers) {
        for (PerformanceReportParser parser : performanceReportParsers) {
            parser.setExcludeResponseTime(this.excludeResponseTime);
        }
    }

    private List<UriReport> getBuildUriReports(Run<?, ?> build, FilePath workspace, TaskListener listener, List<PerformanceReportParser> parsers, boolean locatePerformanceReports) throws IOException, InterruptedException {
        ArrayList<UriReport> uriReports = new ArrayList<UriReport>();
        if (locatePerformanceReports) {
            Collection<PerformanceReport> performanceReports = this.locatePerformanceReports(build, workspace, listener, parsers);
            if (performanceReports == null) {
                return null;
            }
            for (PerformanceReport r : performanceReports) {
                uriReports.addAll(r.getUriListOrdered());
            }
        } else {
            HashSet<PerformanceReport> parsedReports = new HashSet<PerformanceReport>();
            for (PerformanceReportParser parser : parsers) {
                List<File> localReports = this.getExistingReports(build, listener.getLogger(), parser.getDescriptor().getDisplayName());
                parsedReports.addAll(parser.parse(build, localReports, listener));
            }
            for (PerformanceReport r : parsedReports) {
                uriReports.addAll(r.getUriListOrdered());
            }
        }
        return uriReports;
    }

    public void evaluateInStandardMode(Run<?, ?> run, FilePath workspace, Collection<PerformanceReport> parsedReports, TaskListener listener, List<PerformanceReportParser> parsers) throws IOException, InterruptedException {
        if (!this.modeOfThreshold) {
            this.compareWithAbsoluteThreshold(run, listener, parsedReports);
        } else {
            this.compareWithRelativeThreshold(run, workspace, listener, parsers);
        }
    }

    public void compareWithAbsoluteThreshold(Run<?, ?> run, TaskListener listener, Collection<PerformanceReport> parsedReports) {
        PrintStream logger = listener.getLogger();
        try {
            this.printInfoAboutErrorThreshold(logger);
            HashMap<String, String> responseTimeThresholdMap = this.getResponseTimeThresholdMap(logger);
            for (PerformanceReport performanceReport : parsedReports) {
                this.analyzeErrorThreshold(run, performanceReport, responseTimeThresholdMap, logger);
                this.writeErrorThresholdReportInXML(run, performanceReport);
            }
        }
        catch (Exception e) {
            logger.println("ERROR: Exception while determining absolute error/unstable threshold evaluation");
            e.printStackTrace(logger);
        }
    }

    private void analyzeErrorThreshold(Run<?, ?> run, PerformanceReport performanceReport, HashMap<String, String> responseTimeThresholdMap, PrintStream logger) {
        Result result = Result.SUCCESS;
        double errorPercent = performanceReport.errorPercent();
        if (this.errorFailedThreshold >= 0 && errorPercent - (double)this.errorFailedThreshold > 1.0E-8) {
            result = Result.FAILURE;
        } else if (this.errorUnstableThreshold >= 0 && errorPercent - (double)this.errorUnstableThreshold > 1.0E-8) {
            result = Result.UNSTABLE;
        }
        Result res = this.checkAverageResponseTime(performanceReport, responseTimeThresholdMap, logger);
        if (res != null) {
            result = res;
        }
        run.setResult(result);
        logger.println("Performance: File " + performanceReport.getReportFileName() + " reported " + errorPercent + "% of errors [" + result + "]. Build status is: " + run.getResult());
    }

    private Result checkAverageResponseTime(PerformanceReport performanceReport, HashMap<String, String> responseTimeThresholdMap, PrintStream logger) {
        long average = performanceReport.getAverage();
        try {
            if (responseTimeThresholdMap != null && responseTimeThresholdMap.get(performanceReport.getReportFileName()) != null && Long.parseLong(responseTimeThresholdMap.get(performanceReport.getReportFileName())) <= average) {
                logger.println("UNSTABLE: " + performanceReport.getReportFileName() + " has exceeded the threshold of [" + Long.parseLong(responseTimeThresholdMap.get(performanceReport.getReportFileName())) + "] with the time of [" + Long.toString(average) + "]");
                return Result.UNSTABLE;
            }
        }
        catch (NumberFormatException nfe) {
            logger.println("ERROR: Threshold set to a non-number [" + responseTimeThresholdMap.get(performanceReport.getReportFileName()) + "]");
            return Result.FAILURE;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorThresholdReportInXML(Run<?, ?> run, PerformanceReport performanceReport) throws IOException {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            this.xmlDir = run.getRootDir().getAbsolutePath();
            this.xmlDir = this.xmlDir + "/archive";
            String glob = performanceReport.getReportFileName();
            String[] arr = glob.split("/");
            if (!new File(this.xmlDir).exists()) {
                new File(this.xmlDir).mkdirs();
            }
            this.xmlfile = new File(this.xmlDir + "/dashBoard_" + arr[arr.length - 1].split("\\.")[0] + ".xml");
            this.xmlfile.createNewFile();
            fw = new FileWriter(this.xmlfile.getAbsoluteFile());
            bw = new BufferedWriter(fw);
            this.xml = "<?xml version=\"1.0\"?>\n";
            this.xml = this.xml + "<results>\n";
            this.xml = this.xml + "<absoluteDefinition>\n";
            this.xml = this.xml + "\t<unstable>" + this.errorUnstableThreshold + "</unstable>\n";
            this.xml = this.xml + "\t<failed>" + this.errorFailedThreshold + "</failed>\n";
            this.xml = this.xml + "\t<calculated>" + performanceReport.errorPercent() + "</calculated>\n";
            this.xml = this.xml + "</absoluteDefinition>\n";
            this.appendStatsToXml(performanceReport.getUriListOrdered());
            this.xml = this.xml + "</results>";
            bw.write(this.xml);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    private void appendStatsToXml(List<UriReport> reports) {
        StringBuilder averageBuffer = new StringBuilder("<average>\n");
        StringBuilder medianBuffer = new StringBuilder("<median>\n");
        StringBuilder percentileBuffer = new StringBuilder("<percentile>\n");
        for (UriReport uriReport : reports) {
            averageBuffer.append("\t<").append(uriReport.getStaplerUri()).append(">\n");
            averageBuffer.append("\t\t<currentBuildAvg>").append(uriReport.getAverage()).append("</currentBuildAvg>\n");
            averageBuffer.append("\t</").append(uriReport.getStaplerUri()).append(">\n");
            medianBuffer.append("\t<").append(uriReport.getStaplerUri()).append(">\n");
            medianBuffer.append("\t\t<currentBuildMed>").append(uriReport.getMedian()).append("</currentBuildMed>\n");
            medianBuffer.append("\t</").append(uriReport.getStaplerUri()).append(">\n");
            percentileBuffer.append("\t<").append(uriReport.getStaplerUri()).append(">\n");
            percentileBuffer.append("\t\t<currentBuild90Line>").append(uriReport.get90Line()).append("</currentBuild90Line>\n");
            percentileBuffer.append("\t</").append(uriReport.getStaplerUri()).append(">\n");
        }
        averageBuffer.append("</average>\n");
        medianBuffer.append("</median>\n");
        percentileBuffer.append("</percentile>\n");
        this.xml = this.xml + averageBuffer;
        this.xml = this.xml + medianBuffer;
        this.xml = this.xml + percentileBuffer;
    }

    private HashMap<String, String> getResponseTimeThresholdMap(PrintStream logger) {
        HashMap<String, String> responseTimeThresholdMap = null;
        if (!"".equals(this.errorUnstableResponseTimeThreshold) && this.errorUnstableResponseTimeThreshold != null) {
            String[] lines;
            responseTimeThresholdMap = new HashMap<String, String>();
            for (String line : lines = this.errorUnstableResponseTimeThreshold.split("\n")) {
                String[] components = line.split(":");
                if (components.length != 2) continue;
                logger.println("Setting threshold: " + components[0] + ":" + components[1]);
                responseTimeThresholdMap.put(components[0], components[1]);
            }
        }
        return responseTimeThresholdMap;
    }

    public void compareWithRelativeThreshold(Run<?, ?> run, FilePath workspace, TaskListener listener, List<PerformanceReportParser> parsers) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        try {
            Run<?, ?> buildForComparison;
            this.printInfoAboutRelativeThreshold(logger);
            List<UriReport> currentUriReports = this.getBuildUriReports(run, workspace, listener, parsers, true);
            if (currentUriReports == null) {
                return;
            }
            StringBuilder averageBuffer = null;
            StringBuilder medianBuffer = null;
            StringBuilder percentileBuffer = null;
            Run<?, ?> run2 = buildForComparison = this.compareBuildPrevious ? run.getPreviousSuccessfulBuild() : this.getnthBuild(run);
            if (buildForComparison != null) {
                logger.print("\nComparison build no. - " + buildForComparison.number + " and " + run.number + " using ");
                this.printInfoAboutCompareBasedOn(logger);
                averageBuffer = new StringBuilder("<average>\n");
                medianBuffer = new StringBuilder("<median>\n");
                percentileBuffer = new StringBuilder("<percentile>\n");
                this.compareUriReports(run, currentUriReports, this.getBuildUriReports(buildForComparison, workspace, listener, parsers, false), logger, averageBuffer, medianBuffer, percentileBuffer);
                averageBuffer.append("</average>\n");
                medianBuffer.append("</median>\n");
                percentileBuffer.append("</percentile>");
            }
            this.writeRelativeThresholdReportInXML(run, averageBuffer, medianBuffer, percentileBuffer);
        }
        catch (Exception e) {
            logger.println("ERROR: Exception while determining relative comparison between builds");
            e.printStackTrace(logger);
        }
    }

    private void compareUriReports(Run<?, ?> run, List<UriReport> currentUriReports, List<UriReport> reportsForComparison, PrintStream logger, StringBuilder averageBuffer, StringBuilder medianBuffer, StringBuilder percentileBuffer) {
        for (UriReport reportForComparison : reportsForComparison) {
            for (UriReport currentUriReport : currentUriReports) {
                if (!reportForComparison.getStaplerUri().equalsIgnoreCase(currentUriReport.getStaplerUri())) continue;
                this.appendRelativeInfoAboutAverage(currentUriReport, reportForComparison, averageBuffer);
                this.appendRelativeInfoAboutMedian(currentUriReport, reportForComparison, medianBuffer);
                this.appendRelativeInfoAbout90Line(currentUriReport, reportForComparison, percentileBuffer);
                this.calculateBuildStatus(run, logger, reportForComparison.getStaplerUri(), this.calculateRelativeDiffInPercent(currentUriReport, reportForComparison, logger));
            }
        }
    }

    private void calculateBuildStatus(Run<?, ?> run, PrintStream logger, String staplerUri, double relativeDiffPercent) {
        Result result = null;
        if (relativeDiffPercent < 0.0) {
            if (this.calculateRelativeFailedThresholdNegative(relativeDiffPercent)) {
                result = Result.FAILURE;
            } else if (this.calculateRelativeUnstableThresholdNegative(relativeDiffPercent)) {
                result = Result.UNSTABLE;
            }
        } else if (relativeDiffPercent >= 0.0) {
            if (this.calculateRelativeFailedThresholdPositive(relativeDiffPercent)) {
                result = Result.FAILURE;
            } else if (this.calculateRelativeUnstableThresholdPositive(relativeDiffPercent)) {
                result = Result.UNSTABLE;
            }
        }
        if (result != null) {
            run.setResult(result);
            logger.print(result == Result.FAILURE ? "\nThe label \"" + staplerUri + "\" caused the build to fail\n" : "\nThe label \"" + staplerUri + "\" made the build unstable\n");
        }
    }

    private double calculateDiffInPercents(double value1, double value2) {
        return Math.round(value1 * 100.0 / value2 * 100.0) / 100L;
    }

    private boolean calculateRelativeFailedThresholdNegative(double relativeDiffPercent) {
        return this.relativeFailedThresholdNegative >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeFailedThresholdNegative > 1.0E-8;
    }

    private boolean calculateRelativeUnstableThresholdNegative(double relativeDiffPercent) {
        return this.relativeUnstableThresholdNegative >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeUnstableThresholdNegative > 1.0E-8;
    }

    private boolean calculateRelativeFailedThresholdPositive(double relativeDiffPercent) {
        return this.relativeFailedThresholdPositive >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeFailedThresholdPositive > 1.0E-8;
    }

    private boolean calculateRelativeUnstableThresholdPositive(double relativeDiffPercent) {
        return this.relativeUnstableThresholdPositive >= 0.0 && Math.abs(relativeDiffPercent) - this.relativeUnstableThresholdPositive > 1.0E-8;
    }

    private double calculateRelativeDiffInPercent(UriReport currentReport, UriReport reportForComparison, PrintStream logger) {
        double relativeDiffPercent = 0.0;
        if (this.configType.equalsIgnoreCase(ART)) {
            double relativeDiff = currentReport.getAverage() - reportForComparison.getAverage();
            relativeDiffPercent = this.calculateDiffInPercents(relativeDiff, reportForComparison.getAverage());
            logger.println(reportForComparison.getStaplerUri() + "\t" + currentReport.getStaplerUri() + "\t\t" + reportForComparison.getAverage() + "\t\t\t" + currentReport.getAverage() + "\t\t\t" + relativeDiff + "\t\t" + relativeDiffPercent);
        } else if (this.configType.equalsIgnoreCase(MRT)) {
            double relativeDiff = currentReport.getMedian() - reportForComparison.getMedian();
            relativeDiffPercent = this.calculateDiffInPercents(relativeDiff, reportForComparison.getMedian());
            logger.println(reportForComparison.getStaplerUri() + "\t" + currentReport.getStaplerUri() + "\t\t" + reportForComparison.getMedian() + "\t\t\t" + currentReport.getMedian() + "\t\t\t" + relativeDiff + "\t\t" + relativeDiffPercent);
        } else if (this.configType.equalsIgnoreCase(PRT)) {
            double relativeDiff = currentReport.get90Line() - reportForComparison.get90Line();
            relativeDiffPercent = this.calculateDiffInPercents(relativeDiff, reportForComparison.get90Line());
            logger.println(reportForComparison.getStaplerUri() + "\t" + currentReport.getStaplerUri() + "\t\t" + reportForComparison.get90Line() + "\t\t\t" + currentReport.get90Line() + "\t\t\t" + relativeDiff + "\t\t" + relativeDiffPercent);
        }
        return relativeDiffPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRelativeThresholdReportInXML(Run<?, ?> run, StringBuilder averageBuffer, StringBuilder medianBuffer, StringBuilder percentileBuffer) throws IOException {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            this.xmlDir = run.getRootDir().getAbsolutePath();
            this.xmlDir = this.xmlDir + "/archive";
            if (!new File(this.xmlDir).exists()) {
                new File(this.xmlDir).mkdirs();
            }
            this.xmlfile = new File(this.xmlDir + "/dashBoard_results.xml");
            this.xmlfile.createNewFile();
            fw = new FileWriter(this.xmlfile.getAbsoluteFile());
            bw = new BufferedWriter(fw);
            String buildNo = "\t<buildNum>" + (this.compareBuildPrevious ? "previous" : Integer.valueOf(this.nthBuildNumber)) + "</buildNum>\n";
            String unstable = "\t<unstable>\n";
            unstable = unstable + "\t\t<negative>" + this.relativeUnstableThresholdNegative + "</negative>\n";
            unstable = unstable + "\t\t<positive>" + this.relativeUnstableThresholdPositive + "</positive>\n";
            unstable = unstable + "\t</unstable>\n";
            String failed = "\t<failed>\n";
            failed = failed + "\t\t<negative>" + this.relativeFailedThresholdNegative + "</negative>\n";
            failed = failed + "\t\t<positive>" + this.relativeFailedThresholdPositive + "</positive>\n";
            failed = failed + "\t</failed>\n";
            String relative = "<relativeDefinition>\n";
            relative = relative + buildNo + unstable + failed;
            relative = relative + "</relativeDefinition>";
            bw.write("<?xml version=\"1.0\"?>\n");
            bw.write("<results>\n");
            bw.write(relative + "\n");
            if (averageBuffer != null) {
                bw.write(averageBuffer.toString());
            }
            if (medianBuffer != null) {
                bw.write(medianBuffer.toString());
            }
            if (percentileBuffer != null) {
                bw.write(percentileBuffer.toString());
            }
            bw.write("</results>");
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    private void appendRelativeInfoAboutAverage(UriReport currentReport, UriReport reportForComparison, StringBuilder averageBuffer) {
        double relativeDiff = currentReport.getAverage() - reportForComparison.getAverage();
        double relativeDiffPercent = this.calculateDiffInPercents(relativeDiff, reportForComparison.getAverage());
        averageBuffer.append("\t<").append(currentReport.getStaplerUri()).append(">\n");
        averageBuffer.append("\t\t<previousBuildAvg>").append(reportForComparison.getAverage()).append("</previousBuildAvg>\n");
        averageBuffer.append("\t\t<currentBuildAvg>").append(currentReport.getAverage()).append("</currentBuildAvg>\n");
        averageBuffer.append("\t\t<relativeDiff>").append(relativeDiff).append("</relativeDiff>\n");
        averageBuffer.append("\t\t<relativeDiffPercent>").append(relativeDiffPercent).append("</relativeDiffPercent>\n");
        averageBuffer.append("\t</").append(currentReport.getStaplerUri()).append(">\n");
    }

    private void appendRelativeInfoAboutMedian(UriReport currentReport, UriReport reportForComparison, StringBuilder medianBuffer) {
        double relativeDiff = currentReport.getMedian() - reportForComparison.getMedian();
        double relativeDiffPercent = this.calculateDiffInPercents(relativeDiff, reportForComparison.getMedian());
        medianBuffer.append("\t<").append(currentReport.getStaplerUri()).append(">\n");
        medianBuffer.append("\t\t<previousBuildMed>").append(reportForComparison.getMedian()).append("</previousBuildMed>\n");
        medianBuffer.append("\t\t<currentBuildMed>").append(currentReport.getMedian()).append("</currentBuildMed>\n");
        medianBuffer.append("\t\t<relativeDiff>").append(relativeDiff).append("</relativeDiff>\n");
        medianBuffer.append("\t\t<relativeDiffPercent>").append(relativeDiffPercent).append("</relativeDiffPercent>\n");
        medianBuffer.append("\t</").append(currentReport.getStaplerUri()).append(">\n");
    }

    private void appendRelativeInfoAbout90Line(UriReport currentReport, UriReport reportForComparison, StringBuilder percentileBuffer) {
        double relativeDiff = currentReport.get90Line() - reportForComparison.get90Line();
        double relativeDiffPercent = this.calculateDiffInPercents(relativeDiff, reportForComparison.get90Line());
        percentileBuffer.append("\t<").append(currentReport.getStaplerUri()).append(">\n");
        percentileBuffer.append("\t\t<previousBuild90Line>").append(reportForComparison.get90Line()).append("</previousBuild90Line>\n");
        percentileBuffer.append("\t\t<currentBuild90Line>").append(currentReport.get90Line()).append("</currentBuild90Line>\n");
        percentileBuffer.append("\t\t<relativeDiff>").append(relativeDiff).append("</relativeDiff>\n");
        percentileBuffer.append("\t\t<relativeDiffPercent>").append(relativeDiffPercent).append("</relativeDiffPercent>\n");
        percentileBuffer.append("\t</").append(currentReport.getStaplerUri()).append(">\n");
    }

    private void printInfoAboutErrorThreshold(PrintStream logger) {
        logger.println(this.errorUnstableThreshold >= 0 && this.errorUnstableThreshold <= 100 ? "Performance: Percentage of errors greater or equal than " + this.errorUnstableThreshold + "% sets the build as " + Result.UNSTABLE.toString().toLowerCase() : "Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
        logger.println(this.errorFailedThreshold >= 0 && this.errorFailedThreshold <= 100 ? "Performance: Percentage of errors greater or equal than " + this.errorFailedThreshold + "% sets the build as " + Result.FAILURE.toString().toLowerCase() : "Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
    }

    private void printInfoAboutRelativeThreshold(PrintStream logger) {
        logger.println(this.relativeFailedThresholdNegative <= 100.0 && this.relativeFailedThresholdPositive <= 100.0 ? "Performance: Percentage of relative difference outside -" + this.relativeFailedThresholdNegative + " to +" + this.relativeFailedThresholdPositive + " % sets the build as " + Result.FAILURE.toString().toLowerCase() : "Performance: No threshold configured for making the test " + Result.FAILURE.toString().toLowerCase());
        logger.println(this.relativeUnstableThresholdNegative <= 100.0 && this.relativeUnstableThresholdPositive <= 100.0 ? "Performance: Percentage of relative difference outside -" + this.relativeUnstableThresholdNegative + " to +" + this.relativeUnstableThresholdPositive + " % sets the build as " + Result.UNSTABLE.toString().toLowerCase() : "Performance: No threshold configured for making the test " + Result.UNSTABLE.toString().toLowerCase());
    }

    private void printInfoAboutCompareBasedOn(PrintStream logger) {
        if (this.configType.equalsIgnoreCase(ART)) {
            logger.println("Average response time\n\n");
            logger.println("PrevBuildURI\tCurrentBuildURI\t\tPrevBuildURIAvg\t\tCurrentBuildURIAvg\tRelativeDiff\tRelativeDiffPercentage ");
        } else if (this.configType.equalsIgnoreCase(MRT)) {
            logger.println("Median response time\n\n");
            logger.println("PrevBuildURI\tCurrentBuildURI\t\tPrevBuildURIMed\t\tCurrentBuildURIMed\tRelativeDiff\tRelativeDiffPercentage ");
        } else if (this.configType.equalsIgnoreCase(PRT)) {
            logger.println("90 Percentile response time\n\n");
            logger.println("PrevBuildURI\tCurrentBuildURI\t\tPrevBuildURI90%\t\tCurrentBuildURI90%\tRelativeDiff\tRelativeDiffPercentage ");
        }
    }

    public void evaluateInExpertMode(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        ConstraintFactory factory = new ConstraintFactory();
        ConstraintSettings settings = new ConstraintSettings(listener, this.ignoreFailedBuilds, this.ignoreUnstableBuilds, this.persistConstraintLog);
        ConstraintChecker checker = new ConstraintChecker(settings, (List<? extends Run<?, ?>>)run.getParent().getBuilds());
        ArrayList<ConstraintEvaluation> ceList = new ArrayList();
        try {
            ceList = checker.checkAllConstraints(factory.createConstraintClones(run, this.constraints));
        }
        catch (Exception e) {
            e.printStackTrace(logger);
        }
        ConstraintReport cr = new ConstraintReport(ceList, run.getParent().getBuilds().get(0), this.persistConstraintLog);
        logger.print(cr.getLoggerMsg());
        run.setResult(cr.getBuildResult());
    }

    private List<File> copyReportsToMaster(Run<?, ?> build, PrintStream logger, List<FilePath> files, String parserDisplayName) throws IOException, InterruptedException {
        ArrayList<File> localReports = new ArrayList<File>();
        for (FilePath src : files) {
            File localReport = PerformancePublisher.getPerformanceReport(build, parserDisplayName, src.getName());
            if (src.isDirectory()) {
                logger.println("Performance: File '" + src.getName() + "' is a directory, not a Performance Report");
                continue;
            }
            src.copyTo(new FilePath(localReport));
            localReports.add(localReport);
        }
        return localReports;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    @DataBoundSetter
    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = errorFailedThreshold == -1 ? -1 : Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    @DataBoundSetter
    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = errorUnstableThreshold == -1 ? -1 : Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getErrorUnstableResponseTimeThreshold() {
        return this.errorUnstableResponseTimeThreshold;
    }

    @DataBoundSetter
    public void setErrorUnstableResponseTimeThreshold(String errorUnstableResponseTimeThreshold) {
        this.errorUnstableResponseTimeThreshold = errorUnstableResponseTimeThreshold;
    }

    public boolean isModePerformancePerTestCase() {
        return this.modePerformancePerTestCase;
    }

    @DataBoundSetter
    public void setModePerformancePerTestCase(boolean modePerformancePerTestCase) {
        this.modePerformancePerTestCase = modePerformancePerTestCase;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isFailBuildIfNoResultFile() {
        return this.failBuildIfNoResultFile;
    }

    @DataBoundSetter
    public void setFailBuildIfNoResultFile(boolean failBuildIfNoResultFile) {
        this.failBuildIfNoResultFile = failBuildIfNoResultFile;
    }

    public boolean isART() {
        return this.configType.compareToIgnoreCase(ART) == 0;
    }

    public boolean isMRT() {
        return this.configType.compareToIgnoreCase(MRT) == 0;
    }

    public boolean isPRT() {
        return this.configType.compareToIgnoreCase(PRT) == 0;
    }

    public static File[] getPerformanceReportDirectory(Run<?, ?> build, String parserDisplayName, PrintStream logger) {
        File folder = new File(build.getRootDir() + "/" + PerformanceReportMap.getPerformanceReportFileRelativePath(parserDisplayName, ""));
        return folder.listFiles();
    }

    public Run<?, ?> getnthBuild(Run<?, ?> build) throws IOException {
        Run nthBuild = build;
        int nextBuildNumber = build.number - this.nthBuildNumber;
        for (int i = 1; i <= nextBuildNumber; ++i) {
            if ((nthBuild = nthBuild.getPreviousBuild()) != null) continue;
            return null;
        }
        return this.nthBuildNumber == 0 ? null : nthBuild;
    }

    private List<File> getExistingReports(Run<?, ?> build, PrintStream logger, String parserDisplayName) throws IOException, InterruptedException {
        ArrayList<File> localReports = new ArrayList<File>();
        File[] localReport = PerformancePublisher.getPerformanceReportDirectory(build, parserDisplayName, logger);
        for (int i = 0; i < localReport.length; ++i) {
            String name = localReport[i].getName();
            String[] arr = name.split("\\.");
            if (arr[arr.length - 1].equalsIgnoreCase("serialized")) continue;
            localReports.add(localReport[i]);
        }
        return localReports;
    }

    public double getRelativeFailedThresholdPositive() {
        return this.relativeFailedThresholdPositive;
    }

    public double getRelativeFailedThresholdNegative() {
        return this.relativeFailedThresholdNegative;
    }

    @DataBoundSetter
    public void setRelativeFailedThresholdPositive(double relativeFailedThresholdPositive) {
        this.relativeFailedThresholdPositive = Math.max(0.0, Math.min(relativeFailedThresholdPositive, 100.0));
    }

    @DataBoundSetter
    public void setRelativeFailedThresholdNegative(double relativeFailedThresholdNegative) {
        this.relativeFailedThresholdNegative = Math.max(0.0, Math.min(relativeFailedThresholdNegative, 100.0));
    }

    public double getRelativeUnstableThresholdPositive() {
        return this.relativeUnstableThresholdPositive;
    }

    public double getRelativeUnstableThresholdNegative() {
        return this.relativeUnstableThresholdNegative;
    }

    @DataBoundSetter
    public void setRelativeUnstableThresholdPositive(double relativeUnstableThresholdPositive) {
        this.relativeUnstableThresholdPositive = Math.max(0.0, Math.min(relativeUnstableThresholdPositive, 100.0));
    }

    @DataBoundSetter
    public void setRelativeUnstableThresholdNegative(double relativeUnstableThresholdNegative) {
        this.relativeUnstableThresholdNegative = Math.max(0.0, Math.min(relativeUnstableThresholdNegative, 100.0));
    }

    public int getNthBuildNumber() {
        return this.nthBuildNumber;
    }

    @DataBoundSetter
    public void setNthBuildNumber(int nthBuildNumber) {
        this.nthBuildNumber = Math.max(0, Math.min(nthBuildNumber, Integer.MAX_VALUE));
    }

    public String getConfigType() {
        return this.configType;
    }

    @DataBoundSetter
    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public String getGraphType() {
        return this.graphType;
    }

    @DataBoundSetter
    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    public boolean getModeOfThreshold() {
        return this.modeOfThreshold;
    }

    @DataBoundSetter
    public void setModeOfThreshold(boolean modeOfThreshold) {
        this.modeOfThreshold = modeOfThreshold;
    }

    public boolean getCompareBuildPrevious() {
        return this.compareBuildPrevious;
    }

    @DataBoundSetter
    public void setCompareBuildPrevious(boolean compareBuildPrevious) {
        this.compareBuildPrevious = compareBuildPrevious;
    }

    public boolean isModeThroughput() {
        return this.modeThroughput;
    }

    @DataBoundSetter
    public void setModeThroughput(boolean modeThroughput) {
        this.modeThroughput = modeThroughput;
    }

    public List<? extends AbstractConstraint> getConstraints() {
        return this.constraints;
    }

    @DataBoundSetter
    public void setConstraints(List<? extends AbstractConstraint> constraints) {
        this.constraints = constraints;
    }

    @DataBoundSetter
    public void setIgnoreFailedBuilds(boolean ignoreFailedBuilds) {
        this.ignoreFailedBuilds = ignoreFailedBuilds;
    }

    public boolean isIgnoreFailedBuilds() {
        return this.ignoreFailedBuilds;
    }

    @DataBoundSetter
    public void setIgnoreUnstableBuilds(boolean ignoreUnstableBuilds) {
        this.ignoreUnstableBuilds = ignoreUnstableBuilds;
    }

    public boolean isIgnoreUnstableBuilds() {
        return this.ignoreUnstableBuilds;
    }

    public boolean isPersistConstraintLog() {
        return this.persistConstraintLog;
    }

    @DataBoundSetter
    public void setPersistConstraintLog(boolean persistConstraintLog) {
        this.persistConstraintLog = persistConstraintLog;
    }

    public boolean isModeEvaluation() {
        return this.modeEvaluation;
    }

    @DataBoundSetter
    public void setModeEvaluation(boolean modeEvaluation) {
        this.modeEvaluation = modeEvaluation;
    }

    public String getSourceDataFiles() {
        return this.sourceDataFiles;
    }

    public void setSourceDataFiles(String sourceDataFiles) {
        this.sourceDataFiles = sourceDataFiles;
    }

    public List<PerformanceReportParser> getParsers() {
        return this.parsers;
    }

    @DataBoundSetter
    public void setParsers(List<PerformanceReportParser> parsers) {
        this.parsers = parsers;
        this.migrateParsers();
    }

    public boolean isExcludeResponseTime() {
        return this.excludeResponseTime;
    }

    @DataBoundSetter
    public void setExcludeResponseTime(boolean excludeResponseTime) {
        this.excludeResponseTime = excludeResponseTime;
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceBuildAction", PerformanceBuildAction.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceProjectAction", PerformanceProjectAction.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.ExternalBuildReport", ExternalBuildReportAction.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.PreviousResultsBlock", PreviousResultsBlock.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.TestCaseBlock", TestCaseBlock.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.CookieHandler", CookieHandler.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.ConstraintSettings", ConstraintSettings.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.HttpSample", HttpSample.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReportPosition", PerformanceReportPosition.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TaurusStatusReport", TaurusFinalStats.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.ConstraintDescriptor", ConstraintDescriptor.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReportParserDescriptor", PerformanceReportParserDescriptor.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.GraphConfigurationDetail", GraphConfigurationDetail.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TestSuiteReportDetail", TestSuiteReportDetail.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TrendReportDetail", TrendReportDetail.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.AbstractParser", AbstractParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.IagoParser", IagoParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JMeterCsvParser", JMeterCsvParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JMeterParser", JMeterParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JmeterSummarizerParser", JmeterSummarizerParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JUnitParser", JUnitParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReportParser", PerformanceReportParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TaurusParser", TaurusParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.WrkSummarizerParser", WrkSummarizerParser.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.reports.throughput.ThroughputReport", ThroughputReport.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.reports.ThroughputReport", ThroughputReport.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.AbstractReport", AbstractReport.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.ConstraintReport", ConstraintReport.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReport", PerformanceReport.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.UriReport", UriReport.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceBuildAction", PerformanceBuildAction.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceProjectAction", PerformanceProjectAction.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.ExternalBuildReport", ExternalBuildReportAction.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.PreviousResultsBlock", PreviousResultsBlock.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.TestCaseBlock", TestCaseBlock.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.CookieHandler", CookieHandler.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.ConstraintSettings", ConstraintSettings.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.HttpSample", HttpSample.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReportPosition", PerformanceReportPosition.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TaurusStatusReport", TaurusFinalStats.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.ConstraintDescriptor", ConstraintDescriptor.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReportParserDescriptor", PerformanceReportParserDescriptor.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.GraphConfigurationDetail", GraphConfigurationDetail.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TestSuiteReportDetail", TestSuiteReportDetail.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TrendReportDetail", TrendReportDetail.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.AbstractParser", AbstractParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.IagoParser", IagoParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JMeterCsvParser", JMeterCsvParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JMeterParser", JMeterParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JmeterSummarizerParser", JmeterSummarizerParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.JUnitParser", JUnitParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReportParser", PerformanceReportParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.TaurusParser", TaurusParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.WrkSummarizerParser", WrkSummarizerParser.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.reports.throughput.ThroughputReport", ThroughputReport.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.reports.ThroughputReport", ThroughputReport.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.AbstractReport", AbstractReport.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.constraints.ConstraintReport", ConstraintReport.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.PerformanceReport", PerformanceReport.class);
        Run.XSTREAM2.addCompatibilityAlias("hudson.plugins.performance.UriReport", UriReport.class);
    }

    @Symbol(value={"perfReport", "performanceReport"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.Publisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/performance/help.html";
        }

        public List<PerformanceReportParserDescriptor> getParserDescriptors() {
            return PerformanceReportParserDescriptor.all();
        }

        public List<ConstraintDescriptor> getConstraintDescriptors() {
            return ConstraintDescriptor.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillConfigTypeItems() {
            return this.getResponseTimeOptions();
        }

        public ListBoxModel doFillGraphTypeItems() {
            return this.getResponseTimeOptions();
        }

        private ListBoxModel getResponseTimeOptions() {
            ListBoxModel items = new ListBoxModel();
            items.add("Average Response Time", PerformancePublisher.ART);
            items.add("Median Response Time", PerformancePublisher.MRT);
            items.add("Percentile Response Time", PerformancePublisher.PRT);
            return items;
        }
    }
}

