/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.performance.constraints;

import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.plugins.performance.constraints.AbsoluteConstraint;
import hudson.plugins.performance.constraints.ConstraintEvaluation;
import hudson.plugins.performance.constraints.RelativeConstraint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import jenkins.model.Jenkins;

public class ConstraintReport {
    private File performanceLog;
    private Run<?, ?> newBuild;
    private int buildNumber;
    private Calendar buildDate;
    private Result buildResult;
    private String linkToBuild;
    private short allConstraints = 0;
    private short relativeConstraints = 0;
    private short absoluteConstraints = 0;
    private short successfulConstraints = 0;
    private short violatedConstraints = 0;
    private short violatedInformation = 0;
    private short violatedUnstable = 0;
    private short violatedError = 0;
    private String loggerMsg;
    private String loggerMsgAdv;

    public ConstraintReport(ArrayList<ConstraintEvaluation> ceList, Run<?, ?> globBuild, boolean persistConstraintLog) throws IOException, InterruptedException {
        this.newBuild = globBuild;
        this.createMetaData(ceList, this.newBuild);
        this.createLoggerMsg(ceList);
        this.createLoggerMsgAdv();
        this.writeResultsToEnvVar();
        if (persistConstraintLog) {
            this.writeResultsToFile();
        }
    }

    private void createMetaData(ArrayList<ConstraintEvaluation> ceList, Run<?, ?> newBuild) {
        this.buildNumber = newBuild.getNumber();
        this.buildDate = newBuild.getTimestamp();
        this.buildResult = this.determineBuildResult(ceList);
        this.linkToBuild = Jenkins.getInstance().getRootUrl() == null ? "Could not resolve URL - Please set the root URL in the Jenkins System Configuration" : Jenkins.getInstance().getRootUrl() + newBuild.getUrl();
        for (ConstraintEvaluation ce : ceList) {
            if (ce.getAbstractConstraint() instanceof AbsoluteConstraint) {
                this.allConstraints = (short)(this.allConstraints + 1);
                this.absoluteConstraints = (short)(this.absoluteConstraints + 1);
                if (ce.getAbstractConstraint().getSuccess()) {
                    this.successfulConstraints = (short)(this.successfulConstraints + 1);
                    continue;
                }
                this.violatedConstraints = (short)(this.violatedConstraints + 1);
                switch (ce.getAbstractConstraint().getEscalationLevel().ordinal()) {
                    case 0: {
                        this.violatedInformation = (short)(this.violatedInformation + 1);
                        break;
                    }
                    case 1: {
                        this.violatedUnstable = (short)(this.violatedUnstable + 1);
                        break;
                    }
                    case 2: {
                        this.violatedError = (short)(this.violatedError + 1);
                    }
                }
                continue;
            }
            if (!(ce.getAbstractConstraint() instanceof RelativeConstraint)) continue;
            this.allConstraints = (short)(this.allConstraints + 1);
            this.relativeConstraints = (short)(this.relativeConstraints + 1);
            if (ce.getAbstractConstraint().getSuccess()) {
                this.successfulConstraints = (short)(this.successfulConstraints + 1);
                continue;
            }
            this.violatedConstraints = (short)(this.violatedConstraints + 1);
            switch (ce.getAbstractConstraint().getEscalationLevel().ordinal()) {
                case 0: {
                    this.violatedInformation = (short)(this.violatedInformation + 1);
                    break;
                }
                case 1: {
                    this.violatedUnstable = (short)(this.violatedUnstable + 1);
                    break;
                }
                case 2: {
                    this.violatedError = (short)(this.violatedError + 1);
                }
            }
        }
    }

    private Result determineBuildResult(ArrayList<ConstraintEvaluation> ceList) {
        int highestViolatedEscalation = 0;
        for (ConstraintEvaluation ce : ceList) {
            if (ce.getAbstractConstraint().getEscalationLevel().ordinal() <= highestViolatedEscalation || ce.getAbstractConstraint().getSuccess()) continue;
            highestViolatedEscalation = ce.getAbstractConstraint().getEscalationLevel().ordinal();
        }
        switch (highestViolatedEscalation) {
            case 0: {
                return Result.SUCCESS;
            }
            case 1: {
                return Result.UNSTABLE;
            }
            case 2: {
                return Result.FAILURE;
            }
        }
        return Result.FAILURE;
    }

    private void createLoggerMsg(ArrayList<ConstraintEvaluation> ceList) {
        this.loggerMsg = "----------------------------------------------------------- \n";
        if (this.relativeConstraints == 0) {
            this.loggerMsg = this.loggerMsg + "There are no relative constraints to evaluate! \n-------------- \n";
        } else {
            this.loggerMsg = this.loggerMsg + "Evaluating all relative constraints! \n-------------- \n";
            for (ConstraintEvaluation ce : ceList) {
                if (!(ce.getAbstractConstraint() instanceof RelativeConstraint)) continue;
                this.loggerMsg = this.loggerMsg + ce.getAbstractConstraint().getResultMessage() + "\n-------------- \n";
            }
        }
        if (this.absoluteConstraints == 0) {
            this.loggerMsg = this.loggerMsg + "There are no absolute constraints to evaluate! \n-------------- \n";
        } else {
            this.loggerMsg = this.loggerMsg + "Evaluating all absolute constraints! \n-------------- \n";
            for (ConstraintEvaluation ce : ceList) {
                if (!(ce.getAbstractConstraint() instanceof AbsoluteConstraint)) continue;
                this.loggerMsg = this.loggerMsg + ce.getAbstractConstraint().getResultMessage() + "\n-------------- \n";
            }
        }
        if (this.violatedConstraints == 0) {
            this.loggerMsg = this.loggerMsg + "There were no failing Constraints! The build will be marked as SUCCESS";
        } else if (this.buildResult.equals(Result.SUCCESS)) {
            this.loggerMsg = this.loggerMsg + "The highest escalation: Information! The build will be marked as SUCCESS";
        } else if (this.buildResult.equals(Result.UNSTABLE)) {
            this.loggerMsg = this.loggerMsg + "The highest escalation: Warning! The build will be marked as UNSTABLE";
        } else if (this.buildResult.equals(Result.FAILURE)) {
            this.loggerMsg = this.loggerMsg + "The highest escalation: Error! The build will be marked as FAILURE";
        }
        this.loggerMsg = this.loggerMsg + "\n";
    }

    private void createLoggerMsgAdv() {
        this.loggerMsgAdv = "----------------------------------------------------------- \nBuild Number: #" + this.getBuildNumber() + "\nBuild Date: " + this.getBuildDate().getTime() + "\nBuild State: " + this.getBuildResult().toString() + "\nLink to build: " + this.linkToBuild + "\n-------------- \nNumber of all constraints: " + this.getAllConstraints() + "\nRelative constraints: " + this.getRelativeConstraints() + "\nAbsolute constraints: " + this.getAbsoluteConstraints() + "\nSuccessful constraints: " + this.getSuccessfulConstraints() + "\nViolated constraints: " + this.getViolatedConstraints() + "\n->INFORMATION: " + this.getViolatedInformation() + "\n->UNSTABLE: " + this.getViolatedUnstable() + "\n->ERROR: " + this.getViolatedError() + "\n-------------- \n" + this.loggerMsg + "\n";
    }

    public void writeResultsToFile() throws InterruptedException, IOException {
        this.performanceLog = new File(this.newBuild.getRootDir() + File.separator + "performance-results" + File.separator + "performance.log");
        if (!this.performanceLog.exists()) {
            this.performanceLog.getParentFile().mkdirs();
            this.performanceLog.createNewFile();
        }
        FileOutputStream outWriter = new FileOutputStream(this.performanceLog, true);
        try {
            outWriter.write(this.getLoggerMsgAdv().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            outWriter.close();
        }
    }

    public void writeResultsToEnvVar() {
        ArrayList<StringParameterValue> params = new ArrayList<StringParameterValue>();
        params.add(new StringParameterValue("BUILD_CONSTRAINT_LOG", this.getLoggerMsgAdv()));
        this.newBuild.addAction((Action)new ParametersAction(params));
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public Calendar getBuildDate() {
        return this.buildDate;
    }

    public Result getBuildResult() {
        return this.buildResult;
    }

    public String getLinkToBuild() {
        return this.linkToBuild;
    }

    public short getAllConstraints() {
        return this.allConstraints;
    }

    public short getRelativeConstraints() {
        return this.relativeConstraints;
    }

    public short getAbsoluteConstraints() {
        return this.absoluteConstraints;
    }

    public short getSuccessfulConstraints() {
        return this.successfulConstraints;
    }

    public short getViolatedConstraints() {
        return this.violatedConstraints;
    }

    public short getViolatedInformation() {
        return this.violatedInformation;
    }

    public short getViolatedUnstable() {
        return this.violatedUnstable;
    }

    public short getViolatedError() {
        return this.violatedError;
    }

    public String getLoggerMsg() {
        return this.loggerMsg;
    }

    public String getLoggerMsgAdv() {
        return this.loggerMsgAdv;
    }

    public File getPerformanceLog() {
        return this.performanceLog;
    }

    public void setPerformanceLog(File performanceLog) {
        this.performanceLog = performanceLog;
    }
}

