/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BooleanParameterValue;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BooleanParameterConfig;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.stapler.DataBoundConstructor;

public class BooleanParameters
extends AbstractBuildParameters {
    private final List<BooleanParameterConfig> configs;

    @DataBoundConstructor
    public BooleanParameters(List<BooleanParameterConfig> configs) {
        this.configs = configs;
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        List values = this.configs.stream().map(config -> new BooleanParameterValue(config.getName(), config.getValue())).collect(Collectors.toList());
        return new ParametersAction(values);
    }

    public List<BooleanParameterConfig> getConfigs() {
        return this.configs;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Boolean parameters";
        }
    }
}

