/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BuildInfoExporterAction
implements EnvironmentContributingAction {
    public static final String JOB_NAME_VARIABLE = "LAST_TRIGGERED_JOB_NAME";
    public static final String ALL_JOBS_NAME_VARIABLE = "TRIGGERED_JOB_NAMES";
    public static final String BUILD_NUMBER_VARIABLE_PREFIX = "TRIGGERED_BUILD_NUMBER_";
    public static final String ALL_BUILD_NUMBER_VARIABLE_PREFIX = "TRIGGERED_BUILD_NUMBERS_";
    public static final String BUILD_RESULT_VARIABLE_PREFIX = "TRIGGERED_BUILD_RESULT_";
    public static final String BUILD_RUN_COUNT_PREFIX = "TRIGGERED_BUILD_RUN_COUNT_";
    public static final String RUN = "_RUN_";
    private transient String buildName;
    private transient int buildNumber;
    private transient Map<String, List<BuildReference>> buildRefs;
    private List<BuildReference> builds = new ArrayList<BuildReference>();
    private BuildReference lastReference;

    public BuildInfoExporterAction(BuildReference buildRef) {
        this.addBuild(buildRef);
        this.lastReference = buildRef;
    }

    public BuildInfoExporterAction(String buildName, int buildNumber, AbstractBuild<?, ?> parentBuild, Result buildResult) {
        this(new BuildReference(buildName, buildNumber, buildResult));
    }

    static BuildInfoExporterAction addBuildInfoExporterAction(AbstractBuild<?, ?> parentBuild, String triggeredProject, int buildNumber, Result buildResult) {
        BuildInfoExporterAction action = (BuildInfoExporterAction)parentBuild.getAction(BuildInfoExporterAction.class);
        if (action == null) {
            action = new BuildInfoExporterAction(triggeredProject, buildNumber, parentBuild, buildResult);
            parentBuild.getActions().add(action);
        } else {
            action.addBuildReference(triggeredProject, buildNumber, buildResult);
        }
        return action;
    }

    static BuildInfoExporterAction addBuildInfoExporterAction(AbstractBuild<?, ?> parentBuild, String triggeredProject) {
        BuildInfoExporterAction action = (BuildInfoExporterAction)parentBuild.getAction(BuildInfoExporterAction.class);
        if (action == null) {
            action = new BuildInfoExporterAction(new BuildReference(triggeredProject));
            parentBuild.getActions().add(action);
        } else {
            action.addBuildReference(new BuildReference(triggeredProject));
        }
        return action;
    }

    private void addBuild(BuildReference br) {
        this.builds.add(br);
        if (br.buildNumber != 0) {
            this.lastReference = br;
        }
    }

    public void addBuildReference(String triggeredProject, int buildNumber, Result buildResult) {
        BuildReference buildRef = new BuildReference(triggeredProject, buildNumber, buildResult);
        this.addBuild(buildRef);
    }

    public void addBuildReference(BuildReference buildRef) {
        this.addBuild(buildRef);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
        env.put(JOB_NAME_VARIABLE, this.lastReference.projectName.replaceAll("[^a-zA-Z0-9]+", "_"));
        String sanatizedProjectList = this.getProjectListString(",");
        env.put(ALL_JOBS_NAME_VARIABLE, sanatizedProjectList);
        for (String project : this.getProjectsWithBuilds()) {
            String sanatizedBuildName = project.replaceAll("[^a-zA-Z0-9]+", "_");
            List<BuildReference> refs = this.getBuildRefs(project);
            env.put(ALL_BUILD_NUMBER_VARIABLE_PREFIX + sanatizedBuildName, this.getBuildNumbersString(refs, ","));
            env.put(BUILD_RUN_COUNT_PREFIX + sanatizedBuildName, Integer.toString(refs.size()));
            for (BuildReference br : refs) {
                if (br.buildNumber == 0) continue;
                String tiggeredBuildRunResultKey = BUILD_RESULT_VARIABLE_PREFIX + sanatizedBuildName + RUN + Integer.toString(br.buildNumber);
                env.put(tiggeredBuildRunResultKey, br.buildResult.toString());
            }
            BuildReference lastBuild = null;
            int i = refs.size();
            if (i > 0 && refs.get((int)(i - 1)).buildNumber != 0) {
                lastBuild = refs.get(i - 1);
            }
            if (lastBuild == null) continue;
            env.put(BUILD_NUMBER_VARIABLE_PREFIX + sanatizedBuildName, Integer.toString(lastBuild.buildNumber));
            env.put(BUILD_RESULT_VARIABLE_PREFIX + sanatizedBuildName, lastBuild.buildResult.toString());
        }
    }

    private List<BuildReference> getBuildRefs(String project) {
        ArrayList<BuildReference> refs = new ArrayList<BuildReference>();
        for (BuildReference br : this.builds) {
            if (!br.projectName.equals(project)) continue;
            refs.add(br);
        }
        return refs;
    }

    @Exported(visibility=1)
    public List<AbstractBuild<?, ?>> getTriggeredBuilds() {
        ArrayList builds = new ArrayList();
        for (BuildReference br : this.builds) {
            AbstractProject project = (AbstractProject)Jenkins.getInstance().getItemByFullName(br.projectName, AbstractProject.class);
            if (br.buildNumber == 0) continue;
            builds.add(project != null ? project.getBuildByNumber(br.buildNumber) : null);
        }
        return builds;
    }

    @Exported(visibility=1)
    public List<AbstractProject<?, ?>> getTriggeredProjects() {
        ArrayList projects = new ArrayList();
        for (BuildReference br : this.builds) {
            if (br.buildNumber != 0) continue;
            AbstractProject project = (AbstractProject)Jenkins.getInstance().getItemByFullName(br.projectName, AbstractProject.class);
            projects.add(project);
        }
        return projects;
    }

    public Object readResolve() {
        if (this.lastReference == null) {
            this.lastReference = new BuildReference(this.buildName, this.buildNumber, Result.NOT_BUILT);
        }
        if (this.builds == null) {
            this.builds = new ArrayList<BuildReference>();
        }
        if (this.buildRefs != null) {
            for (List<BuildReference> buildReferences : this.buildRefs.values()) {
                this.builds.addAll(buildReferences);
            }
        }
        return this;
    }

    private String getBuildNumbersString(List<BuildReference> refs, String separator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (BuildReference s : refs) {
            if (s.buildNumber == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s.buildNumber);
        }
        return buf.toString();
    }

    protected String getProjectListString(String separator) {
        Set<String> refs = this.getProjectsWithBuilds();
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : refs) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s.replaceAll("[^a-zA-Z0-9]+", "_"));
        }
        return buf.toString();
    }

    private Set<String> getProjectsWithBuilds() {
        HashSet<String> projects = new HashSet<String>();
        for (BuildReference br : this.builds) {
            if (br.buildNumber == 0) continue;
            projects.add(br.projectName);
        }
        return projects;
    }

    public static class BuildReference {
        public final String projectName;
        public final int buildNumber;
        public final Result buildResult;

        public BuildReference(String projectName, int buildNumber, Result buildResult) {
            this.projectName = projectName;
            this.buildNumber = buildNumber;
            this.buildResult = buildResult;
        }

        public BuildReference(String projectName) {
            this.projectName = projectName;
            this.buildNumber = 0;
            this.buildResult = Result.NOT_BUILT;
        }
    }
}

