/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.pool;

import com.arkea.jenkins.openstack.client.OpenStack4jClient;
import com.arkea.jenkins.openstack.exception.utils.ExceptionUtils;
import com.arkea.jenkins.openstack.heat.configuration.TimersOS;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.log.ConsoleLogger;
import com.arkea.jenkins.openstack.pool.StackStatus;
import java.text.DateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openstack4j.model.heat.Event;
import org.openstack4j.model.heat.Stack;

public class ProcessStatus {
    private static EnumSet<StackStatus> failed = EnumSet.of(StackStatus.DELETE_FAILED, StackStatus.CREATE_FAILED, StackStatus.UNDEFINED, StackStatus.FAILED, StackStatus.TIMEOUT);

    public static boolean checkStackStatus(StackStatus status, OpenStack4jClient client, ConsoleLogger cLog, Stack originalStack, TimersOS timersOS) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        boolean rtn = true;
        try {
            long startTime = System.currentTimeMillis();
            boolean taskComplete = false;
            cLog.logInfo(Messages.operation_begin(dateFormat.format(new Date(startTime))));
            while (!taskComplete && System.currentTimeMillis() - startTime < timersOS.getTimeoutProcessInMS()) {
                if (!taskComplete) {
                    Thread.sleep(timersOS.getPollingStatusInMS());
                }
                Stack stack = client.getDetails(originalStack.getName(), originalStack.getId());
                cLog.logInfo(ProcessStatus.getTime(System.currentTimeMillis() - startTime) + Messages.stack_waiting(originalStack.getName(), stack.getStatus()));
                if (stack.getStackStatusReason().contains("started")) continue;
                StackStatus stackStatus = StackStatus.getEnum(stack.getStatus());
                cLog.logInfo(stack.getStackStatusReason());
                if (stackStatus.equals((Object)status)) {
                    taskComplete = true;
                    continue;
                }
                if (!failed.contains((Object)stackStatus)) continue;
                cLog.logError(Messages.status_error((Object)status, originalStack.getName()));
                cLog.logError(stack.getStackStatusReason());
                taskComplete = true;
                rtn = false;
                if (!cLog.isDebug()) continue;
                ProcessStatus.printEvents(stack, client, cLog);
            }
            if (System.currentTimeMillis() - startTime > timersOS.getTimeoutProcessInMS()) {
                cLog.logError(Messages.operation_timeout(originalStack.getName()));
                rtn = false;
            }
            long finished = System.currentTimeMillis();
            cLog.logInfo(Messages.operation_finished(dateFormat.format(new Date(finished))));
            cLog.logInfo(Messages.operation_duration(ProcessStatus.getTime(finished - startTime)));
        }
        catch (Exception e) {
            cLog.logError(Messages.stack_failed(originalStack.getName()) + ExceptionUtils.getStackTrace(e));
            rtn = false;
        }
        return rtn;
    }

    private static String getTime(long time) {
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(time), TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time)));
    }

    private static void printEvents(Stack stack, OpenStack4jClient client, ConsoleLogger cLog) {
        try {
            List<? extends Event> events = client.getEvents(stack);
            for (Event event : events) {
                cLog.logDebug(Messages.event_detail(event.getResourceName(), event.getResourceStatus(), event.getReason()));
            }
        }
        catch (Exception e) {
            cLog.logError(Messages.event_failed(stack.getName()) + e.getMessage() + ExceptionUtils.getStackTrace(e));
        }
    }
}

