/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.utils;

import com.arkea.jenkins.openstack.heat.orchestration.template.Bundle;
import com.arkea.jenkins.openstack.heat.orchestration.template.Output;
import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.ConstraintUtils;
import com.arkea.jenkins.openstack.heat.orchestration.template.utils.TypeMapperUtils;
import java.util.Map;
import java.util.TreeMap;
import org.yaml.snakeyaml.Yaml;

public class HOTMapperUtils {
    public static Bundle getBundleFromHOT(String hotName, String hot) {
        Bundle stack = new Bundle(hotName, "", "", false, false, false);
        if (hot.contains("parameters") || hot.contains("outputs")) {
            Map hotObjects = (Map)new Yaml().load(hot);
            if (hot.contains("parameters")) {
                stack.setParameters(HOTMapperUtils.getParameters(hotObjects));
            }
            if (hot.contains("outputs")) {
                stack.setOutputs(HOTMapperUtils.getOutputs(hotObjects));
            }
            if (hot.contains("tags")) {
                stack.setTags(HOTMapperUtils.getTags(hotObjects));
            }
        }
        return stack;
    }

    private static Map<String, Parameter> getParameters(Map<String, Object> hotObjects) {
        TreeMap<String, Parameter> params = new TreeMap<String, Parameter>();
        Map parameters = (Map)hotObjects.get("parameters");
        for (Map.Entry entry : parameters.entrySet()) {
            Map data = (Map)entry.getValue();
            params.put((String)entry.getKey(), HOTMapperUtils.populateParameter((String)entry.getKey(), data));
        }
        return params;
    }

    private static String getTags(Map<String, Object> hotObjects) {
        return (String)hotObjects.get("tags");
    }

    private static Parameter populateParameter(String name, Map<String, Object> properties) {
        Parameter param = new Parameter(name, TypeMapperUtils.getType((String)properties.get("type")));
        if (properties.get("label") != null) {
            param.setLabel((String)properties.get("label"));
        }
        if (properties.get("description") != null) {
            param.setDescription((String)properties.get("description"));
        }
        if (properties.get("default") != null) {
            param.setDefaultValue(properties.get("default"));
        }
        if (properties.get("hidden") != null) {
            param.setHidden((Boolean)properties.get("hidden"));
        }
        if (properties.get("constraints") != null) {
            param.setConstraints(ConstraintUtils.getContraintsToPopulatParameters(properties));
        }
        return param;
    }

    private static Map<String, Output> getOutputs(Map<String, Object> hotObjects) {
        TreeMap<String, Output> exits = new TreeMap<String, Output>();
        Map outputs = (Map)hotObjects.get("outputs");
        for (Map.Entry entry : outputs.entrySet()) {
            exits.put((String)entry.getKey(), new Output((String)entry.getKey(), (String)((Map)entry.getValue()).get("description")));
        }
        return exits;
    }
}

