/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.orchestration.template.constraints;

import com.arkea.jenkins.openstack.heat.orchestration.template.Parameter;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.AbstractConstraint;
import com.arkea.jenkins.openstack.heat.orchestration.template.constraints.ConstraintType;
import java.util.HashMap;
import java.util.Map;

public class LengthConstraint
extends AbstractConstraint {
    private Map<String, Integer> limits = new HashMap<String, Integer>();

    LengthConstraint() {
        super(ConstraintType.length);
    }

    LengthConstraint(Map<String, Integer> limits, String description) {
        this();
        this.setLimits(limits);
        this.description = description;
    }

    public Map<String, Integer> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, Integer> limits) {
        this.limits = limits;
    }

    @Override
    public boolean checkConstraint(Parameter parameter) {
        int length;
        int n = length = parameter.getValue().length() == 0 ? String.valueOf(parameter.getDefaultValue()).length() : parameter.getValue().length();
        if (this.limits.containsKey("min") && length < this.limits.get("min")) {
            return false;
        }
        return !this.limits.containsKey("max") || length <= this.limits.get("max");
    }
}

