/*
 * Decompiled with CFR 0.152.
 */
package com.arkea.jenkins.openstack.heat.loader;

import com.arkea.jenkins.openstack.exception.utils.FormExceptionUtils;
import com.arkea.jenkins.openstack.heat.i18n.Messages;
import com.arkea.jenkins.openstack.heat.loader.AbstractLoader;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Scanner;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LoaderFromDir
extends AbstractLoader {
    private static Logger LOG = Logger.getLogger(LoaderFromDir.class.getName());
    private String pathHot;
    private String extHot = "yaml";
    private boolean checkEnv = false;
    private String pathEnv;
    private String extEnv = "yaml";
    private String defaultEnv;

    @DataBoundConstructor
    public LoaderFromDir(String pathHot, String extHot, JSONObject fromDirEnv) {
        this.pathHot = pathHot;
        this.extHot = extHot;
        if (fromDirEnv != null) {
            this.checkEnv = true;
            this.pathEnv = fromDirEnv.getString("pathEnv");
            this.extEnv = fromDirEnv.getString("extEnv");
            this.defaultEnv = fromDirEnv.getString("defaultEnv");
        }
    }

    public String getPathHot() {
        return this.pathHot;
    }

    public String getExtHot() {
        return this.extHot;
    }

    public boolean isCheckEnv() {
        return this.checkEnv;
    }

    public String getPathEnv() {
        return this.pathEnv;
    }

    public String getExtEnv() {
        return this.extEnv;
    }

    public String getDefaultEnv() {
        return this.defaultEnv;
    }

    @Override
    public String getDefaultEnvFileName() {
        return this.defaultEnv;
    }

    @Override
    public String[] getHots() {
        File dir = new File(this.pathHot);
        String[] lst = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(LoaderFromDir.this.extHot);
            }
        });
        if (lst == null) {
            lst = new String[]{};
        }
        return lst;
    }

    @Override
    public String[] getEnvs() {
        File dir = new File(this.pathEnv);
        String[] lst = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(LoaderFromDir.this.extEnv);
            }
        });
        if (lst == null) {
            lst = new String[]{};
        }
        return lst;
    }

    @Override
    public String getEnv(String envName) {
        return this.getFile(this.pathEnv, envName);
    }

    @Override
    public String getHot(String hotName) {
        return this.getFile(this.pathHot, hotName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFile(String path, String name) {
        StringBuilder contents = new StringBuilder();
        try (Scanner scanner = null;){
            scanner = new Scanner(new File(path + "/" + name), "UTF-8");
            while (scanner.hasNextLine()) {
                contents.append(scanner.nextLine()).append('\n');
            }
        }
        return contents.toString();
    }

    @Override
    public boolean checkData() throws Descriptor.FormException {
        if (Strings.isNullOrEmpty((String)this.pathHot)) {
            throw FormExceptionUtils.getFormException(Messages.pathHot_label(), Messages.pathHot_name());
        }
        if (Strings.isNullOrEmpty((String)this.extHot)) {
            throw FormExceptionUtils.getFormException(Messages.extHot_label(), Messages.extHot_name());
        }
        if (this.isCheckEnv()) {
            if (Strings.isNullOrEmpty((String)this.pathEnv)) {
                throw FormExceptionUtils.getFormException(Messages.pathEnv_label(), Messages.pathEnv_name());
            }
            if (Strings.isNullOrEmpty((String)this.extEnv)) {
                throw FormExceptionUtils.getFormException(Messages.extEnv_label(), Messages.extEnv_name());
            }
        }
        return true;
    }

    @Override
    public String getFullPathHot(String hotName) {
        return this.pathHot + "/" + hotName;
    }

    @Override
    public String getFullPathEnv(String envFile) {
        return this.pathEnv + "/" + envFile;
    }

    @Extension
    public static class LoaderFromDirDescriptor
    extends AbstractLoader.AbstractLoaderDescriptor {
        public String getDisplayName() {
            return "LoaderFromDir";
        }

        public FormValidation doTestPathHot(@QueryParameter(value="pathHot") String pathHot, @QueryParameter(value="extHot") String extHot) {
            if (Strings.isNullOrEmpty((String)pathHot)) {
                return FormValidation.warning((String)Messages.input_filled(Messages.pathHot_label()));
            }
            if (Strings.isNullOrEmpty((String)extHot)) {
                return FormValidation.warning((String)Messages.input_filled(Messages.extEnv_label()));
            }
            File file = new File(pathHot);
            if (file.isDirectory()) {
                return FormValidation.ok((String)Messages.formValidation_success());
            }
            return FormValidation.error((String)Messages.formValidation_errorDirectory(pathHot));
        }

        public FormValidation doTestPathEnv(@QueryParameter(value="pathEnv") String pathEnv, @QueryParameter(value="extEnv") String extEnv, @QueryParameter(value="defaultEnv") String defaultEnv) {
            if (Strings.isNullOrEmpty((String)pathEnv)) {
                return FormValidation.warning((String)Messages.input_filled(Messages.pathEnv_label()));
            }
            if (Strings.isNullOrEmpty((String)extEnv)) {
                return FormValidation.warning((String)Messages.input_filled(Messages.extEnv_label()));
            }
            File file = new File(pathEnv);
            if (file.isDirectory()) {
                File fileEnv;
                if (!Strings.isNullOrEmpty((String)defaultEnv) && !(fileEnv = new File(pathEnv + "/" + defaultEnv)).isFile()) {
                    return FormValidation.error((String)Messages.formValidation_errorDefaultNotFound(pathEnv, defaultEnv));
                }
                return FormValidation.ok((String)Messages.formValidation_success());
            }
            return FormValidation.error((String)Messages.formValidation_errorDirectory(pathEnv));
        }
    }
}

