/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.TreeMultimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.remoting.Which;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import jenkins.model.Jenkins;
import jenkins.plugins.openstack.compute.auth.OpenstackCredential;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.compute.ComputeFloatingIPService;
import org.openstack4j.api.compute.ServerService;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.api.exceptions.ResponseException;
import org.openstack4j.core.transport.Config;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.compute.Address;
import org.openstack4j.model.compute.Fault;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.FloatingIP;
import org.openstack4j.model.compute.Keypair;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;
import org.openstack4j.model.compute.ext.AvailabilityZone;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.model.image.Image;
import org.openstack4j.model.network.NetFloatingIP;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeSnapshot;
import org.openstack4j.openstack.OSFactory;

@Restricted(value={NoExternalUse.class})
@ThreadSafe
public class Openstack {
    private static final Logger LOGGER = Logger.getLogger(Openstack.class.getName());
    public static final String FINGERPRINT_KEY = "jenkins-instance";
    private final ClientProvider clientProvider;
    private static final Comparator<BasicResource> RESOURCE_COMPARATOR = new Comparator<BasicResource>(){

        @Override
        public int compare(BasicResource o1, BasicResource o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    };
    private static final Comparator<Image> IMAGE_DATE_COMPARATOR = new Comparator<Image>(){

        @Override
        public int compare(Image o1, Image o2) {
            int result = ObjectUtils.compare((Comparable)o1.getUpdatedAt(), (Comparable)o2.getUpdatedAt());
            if (result != 0) {
                return result;
            }
            result = ObjectUtils.compare((Comparable)o1.getCreatedAt(), (Comparable)o2.getCreatedAt());
            if (result != 0) {
                return result;
            }
            result = ObjectUtils.compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o1.getId()));
            return result;
        }
    };
    private static final Comparator<VolumeSnapshot> VOLUMESNAPSHOT_DATE_COMPARATOR = new Comparator<VolumeSnapshot>(){

        @Override
        public int compare(VolumeSnapshot o1, VolumeSnapshot o2) {
            int result = ObjectUtils.compare((Comparable)o1.getCreated(), (Comparable)o2.getCreated());
            if (result != 0) {
                return result;
            }
            result = ObjectUtils.compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o1.getId()));
            return result;
        }
    };
    private static final Comparator<Flavor> FLAVOR_COMPARATOR = new Comparator<Flavor>(){

        @Override
        public int compare(Flavor o1, Flavor o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    };
    private static final Comparator<AvailabilityZone> AVAILABILITY_ZONES_COMPARATOR = new Comparator<AvailabilityZone>(){

        @Override
        public int compare(AvailabilityZone o1, AvailabilityZone o2) {
            return ObjectUtils.compare((Comparable)((Object)o1.getZoneName()), (Comparable)((Object)o2.getZoneName()));
        }
    };

    private Openstack(@Nonnull String endPointUrl, boolean ignoreSsl, @Nonnull OpenstackCredential auth, @CheckForNull String region) {
        IOSClientBuilder<? extends OSClient<?>, ?> builder = auth.getBuilder(endPointUrl);
        Config config = Config.newConfig();
        if (ignoreSsl) {
            config.withSSLVerificationDisabled();
        }
        OSClient client = ((OSClient)builder.withConfig(config).authenticate()).useRegion(region);
        this.clientProvider = ClientProvider.get(client, region, config);
        Openstack.debug("Openstack client created for \"{1}\", \"{2}\".", auth.toString(), region);
    }

    public Openstack(final @Nonnull OSClient<?> client) {
        this.clientProvider = new ClientProvider(){

            @Override
            @Nonnull
            public OSClient<?> get() {
                return client;
            }

            @Override
            @Nonnull
            public String getInfo() {
                return "";
            }
        };
    }

    @Nonnull
    public String getInfo() {
        return this.clientProvider.getInfo();
    }

    @Nonnull
    public Collection<? extends Network> getSortedNetworks() {
        List<? extends Network> nets = this._listNetworks();
        Collections.sort(nets, RESOURCE_COMPARATOR);
        return nets;
    }

    @Nonnull
    @VisibleForTesting
    public List<? extends Network> _listNetworks() {
        return this.clientProvider.get().networking().network().list();
    }

    @Nonnull
    public List<String> getNetworkIds(@Nonnull List<String> nameOrIds) {
        if (nameOrIds.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> name2id = new HashMap<String, String>();
        for (Network network : this._listNetworks()) {
            name2id.put(network.getName(), network.getId());
        }
        ArrayList<String> networks = new ArrayList<String>();
        for (String requiredNetwork : nameOrIds) {
            if (name2id.containsValue(requiredNetwork)) {
                networks.add(requiredNetwork);
                continue;
            }
            String id = (String)name2id.get(requiredNetwork);
            if (id != null) {
                networks.add(id);
                continue;
            }
            LOGGER.warning("No such network: " + requiredNetwork);
        }
        return networks;
    }

    @Nonnull
    public Map<String, Collection<Image>> getImages() {
        List list = this.clientProvider.get().images().listAll();
        TreeMultimap set = TreeMultimap.create((Comparator)String.CASE_INSENSITIVE_ORDER, IMAGE_DATE_COMPARATOR);
        for (Image o : list) {
            String name = Util.fixNull((String)o.getName());
            String nameOrId = name.isEmpty() ? o.getId() : name;
            set.put((Object)nameOrId, (Object)o);
        }
        return set.asMap();
    }

    @Nonnull
    public Map<String, Collection<VolumeSnapshot>> getVolumeSnapshots() {
        List list = this.clientProvider.get().blockStorage().snapshots().list();
        TreeMultimap set = TreeMultimap.create((Comparator)String.CASE_INSENSITIVE_ORDER, VOLUMESNAPSHOT_DATE_COMPARATOR);
        for (VolumeSnapshot o : list) {
            if (o.getStatus() != Volume.Status.AVAILABLE) continue;
            String name = Util.fixNull((String)o.getName());
            String nameOrId = name.isEmpty() ? o.getId() : name;
            set.put((Object)nameOrId, (Object)o);
        }
        return set.asMap();
    }

    @Nonnull
    public Collection<? extends Flavor> getSortedFlavors() {
        List flavors = this.clientProvider.get().compute().flavors().list();
        Collections.sort(flavors, FLAVOR_COMPARATOR);
        return flavors;
    }

    @Nonnull
    public List<String> getSortedIpPools() {
        ComputeFloatingIPService ipService = this.getComputeFloatingIPService();
        if (ipService == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(ipService.getPoolNames());
        Collections.sort(names);
        return names;
    }

    @Nonnull
    public List<? extends AvailabilityZone> getAvailabilityZones() {
        List zones = this.clientProvider.get().compute().zones().list();
        Collections.sort(zones, AVAILABILITY_ZONES_COMPARATOR);
        return zones;
    }

    @CheckForNull
    private ComputeFloatingIPService getComputeFloatingIPService() {
        try {
            return this.clientProvider.get().compute().floatingIps();
        }
        catch (ClientResponseException ex) {
            if (ex.getStatus() == 403) {
                return null;
            }
            throw ex;
        }
    }

    @Nonnull
    public List<Server> getRunningNodes() {
        ArrayList<Server> running = new ArrayList<Server>();
        boolean detailed = true;
        for (Server n : this.clientProvider.get().compute().servers().list(true)) {
            if (!Openstack.isOccupied(n) || !this.isOurs(n)) continue;
            running.add(n);
        }
        return running;
    }

    public List<String> getFreeFipIds() {
        ArrayList<String> free = new ArrayList<String>();
        for (NetFloatingIP ip : this.clientProvider.get().networking().floatingip().list()) {
            if (ip.getFixedIpAddress() != null) continue;
            free.add(ip.getId());
        }
        return free;
    }

    @Nonnull
    public List<String> getSortedKeyPairNames() {
        ArrayList<String> keyPairs = new ArrayList<String>();
        for (Keypair kp : this.clientProvider.get().compute().keypairs().list()) {
            keyPairs.add(kp.getName());
        }
        return keyPairs;
    }

    @Nonnull
    public List<String> getImageIdsFor(String nameOrId) {
        Image findById;
        TreeSet<Image> sortedObjects = new TreeSet<Image>(IMAGE_DATE_COMPARATOR);
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("name", nameOrId);
        query.put("status", "active");
        List findByName = this.clientProvider.get().images().listAll(query);
        sortedObjects.addAll(findByName);
        if (nameOrId.matches("[0-9a-f-]{36}") && (findById = this.clientProvider.get().images().get(nameOrId)) != null && findById.getStatus() == Image.Status.ACTIVE) {
            sortedObjects.add(findById);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (Image i : sortedObjects) {
            ids.add(i.getId());
        }
        return ids;
    }

    @Nonnull
    public List<String> getVolumeSnapshotIdsFor(String nameOrId) {
        VolumeSnapshot findById;
        TreeSet<VolumeSnapshot> sortedObjects = new TreeSet<VolumeSnapshot>(VOLUMESNAPSHOT_DATE_COMPARATOR);
        Map<String, Collection<VolumeSnapshot>> allVolumeSnapshots = this.getVolumeSnapshots();
        Collection<VolumeSnapshot> findByName = allVolumeSnapshots.get(nameOrId);
        if (findByName != null) {
            sortedObjects.addAll(findByName);
        }
        if (nameOrId.matches("[0-9a-f-]{36}") && (findById = this.clientProvider.get().blockStorage().snapshots().get(nameOrId)) != null && findById.getStatus() == Volume.Status.AVAILABLE) {
            sortedObjects.add(findById);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (VolumeSnapshot i : sortedObjects) {
            ids.add(i.getId());
        }
        return ids;
    }

    public void setVolumeNameAndDescription(String volumeId, String newVolumeName, String newVolumeDescription) {
        ActionResponse res = this.clientProvider.get().blockStorage().volumes().update(volumeId, newVolumeName, newVolumeDescription);
        Openstack.throwIfFailed(res);
    }

    private static boolean isOccupied(@Nonnull Server server) {
        switch (server.getStatus()) {
            case UNKNOWN: 
            case MIGRATING: 
            case SHUTOFF: 
            case DELETED: {
                return false;
            }
            case UNRECOGNIZED: {
                LOGGER.log(Level.WARNING, "Machine state not recognized by openstack4j, report this as a bug: " + server);
                return true;
            }
        }
        return true;
    }

    private boolean isOurs(@Nonnull Server server) {
        return this.instanceFingerprint().equals(server.getMetadata().get(FINGERPRINT_KEY));
    }

    @Nonnull
    private String instanceFingerprint() {
        return Jenkins.getActiveInstance().getRootUrl();
    }

    @Nonnull
    public Server getServerById(@Nonnull String id) throws NoSuchElementException {
        Server server = this.clientProvider.get().compute().servers().get(id);
        if (server == null) {
            throw new NoSuchElementException("No such server running: " + id);
        }
        return server;
    }

    @Nonnull
    public List<Server> getServersByName(@Nonnull String name) {
        ArrayList<Server> ret = new ArrayList<Server>();
        for (Server server : this.clientProvider.get().compute().servers().list(Collections.singletonMap("name", name))) {
            if (!this.isOurs(server)) continue;
            ret.add(server);
        }
        return ret;
    }

    @Nonnull
    public Server bootAndWaitActive(@Nonnull ServerCreateBuilder request, @Nonnegative int timeout) throws ActionFailed {
        Openstack.debug("Booting machine", new String[0]);
        try {
            Server server = this._bootAndWaitActive(request, timeout);
            if (server == null) {
                String name = ((ServerCreate)request.build()).getName();
                List<Server> servers = this.getServersByName(name);
                String msg = "Failed to provision the " + name + " in time (" + timeout + "ms). Existing server(s): " + servers.toString();
                ActionFailed err = new ActionFailed(msg);
                try {
                    int size = servers.size();
                    if (size == 1) {
                        this.destroyServer(servers.get(0));
                    } else if (size > 1) {
                        LOGGER.warning("Unable to destroy server " + name + " as there is " + size + " of them");
                    }
                }
                catch (Throwable ex) {
                    err.addSuppressed(ex);
                }
                throw err;
            }
            Openstack.debug("Machine started: " + server.getName(), new String[0]);
            this.throwIfFailed(server);
            return server;
        }
        catch (ResponseException ex) {
            throw new ActionFailed(ex.getMessage(), ex);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Server _bootAndWaitActive(@Nonnull ServerCreateBuilder request, @Nonnegative int timeout) {
        request.addMetadataItem(FINGERPRINT_KEY, this.instanceFingerprint());
        return this.clientProvider.get().compute().servers().bootAndWaitActive((ServerCreate)request.build(), timeout);
    }

    @Nonnull
    public Server updateInfo(@Nonnull Server server) {
        return this.getServerById(server.getId());
    }

    public void destroyServer(@Nonnull Server server) throws ActionFailed {
        ServerService servers;
        String nodeId = server.getId();
        ComputeFloatingIPService fipsService = this.getComputeFloatingIPService();
        if (fipsService != null) {
            for (FloatingIP ip : fipsService.list()) {
                if (!nodeId.equals(ip.getInstanceId())) continue;
                ActionResponse res = fipsService.deallocateIP(ip.getId());
                if (res.isSuccess() || res.getCode() == 404) {
                    Openstack.debug("Deallocated Floating IP " + ip.getFloatingIpAddress(), new String[0]);
                    continue;
                }
                throw new ActionFailed("Floating IP deallocation failed for " + ip.getFloatingIpAddress() + ": " + res.getFault() + "(" + res.getCode() + ")");
            }
        }
        if ((server = (servers = this.clientProvider.get().compute().servers()).get(nodeId)) == null || server.getStatus() == Server.Status.DELETED) {
            Openstack.debug("Machine destroyed: " + nodeId, new String[0]);
            return;
        }
        ActionResponse res = servers.delete(nodeId);
        if (res.getCode() == 404) {
            Openstack.debug("Machine destroyed: " + nodeId, new String[0]);
            return;
        }
        Openstack.throwIfFailed(res);
    }

    @Nonnull
    public FloatingIP assignFloatingIp(@Nonnull Server server, @CheckForNull String poolName) throws ActionFailed {
        FloatingIP ip;
        Openstack.debug("Allocating floating IP for " + server.getName(), new String[0]);
        ComputeFloatingIPService fips = this.clientProvider.get().compute().floatingIps();
        try {
            ip = fips.allocateIP(poolName);
        }
        catch (ResponseException ex) {
            throw new ActionFailed(ex.getMessage() + " Allocating for " + server.getName(), ex);
        }
        Openstack.debug("Floating IP allocated " + ip.getFloatingIpAddress(), new String[0]);
        try {
            Openstack.debug("Assigning floating IP to " + server.getName(), new String[0]);
            ActionResponse res = fips.addFloatingIP(server, ip.getFloatingIpAddress());
            Openstack.throwIfFailed(res);
            Openstack.debug("Floating IP assigned", new String[0]);
        }
        catch (Throwable _ex) {
            ActionFailed ex = _ex instanceof ActionFailed ? (ActionFailed)_ex : new ActionFailed("Unable to assign floating IP for " + server.getName(), _ex);
            ActionResponse res = fips.deallocateIP(ip.getId());
            Openstack.logIfFailed(res);
            throw ex;
        }
        return ip;
    }

    public void destroyFip(String fip) {
        ActionResponse delete = this.clientProvider.get().networking().floatingip().delete(fip);
        if (delete.getCode() == 404) {
            return;
        }
        Openstack.throwIfFailed(delete);
    }

    @CheckForNull
    public static Address getPublicAddressObject(@Nonnull Server server) {
        Address fixed = null;
        for (List addresses : server.getAddresses().getAddresses().values()) {
            for (Address addr : addresses) {
                if ("floating".equals(addr.getType())) {
                    return addr;
                }
                fixed = addr;
            }
        }
        return fixed;
    }

    @CheckForNull
    public static String getPublicAddress(@Nonnull Server server) {
        String fixed = null;
        for (List addresses : server.getAddresses().getAddresses().values()) {
            for (Address addr : addresses) {
                if ("floating".equals(addr.getType())) {
                    return addr.getAddr();
                }
                fixed = addr.getAddr();
            }
        }
        return fixed;
    }

    @CheckForNull
    public static String getPublicAddressIpv4(@Nonnull Server server) {
        String fixed = null;
        for (List addresses : server.getAddresses().getAddresses().values()) {
            for (Address addr : addresses) {
                if ("floating".equals(addr.getType())) {
                    return addr.getAddr();
                }
                if (addr.getVersion() != 4) continue;
                fixed = addr.getAddr();
            }
        }
        return fixed;
    }

    private static boolean logIfFailed(@Nonnull ActionResponse res) {
        if (res.isSuccess()) {
            return true;
        }
        LOGGER.log(Level.INFO, res.toString());
        return false;
    }

    private static void throwIfFailed(@Nonnull ActionResponse res) {
        if (res.isSuccess()) {
            return;
        }
        throw new ActionFailed(res.toString());
    }

    private void throwIfFailed(@Nonnull Server server) {
        Server.Status status = server.getStatus();
        if (status == Server.Status.ACTIVE) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to boot server ").append(server.getName());
        if (status == Server.Status.BUILD) {
            sb.append(" in time:");
        } else {
            sb.append(":");
        }
        sb.append(" status=").append(status);
        sb.append(" vmState=").append(server.getVmState());
        Fault fault = server.getFault();
        String msg = fault == null ? "none" : String.format("%d: %s (%s)", fault.getCode(), fault.getMessage(), fault.getDetails());
        sb.append(" fault=").append(msg);
        ActionFailed ex = new ActionFailed(sb.toString());
        try {
            this.destroyServer(server);
        }
        catch (ActionFailed suppressed) {
            ex.addSuppressed(suppressed);
        }
        LOGGER.log(Level.WARNING, "Machine provisioning failed: " + server, ex);
        throw ex;
    }

    @CheckForNull
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public Throwable sanityCheck() {
        try {
            OSClient<?> client = this.clientProvider.get();
            client.networking().network().list().size();
            client.images().listMembers("");
            client.compute().listExtensions().size();
        }
        catch (Throwable ex) {
            return ex;
        }
        return null;
    }

    private static void debug(@Nonnull String msg, String ... args) {
        LOGGER.log(Level.FINE, msg, args);
    }

    static {
        try {
            File path = Which.jarFile(Objects.ToStringHelper.class);
            LOGGER.info("com.google.common.base.Objects loaded from " + path);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to get source of com.google.common.base.Objects", e);
        }
    }

    private static abstract class ClientProvider {
        private ClientProvider() {
        }

        @Nonnull
        public abstract OSClient<?> get();

        @Nonnull
        public abstract String getInfo();

        private static ClientProvider get(OSClient<?> client, String region, Config config) {
            if (client instanceof OSClient.OSClientV2) {
                return new SessionClientV2Provider((OSClient.OSClientV2)client, region, config);
            }
            if (client instanceof OSClient.OSClientV3) {
                return new SessionClientV3Provider((OSClient.OSClientV3)client, region, config);
            }
            throw new AssertionError((Object)("Unsupported openstack4j client " + client.getClass().getName()));
        }

        private static class SessionClientV3Provider
        extends ClientProvider {
            private final Token storage;
            private final String region;
            protected final Config config;

            private SessionClientV3Provider(OSClient.OSClientV3 toStore, String usedRegion, Config clientConfig) {
                this.storage = toStore.getToken();
                this.region = usedRegion;
                this.config = clientConfig;
            }

            @Override
            @Nonnull
            public OSClient<?> get() {
                return OSFactory.clientFromToken((Token)this.storage, (Config)this.config).useRegion(this.region);
            }

            @Override
            @Nonnull
            public String getInfo() {
                return "";
            }
        }

        private static class SessionClientV2Provider
        extends ClientProvider {
            protected final Access storage;
            protected final String region;
            protected final Config config;

            private SessionClientV2Provider(OSClient.OSClientV2 toStore, String usedRegion, Config clientConfig) {
                this.storage = toStore.getAccess();
                this.region = usedRegion;
                this.config = clientConfig;
            }

            @Override
            @Nonnull
            public OSClient<?> get() {
                return OSFactory.clientFromAccess((Access)this.storage, (Config)this.config).useRegion(this.region);
            }

            @Override
            @Nonnull
            public String getInfo() {
                StringBuilder sb = new StringBuilder();
                for (Access.Service service : this.storage.getServiceCatalog()) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(service.getType()).append('/').append(service.getName()).append(':').append(service.getVersion());
                }
                return sb.toString();
            }
        }
    }

    @Extension
    public static final class Factory
    extends FactoryEP {
        @Override
        @Nonnull
        public Openstack getOpenstack(@Nonnull String endPointUrl, boolean ignoreSsl, @Nonnull OpenstackCredential auth, @CheckForNull String region) throws FormValidation {
            endPointUrl = Util.fixEmptyAndTrim((String)endPointUrl);
            region = Util.fixEmptyAndTrim((String)region);
            if (endPointUrl == null) {
                throw FormValidation.error((String)"No endPoint specified");
            }
            if (auth == null) {
                throw FormValidation.error((String)"No credential specified");
            }
            return new Openstack(endPointUrl, ignoreSsl, auth, region);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class FactoryEP
    implements ExtensionPoint {
        @Nonnull
        private final transient Cache<String, Openstack> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

        @Nonnull
        public abstract Openstack getOpenstack(@Nonnull String var1, boolean var2, @Nonnull OpenstackCredential var3, @CheckForNull String var4) throws FormValidation;

        @Nonnull
        public static Openstack get(final @Nonnull String endPointUrl, final boolean ignoreSsl, final @Nonnull OpenstackCredential auth, final @Nonnull String region) throws FormValidation {
            String fingerprint = Util.getDigestOf((String)(endPointUrl + '\n' + ignoreSsl + '\n' + auth.toString() + '\n' + region));
            final FactoryEP ep = (FactoryEP)ExtensionList.lookup(FactoryEP.class).get(0);
            Callable<Openstack> cacheMissFunction = new Callable<Openstack>(){

                @Override
                public Openstack call() throws FormValidation {
                    return ep.getOpenstack(endPointUrl, ignoreSsl, auth, region);
                }
            };
            try {
                return (Openstack)ep.cache.get((Object)fingerprint, (Callable)cacheMissFunction);
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FormValidation) {
                    throw (FormValidation)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(e);
            }
        }

        @Nonnull
        public static FactoryEP replace(@Nonnull FactoryEP factory) {
            ExtensionList lookup = ExtensionList.lookup(FactoryEP.class);
            lookup.clear();
            lookup.add((Object)factory);
            return factory;
        }

        @Nonnull
        @Restricted(value={NoExternalUse.class})
        public static Cache<String, Openstack> getCache() {
            FactoryEP ep = (FactoryEP)ExtensionList.lookup(FactoryEP.class).get(0);
            return ep.cache;
        }
    }

    public static final class ActionFailed
    extends RuntimeException {
        private static final long serialVersionUID = -1657469882396520333L;

        public ActionFailed(String msg) {
            super(msg);
        }

        public ActionFailed(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

