/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.openstack.compute;

import hudson.Util;
import hudson.util.VariableResolver;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.plugins.openstack.compute.SlaveOptions;
import jenkins.slaves.JnlpSlaveAgentProtocol;

class UserDataVariableResolver
implements VariableResolver<String> {
    public static final Map<String, Entry> STUB = new LinkedHashMap<String, Entry>();
    @Nonnull
    private final String rootUrl;
    @Nonnull
    private final String serverName;
    @Nonnull
    private final String labelString;
    @Nonnull
    private final SlaveOptions opts;

    private static void stub(@Nonnull String name, @Nonnull String doc, @Nonnull ValueCalculator vc) {
        STUB.put(name, new Entry(name, doc, vc));
    }

    UserDataVariableResolver(@Nonnull String rootUrl, @Nonnull String serverName, @Nonnull String labelString, @Nonnull SlaveOptions opts) {
        this.rootUrl = rootUrl;
        this.serverName = serverName;
        this.labelString = labelString;
        this.opts = opts;
    }

    public String resolve(@Nonnull String name) {
        Entry entry = STUB.get(name);
        if (entry == null) {
            return null;
        }
        return entry.vc.get(this);
    }

    static {
        UserDataVariableResolver.stub("SLAVE_JENKINS_HOME", "The 'Remote FS Root' for the agent.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return Util.fixNull((String)r.opts.getFsRoot());
            }
        });
        UserDataVariableResolver.stub("SLAVE_JVM_OPTIONS", "The 'Custom JVM Options'.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return Util.fixNull((String)r.opts.getJvmOptions());
            }
        });
        UserDataVariableResolver.stub("JENKINS_URL", "The URL of the Jenkins instance.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return r.rootUrl;
            }
        });
        UserDataVariableResolver.stub("SLAVE_JAR_URL", "The URL of the executable slave.jar.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return r.rootUrl + "jnlpJars/slave.jar";
            }
        });
        UserDataVariableResolver.stub("SLAVE_JNLP_URL", "The endpoint URL for the JNLP connection.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return r.rootUrl + "computer/" + r.serverName + "/slave-agent.jnlp";
            }
        });
        UserDataVariableResolver.stub("SLAVE_JNLP_SECRET", "The JNLP 'secret' key.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return Util.fixNull((String)JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(r.serverName));
            }
        });
        UserDataVariableResolver.stub("SLAVE_LABELS", "Labels of the node.", new ValueCalculator(){

            @Override
            @Nonnull
            public String get(@Nonnull UserDataVariableResolver r) {
                return r.labelString;
            }
        });
    }

    private static interface ValueCalculator {
        @Nonnull
        public String get(@Nonnull UserDataVariableResolver var1);
    }

    public static final class Entry {
        @Nonnull
        private final String name;
        @Nonnull
        private final String description;
        @Nonnull
        private final ValueCalculator vc;

        private Entry(@Nonnull String name, @Nonnull String docs, @Nonnull ValueCalculator vc) {
            this.name = name;
            this.description = docs;
            this.vc = vc;
        }

        @Nonnull
        public String getDescription() {
            return this.description;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }
    }
}

