/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift.util;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jenkinsci.plugins.openshift.DeployApplication;
import org.jenkinsci.plugins.openshift.OpenShiftV2Client;
import org.jenkinsci.plugins.openshift.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    public static boolean isURL(String str) {
        return str.startsWith("http://") || str.startsWith("https://");
    }

    public static Server findServer(String selectedServer) {
        for (Server server : Utils.getServers()) {
            if (!server.getName().equals(selectedServer)) continue;
            return server;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL source, File destination, int connectionTimeout, int readTimeout) throws IOException {
        URLConnection connection = source.openConnection();
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(readTimeout);
        InputStream is = connection.getInputStream();
        FileOutputStream output = Utils.openOutputStream(destination);
        try {
            IOUtils.copy((InputStream)is, (OutputStream)output);
            output.close();
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null) {
                LOG.info("Parent exists: " + parent.exists());
                if (!parent.mkdirs() && !parent.isDirectory()) {
                    throw new IOException("Directory '" + parent + "' could not be created");
                }
            }
        }
        return new FileOutputStream(file, false);
    }

    public static void abort(BuildListener listener, String msg) throws AbortException {
        listener.error("[OPENSHIFT] " + msg);
        throw new AbortException();
    }

    public static void abort(BuildListener listener, Exception e) throws AbortException {
        Utils.abort(listener, ExceptionUtils.getStackTrace((Throwable)e));
    }

    public static void log(BuildListener listener, String msg) throws AbortException {
        listener.getLogger().println("[OPENSHIFT] " + msg);
    }

    public static String getBuildStepName(String name) {
        return "OpenShift: " + name;
    }

    private static DeployApplication.DeployApplicationDescriptor getDeployApplicationDescriptor() {
        return (DeployApplication.DeployApplicationDescriptor)Hudson.getInstance().getDescriptor(DeployApplication.class);
    }

    public static List<Server> getServers() {
        DeployApplication.DeployApplicationDescriptor descriptor = Utils.getDeployApplicationDescriptor();
        List<Server> servers = descriptor.getServers();
        return servers == null ? Collections.EMPTY_LIST : servers;
    }

    public static String getSSHPrivateKey() {
        DeployApplication.DeployApplicationDescriptor descriptor = Utils.getDeployApplicationDescriptor();
        return descriptor.getPublicKeyPath() == null ? null : descriptor.getPublicKeyPath().replaceAll("^(.*)\\.pub$", "$1");
    }

    public static File createDir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static Boolean validateOpenshiftDirectory(String openshiftDirectory) {
        ArrayList<String> validNames = new ArrayList<String>(){
            {
                this.add("openshift");
                this.add(".openshift");
                this.add("config");
                this.add("action_hooks");
                this.add("markers");
            }
        };
        File directory = null;
        directory = openshiftDirectory.startsWith(File.separator) ? new File(openshiftDirectory) : new File(Utils.class.getResource("/").getPath() + File.separator + openshiftDirectory);
        if (!directory.exists()) {
            return false;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] filesArray = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !name.equals(".") && !name.equals("..");
            }
        });
        if (filesArray == null) {
            return false;
        }
        List<String> files = Arrays.asList(filesArray);
        if (CollectionUtils.containsAny(files, (Collection)validNames)) {
            return true;
        }
        return false;
    }

    public static String getBuildWorkspaceOnMaster(AbstractBuild<?, ?> build) {
        if (Utils.runingOnMaster()) {
            return build.getWorkspace().getRemote();
        }
        return build.getProject().getBuildDir() + File.separator + build.getNumber() + File.separator + "workspace";
    }

    public static boolean runingOnMaster() {
        return Computer.currentComputer() instanceof Jenkins.MasterComputer;
    }

    public static void copyFileFromSlaveToMaster(AbstractBuild<?, ?> build, String slavePath, String masterPath) throws IOException {
        FilePath slaveFile = new FilePath(build.getWorkspace().getChannel(), slavePath);
        File masterFile = new File(masterPath);
        try {
            if (!slaveFile.exists()) {
                return;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        try {
            if (slaveFile.isDirectory()) {
                if (masterFile.exists()) {
                    FileUtils.deleteDirectory((File)masterFile);
                }
                if (!masterFile.mkdirs()) {
                    throw new IOException("Failed to create the directory on master node: " + masterPath);
                }
                slaveFile.copyRecursiveTo(new FilePath(masterFile));
            } else {
                slaveFile.copyTo(new FilePath(masterFile));
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to copy file from slave node to master.", e);
        }
    }

    public static List<String> copyDeploymenstToMaster(AbstractBuild<?, ?> build, BuildListener listener, List<String> deployments, File baseDir, OpenShiftV2Client.DeploymentType deploymentType) throws IOException {
        ArrayList<String> localDeployments = new ArrayList<String>();
        for (String deployment : deployments) {
            if (Utils.isURL(deployment)) {
                File localDeployment = new File(baseDir, Utils.getURLDeploymentName(deployment, deploymentType));
                Utils.log(listener, "Downloading the deployment from '" + deployment + "' to '" + localDeployment.getAbsolutePath() + "'");
                try {
                    Utils.copyURLToFile(new URL(deployment), localDeployment, 10000, 10000);
                }
                catch (Exception e) {
                    Utils.abort(listener, e);
                }
                localDeployments.add(localDeployment.getAbsolutePath());
                continue;
            }
            if (Utils.runingOnMaster()) {
                localDeployments.add(deployment);
                continue;
            }
            String localFile = baseDir + File.separator + FilenameUtils.getName((String)deployment);
            Utils.log(listener, "Copying the deployment from slave node to '" + localFile + "'");
            Utils.copyFileFromSlaveToMaster(build, deployment, localFile);
            localDeployments.add(localFile);
        }
        return localDeployments;
    }

    private static String getURLDeploymentName(String deployment, OpenShiftV2Client.DeploymentType deploymentType) {
        if (!Utils.isURL(deployment)) {
            throw new IllegalArgumentException("Deployment paht is not a url: " + deployment);
        }
        if (deploymentType == OpenShiftV2Client.DeploymentType.BINARY) {
            return "app.tar.gz";
        }
        String dep = deployment.toLowerCase();
        if (dep.contains(".ear")) {
            return "ROOT.ear";
        }
        if (dep.contains(".war")) {
            return "ROOT.war";
        }
        if (dep.contains("ear")) {
            return "ROOT.ear";
        }
        return "ROOT.war";
    }
}

