/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IGearProfile;
import com.openshift.client.IHttpClient;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftConnectionFactory;
import com.openshift.client.SSHPublicKey;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.openshift.OpenShiftException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenShiftV2Client {
    private String broker;
    private String username;
    private String password;
    private IOpenShiftConnection conn;

    public OpenShiftV2Client(String broker, String username, String password) {
        this.broker = broker;
        this.username = username;
        this.password = password;
        this.conn = this.createConnection();
    }

    private IOpenShiftConnection createConnection() {
        return new OpenShiftConnectionFactory().getConnection("jenkins-ci", this.username, this.password, this.broker, (IHttpClient.ISSLCertificateCallback)new TrustingISSLCertificateCallback());
    }

    public ValidationResult validate() {
        try {
            if (this.conn.getDomains().size() == 0) {
                return new ValidationResult(false, "User doesn't have any domains. Create a domain for the user in OpenShift");
            }
        }
        catch (Exception e) {
            return new ValidationResult(false, e.getMessage());
        }
        return new ValidationResult(true, "ok");
    }

    public IApplication getOrCreateApp(String appName, String domainName, List<String> cartridges, String gearProfile, Map<String, String> environmentVariables, Boolean autoScale) throws OpenShiftException {
        IUser user = this.conn.getUser();
        IDomain domain = user.getDomain(domainName);
        if (domain == null) {
            throw new OpenShiftException("Domain '" + domainName + "' doesn't exist.");
        }
        IApplication app = domain.getApplicationByName(appName);
        if (app == null) {
            ApplicationScale appScale = autoScale != false ? ApplicationScale.SCALE : ApplicationScale.NO_SCALE;
            app = StringUtils.isEmpty((CharSequence)gearProfile) ? domain.createApplication(appName, this.getStandaloneCartridge(cartridges), appScale) : domain.createApplication(appName, this.getStandaloneCartridge(cartridges), appScale, this.getGearProfile(gearProfile, domainName));
            app.addEmbeddableCartridges(this.getEmbeddedCartridge(cartridges));
            app.waitForAccessible(300000L);
        }
        if (environmentVariables != null) {
            app.addEnvironmentVariables(environmentVariables);
        }
        return app;
    }

    public IApplication deleteApp(String appName, String domainName) throws OpenShiftException {
        IUser user = this.conn.getUser();
        IDomain domain = user.getDomain(domainName);
        if (domain == null) {
            throw new OpenShiftException("Domain '" + domainName + "' doesn't exist.");
        }
        IApplication app = domain.getApplicationByName(appName);
        if (app != null) {
            app.destroy();
        }
        return app;
    }

    public List<String> getApps(String domainName) {
        IUser user = this.conn.getUser();
        IDomain domain = user.getDomain(domainName);
        if (domain == null) {
            throw new OpenShiftException("Domain '" + domainName + "' doesn't exist.");
        }
        ArrayList<String> apps = new ArrayList<String>();
        for (IApplication app : domain.getApplications()) {
            apps.add(app.getName());
        }
        return apps;
    }

    public boolean sshKeyExists(File publicKey) throws IOException {
        SSHPublicKey newKey = new SSHPublicKey(publicKey);
        IUser user = this.conn.getUser();
        for (IOpenShiftSSHKey key : user.getSSHKeys()) {
            if (!newKey.getPublicKey().equals(key.getPublicKey())) continue;
            return true;
        }
        return false;
    }

    public void uploadSSHKey(File publicKey) throws IOException {
        SSHPublicKey newKey = new SSHPublicKey(publicKey);
        String address = null;
        try {
            address = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            address = RandomStringUtils.randomAlphabetic((int)16);
        }
        this.conn.getUser().addSSHKey("jenkins-ci-" + address, (ISSHPublicKey)newKey);
    }

    private IGearProfile getGearProfile(String gearProfile, String domainName) {
        for (IGearProfile profile : this.conn.getUser().getDomain(domainName).getAvailableGearProfiles()) {
            if (!profile.getName().equals(gearProfile)) continue;
            return profile;
        }
        return null;
    }

    private IStandaloneCartridge getStandaloneCartridge(List<String> cartridgeNames) {
        for (String cartridgeName : cartridgeNames) {
            for (IStandaloneCartridge cartridge : this.conn.getStandaloneCartridges()) {
                if (!cartridge.getName().equals(cartridgeName)) continue;
                return cartridge;
            }
        }
        return null;
    }

    private List<IEmbeddableCartridge> getEmbeddedCartridge(List<String> cartridgeNames) {
        LinkedList<IEmbeddableCartridge> embeddableCartridges = new LinkedList<IEmbeddableCartridge>();
        for (String cartridgeName : cartridgeNames) {
            for (IEmbeddableCartridge cartridge : this.conn.getEmbeddableCartridges()) {
                if (!cartridge.getName().equals(cartridgeName)) continue;
                embeddableCartridges.add(cartridge);
            }
        }
        return embeddableCartridges;
    }

    public List<String> getCartridges() {
        LinkedList<String> cartridges = new LinkedList<String>();
        for (ICartridge cartridge : this.conn.getCartridges()) {
            cartridges.add(cartridge.getName());
        }
        return cartridges;
    }

    public List<String> getGearProfiles() {
        LinkedList<String> gearProfiles = new LinkedList<String>();
        IDomain domain = this.conn.getUser().getDefaultDomain();
        if (domain != null) {
            for (IGearProfile gearProfile : domain.getAvailableGearProfiles()) {
                gearProfiles.add(gearProfile.getName());
            }
        }
        return gearProfiles;
    }

    public List<String> getDomains() {
        LinkedList<String> domains = new LinkedList<String>();
        for (IDomain domain : this.conn.getUser().getDomains()) {
            domains.add(domain.getId());
        }
        return domains;
    }

    static class ValidationResult {
        private boolean valid;
        private String message;

        public ValidationResult(boolean valid, String message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class TrustingISSLCertificateCallback
    implements IHttpClient.ISSLCertificateCallback {
        public boolean allowCertificate(X509Certificate[] certs) {
            return true;
        }

        public boolean allowHostname(String hostname, SSLSession session) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeploymentType {
        GIT,
        BINARY;

    }
}

