/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift;

import com.openshift.client.IApplication;
import com.openshift.client.IHttpClient;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jenkinsci.plugins.openshift.AbstractDescriptor;
import org.jenkinsci.plugins.openshift.GitClient;
import org.jenkinsci.plugins.openshift.OpenShiftV2Client;
import org.jenkinsci.plugins.openshift.SSHClient;
import org.jenkinsci.plugins.openshift.Server;
import org.jenkinsci.plugins.openshift.util.JenkinsLogger;
import org.jenkinsci.plugins.openshift.util.Utils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployApplication
extends Builder
implements BuildStep {
    private static final String WORK_DIR = "/openshift-deployer-workdir";
    private static final Logger LOG = Logger.getLogger(DeployApplication.class.getName());
    private String serverName;
    private String cartridges;
    private String domain;
    private String gearProfile;
    private String appName;
    private String deploymentPackage;
    private String environmentVariables;
    private Boolean autoScale;
    private OpenShiftV2Client.DeploymentType deploymentType = OpenShiftV2Client.DeploymentType.GIT;
    private String openshiftDirectory;

    @DataBoundConstructor
    public DeployApplication(String serverName, String appName, String cartridges, String domain, String gearProfile, String deploymentPackage, String environmentVariables, Boolean autoScale, OpenShiftV2Client.DeploymentType deploymentType, String openshiftDirectory) {
        this.serverName = serverName;
        this.appName = appName;
        this.cartridges = cartridges;
        this.domain = domain;
        this.gearProfile = gearProfile;
        this.deploymentPackage = deploymentPackage;
        this.environmentVariables = environmentVariables;
        this.autoScale = autoScale;
        this.deploymentType = deploymentType;
        this.openshiftDirectory = openshiftDirectory;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build != null && build.getResult() != null && build.getResult().isWorseThan(Result.SUCCESS)) {
            Utils.abort(listener, "Build is not success : will not try to deploy.");
        }
        if (StringUtils.isEmpty((CharSequence)this.appName)) {
            Utils.abort(listener, "Application name is not specified.");
        }
        if (StringUtils.isEmpty((CharSequence)this.cartridges)) {
            Utils.abort(listener, "Cartridges are not specified.");
        }
        if (StringUtils.isEmpty((CharSequence)this.deploymentPackage)) {
            Utils.abort(listener, "Deployment path is not specified.");
        }
        try {
            IApplication app;
            List<String> deployments = this.findDeployments(build, listener);
            if (deployments.isEmpty()) {
                Utils.abort(listener, "No packages found to deploy to OpenShift.");
            } else {
                Utils.log(listener, "Deployments found: " + deployments);
            }
            Server server = Utils.findServer(this.serverName);
            if (server == null) {
                Utils.abort(listener, "No OpenShift server is selected or none are defined in Jenkins Configuration.");
            }
            Utils.log(listener, "Deploying to OpenShift at http://" + server.getBrokerAddress() + ". Be patient! It might take a minute...");
            OpenShiftV2Client client = new OpenShiftV2Client(server.getBrokerAddress(), server.getUsername(), server.getPassword());
            String targetDomain = this.domain;
            if (StringUtils.isEmpty((CharSequence)targetDomain)) {
                List<String> domains = client.getDomains();
                if (domains.size() > 1) {
                    Utils.abort(listener, "Specify the user domain. " + domains.size() + " domains found on the account.");
                } else if (domains.isEmpty()) {
                    Utils.abort(listener, "No domains exist. Create a domain first.");
                }
                targetDomain = domains.get(0);
            }
            if (StringUtils.isEmpty((CharSequence)this.environmentVariables)) {
                app = client.getOrCreateApp(this.appName, targetDomain, Arrays.asList(this.cartridges.split(" ")), this.gearProfile, null, this.autoScale);
            } else {
                HashMap<String, String> mapOfEnvironmentVariables = new HashMap<String, String>();
                for (String environmentVariable : Arrays.asList(this.environmentVariables.split(" "))) {
                    if (environmentVariable.contains("=")) {
                        String[] parts = environmentVariable.split("=");
                        mapOfEnvironmentVariables.put(parts[0], parts[1]);
                        continue;
                    }
                    Utils.abort(listener, "Invalid environment variable: " + environmentVariable);
                }
                app = client.getOrCreateApp(this.appName, targetDomain, Arrays.asList(this.cartridges.split(" ")), this.gearProfile, mapOfEnvironmentVariables, this.autoScale);
            }
            this.deploy(deployments, app, build, listener);
        }
        catch (Exception e) {
            Utils.abort(listener, e);
        }
        return true;
    }

    private void deploy(List<String> deployments, IApplication app, AbstractBuild<?, ?> build, BuildListener listener) throws GitAPIException, IOException {
        if (deployments == null || deployments.isEmpty()) {
            Utils.abort(listener, "Deployment package list is empty.");
        }
        if (this.deploymentType == OpenShiftV2Client.DeploymentType.BINARY) {
            this.doBinaryDeploy(deployments.get(0), app, build, listener);
        } else {
            this.doGitDeploy(deployments, app, build, listener);
        }
        Utils.log(listener, "Application deployed to " + app.getApplicationUrl());
    }

    private void doBinaryDeploy(String deployment, IApplication app, AbstractBuild<?, ?> build, BuildListener listener) throws IOException {
        if (!app.getDeploymentType().equalsIgnoreCase(OpenShiftV2Client.DeploymentType.BINARY.name())) {
            app.setDeploymentType(OpenShiftV2Client.DeploymentType.BINARY.toString().toLowerCase());
        }
        File baseDir = this.createBaseDirOnMaster(build);
        List<String> localDeployments = Utils.copyDeploymenstToMaster(build, listener, Collections.singletonList(deployment), baseDir, this.deploymentType);
        SSHClient sshClient = new SSHClient(app);
        sshClient.setLogger(new JenkinsLogger(listener));
        sshClient.setSSHPrivateKey(Utils.getSSHPrivateKey());
        sshClient.deploy(new File(localDeployments.get(0)));
    }

    private void doGitDeploy(List<String> deployments, IApplication app, AbstractBuild<?, ?> build, BuildListener listener) throws GitAPIException, IOException {
        File baseDir = this.createBaseDirOnMaster(build);
        String commitMsg = "deployment added for Jenkins build " + build.getDisplayName() + "#" + build.getNumber();
        String relativeDeployPath = this.cartridges.contains("jbossews") ? "/webapps" : "/deployments";
        String dotOpenshiftDir = null;
        if (!StringUtils.isEmpty((CharSequence)this.openshiftDirectory)) {
            dotOpenshiftDir = new File(this.openshiftDirectory).isAbsolute() ? this.openshiftDirectory : build.getWorkspace() + File.separator + this.openshiftDirectory;
            if (!Utils.runingOnMaster()) {
                String localDotOpenShiftDir = baseDir + File.separator + ".openshift";
                Utils.copyFileFromSlaveToMaster(build, dotOpenshiftDir, localDotOpenShiftDir);
                dotOpenshiftDir = localDotOpenShiftDir;
            }
        }
        List<String> localDeployments = Utils.copyDeploymenstToMaster(build, listener, deployments, baseDir, this.deploymentType);
        File gitBaseDir = new File(baseDir, "git");
        GitClient gitClient = new GitClient(app);
        gitClient.setLogger(new JenkinsLogger(listener));
        gitClient.deploy(localDeployments, gitBaseDir, relativeDeployPath, commitMsg, dotOpenshiftDir);
    }

    private File createBaseDirOnMaster(AbstractBuild<?, ?> build) throws IOException {
        String baseDirPath = Utils.getBuildWorkspaceOnMaster(build) + WORK_DIR;
        File baseDir = new File(baseDirPath);
        if (baseDir.exists()) {
            FileUtils.deleteDirectory((File)baseDir);
        }
        baseDir.mkdirs();
        return baseDir;
    }

    private List<String> findDeployments(AbstractBuild<?, ?> build, BuildListener listener) throws AbortException {
        ArrayList<String> deployments = new ArrayList<String>();
        if (Utils.isURL(this.deploymentPackage)) {
            try {
                deployments.add(TokenMacro.expand(build, (TaskListener)listener, (String)this.deploymentPackage));
            }
            catch (Exception e) {
                throw new AbortException(e.getMessage());
            }
        }
        VirtualChannel channel = build.getWorkspace().getChannel();
        String filePath = null;
        filePath = new File(this.deploymentPackage).isAbsolute() ? this.deploymentPackage : build.getWorkspace() + File.separator + this.deploymentPackage;
        FilePath dir = new FilePath(channel, filePath);
        LOG.fine("Using hudson.FilePath for resolving content for deploy:\n    Channel: " + channel + " \n    FilePath: " + filePath);
        try {
            if (!dir.exists()) {
                Utils.abort(listener, "Directory '" + dir + "' doesn't exist. No deployments found!");
            }
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
        try {
            if (dir.isDirectory()) {
                FilePath[] deploymentFiles;
                String includes = null;
                includes = this.deploymentType == OpenShiftV2Client.DeploymentType.BINARY ? "*.tar.gz" : "*.ear,*.war";
                for (FilePath file : deploymentFiles = dir.list(includes)) {
                    deployments.add(file.getRemote());
                    LOG.fine("Adding " + file.getRemote() + " to deployment list");
                }
            } else if (!dir.isDirectory() && (dir.getRemote().toLowerCase().endsWith(".ear") || dir.getRemote().toLowerCase().endsWith(".war") || dir.getRemote().toLowerCase().endsWith(".tar.gz"))) {
                deployments.add(dir.getRemote());
                LOG.fine("Adding " + dir.getRemote() + " to the deployment list");
            }
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
        if (deployments.isEmpty()) {
            Utils.abort(listener, "No Deployments found! (configuredValue: " + this.deploymentPackage + ")");
        }
        return deployments;
    }

    public boolean isBinaryDeploy() {
        return this.deploymentType == OpenShiftV2Client.DeploymentType.BINARY;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getCartridges() {
        return this.cartridges;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getGearProfile() {
        return this.gearProfile;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDeploymentPackage() {
        return this.deploymentPackage;
    }

    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Boolean autoScale() {
        return this.autoScale;
    }

    public OpenShiftV2Client.DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DeployApplicationDescriptor
    extends AbstractDescriptor {
        private final String DEFAULT_PUBLICKEY_PATH = System.getProperty("user.home") + "/.ssh/id_rsa.pub";
        private List<Server> servers = new ArrayList<Server>();
        public String publicKeyPath;

        public DeployApplicationDescriptor() {
            super(DeployApplication.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            Object s = json.get("servers");
            this.servers = !JSONNull.getInstance().equals(s) ? req.bindJSONToList(Server.class, s) : null;
            this.publicKeyPath = json.getString("publicKeyPath");
            this.save();
            return super.configure(req, json);
        }

        public String getDisplayName() {
            return Utils.getBuildStepName("Deploy Application");
        }

        public List<Server> getServers() {
            return this.servers;
        }

        public String getPublicKeyPath() {
            return StringUtils.isEmpty((CharSequence)this.publicKeyPath) ? this.DEFAULT_PUBLICKEY_PATH : this.publicKeyPath;
        }

        public FormValidation doCheckLogin(@QueryParameter(value="brokerAddress") String brokerAddress, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            OpenShiftV2Client client = new OpenShiftV2Client(brokerAddress, username, password);
            OpenShiftV2Client.ValidationResult result = client.validate();
            if (result.isValid()) {
                return FormValidation.ok((String)"Success");
            }
            return FormValidation.error((String)result.getMessage());
        }

        public FormValidation doUploadSSHKeys(@QueryParameter(value="brokerAddress") String brokerAddress, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password, @QueryParameter(value="publicKeyPath") String publicKeyPath) {
            OpenShiftV2Client client = new OpenShiftV2Client(brokerAddress, username, password);
            try {
                if (publicKeyPath == null) {
                    return FormValidation.error((String)"Specify the path to SSH public key.");
                }
                File file = new File(publicKeyPath);
                if (!file.exists()) {
                    return FormValidation.error((String)("Specified SSH public key doesn't exist: " + publicKeyPath));
                }
                if (client.sshKeyExists(file)) {
                    return FormValidation.ok((String)"SSH public key already exists.");
                }
                client.uploadSSHKey(file);
                return FormValidation.ok((String)"SSH Public key uploaded successfully.");
            }
            catch (IOException e) {
                e.printStackTrace();
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillGearProfileItems(@QueryParameter(value="serverName") String serverName) {
            ListBoxModel items = new ListBoxModel();
            Server server = Utils.findServer(serverName);
            if (server == null) {
                return items;
            }
            OpenShiftV2Client client = new OpenShiftV2Client(server.getBrokerAddress(), server.getUsername(), server.getPassword());
            for (String gearProfile : client.getGearProfiles()) {
                items.add(gearProfile, gearProfile);
            }
            return items;
        }

        public FormValidation doCheckPublicKeyPath(@QueryParameter(value="publicKeyPath") String path) {
            File file = new File(path);
            if (!file.exists()) {
                return FormValidation.error((String)("Public key doesn't exist at " + path));
            }
            return FormValidation.ok();
        }
    }

    public static class TrustingISSLCertificateCallback
    implements IHttpClient.ISSLCertificateCallback {
        public boolean allowCertificate(X509Certificate[] certs) {
            return true;
        }

        public boolean allowHostname(String hostname, SSLSession session) {
            return true;
        }
    }
}

