/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift;

import com.openshift.client.IApplication;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.openshift.AbstractDescriptor;
import org.jenkinsci.plugins.openshift.OpenShiftV2Client;
import org.jenkinsci.plugins.openshift.Server;
import org.jenkinsci.plugins.openshift.util.Utils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteApplication
extends Builder
implements BuildStep {
    private String serverName;
    private String domain;
    private String appName;

    @DataBoundConstructor
    public DeleteApplication(String serverName, String appName, String domain) {
        this.serverName = serverName;
        this.appName = appName;
        this.domain = domain;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build != null && build.getResult() != null && build.getResult().isWorseThan(Result.SUCCESS)) {
            Utils.abort(listener, "Build is not success.");
        }
        if (StringUtils.isEmpty((CharSequence)this.appName)) {
            Utils.abort(listener, "Application name is not specified.");
        }
        try {
            IApplication deletedApp;
            Server server = Utils.findServer(this.serverName);
            if (server == null) {
                Utils.abort(listener, "No OpenShift server is selected or none are defined in Jenkins Configuration.");
            }
            OpenShiftV2Client client = new OpenShiftV2Client(server.getBrokerAddress(), server.getUsername(), server.getPassword());
            String targetDomain = this.domain;
            if (StringUtils.isEmpty((CharSequence)targetDomain)) {
                List<String> domains = client.getDomains();
                if (domains.size() > 1) {
                    Utils.abort(listener, "Specify the user domain. " + domains.size() + " domains found on the account.");
                } else if (domains.isEmpty()) {
                    Utils.abort(listener, "No domains exist. Cannot delete the gear.");
                }
                targetDomain = domains.get(0);
            }
            if ((deletedApp = client.deleteApp(this.appName, targetDomain)) != null) {
                Utils.log(listener, "Application '" + this.appName + "' [" + deletedApp.getApplicationUrl() + "] is deleted.");
            } else {
                Utils.log(listener, "Application '" + this.appName + "' is not found.");
            }
        }
        catch (Exception e) {
            Utils.abort(listener, e.getMessage());
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAppName() {
        return this.appName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DeleteApplicationDescriptor
    extends AbstractDescriptor {
        public DeleteApplicationDescriptor() {
            super(DeleteApplication.class);
            this.load();
        }

        public String getDisplayName() {
            return Utils.getBuildStepName("Delete Application");
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

