/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.openshift;

import hudson.model.AbstractProject;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import org.jenkinsci.plugins.openshift.OpenShiftV2Client;
import org.jenkinsci.plugins.openshift.Server;
import org.jenkinsci.plugins.openshift.util.Utils;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDescriptor
extends BuildStepDescriptor<Builder> {
    public AbstractDescriptor() {
    }

    public AbstractDescriptor(Class<? extends Builder> clazz) {
        super(clazz);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public ListBoxModel doFillDomainItems(@QueryParameter(value="serverName") String serverName) {
        ListBoxModel items = new ListBoxModel();
        Server server = Utils.findServer(serverName);
        if (server == null) {
            return items;
        }
        OpenShiftV2Client client = new OpenShiftV2Client(server.getBrokerAddress(), server.getUsername(), server.getPassword());
        for (String domain : client.getDomains()) {
            items.add(domain, domain);
        }
        return items;
    }

    public ListBoxModel doFillServerNameItems() {
        ListBoxModel items = new ListBoxModel();
        for (Server server : Utils.getServers()) {
            items.add(server.getName(), server.getName());
        }
        return items;
    }
}

