/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.tasks.BuildWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelBadgeAction;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelParameterValue;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.wrapper.TriggerNextBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeParameterValue
extends LabelParameterValue {
    private static final long serialVersionUID = 1L;
    private List<String> nextLabels;

    @DataBoundConstructor
    public NodeParameterValue(String name, List<String> labels) {
        super(name);
        if (labels != null && !labels.isEmpty()) {
            this.setLabel(labels.get(0).trim());
            if (labels.size() > 1) {
                List<String> subList = labels.subList(1, labels.size());
                this.nextLabels = new ArrayList<String>();
                for (String l : subList) {
                    this.nextLabels.add(l.trim());
                }
            }
        } else {
            throw new IllegalArgumentException("at least one label must be given!");
        }
    }

    public NodeParameterValue(String name, String description, String label) {
        super(name, description, label);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[NodeParameterValue: ");
        s.append(this.name).append("=").append(this.getLabel());
        if (this.nextLabels != null && !this.nextLabels.isEmpty()) {
            s.append(", nextNodes=").append(this.nextLabels);
        }
        s.append("]");
        return s.toString();
    }

    public List<String> getNextLabels() {
        return this.nextLabels;
    }

    @Override
    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        build.addAction((Action)new LabelBadgeAction(this.getLabel(), Messages.LabelBadgeAction_node_tooltip(this.getLabel())));
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)build.getProject().getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            List parameterDefinitions = property.getParameterDefinitions();
            for (ParameterDefinition paramDef : parameterDefinitions) {
                if (!(paramDef instanceof NodeParameterDefinition)) continue;
                NodeParameterDefinition nodeParameterDefinition = (NodeParameterDefinition)paramDef;
                if (nodeParameterDefinition.getAllowMultiNodeSelection()) {
                    return new TriggerNextBuildWrapper(nodeParameterDefinition);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeParameterValue that = (NodeParameterValue)((Object)o);
        return !(this.nextLabels != null ? !((Object)this.nextLabels).equals(that.nextLabels) : that.nextLabels != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nextLabels != null ? ((Object)this.nextLabels).hashCode() : 0);
        return result;
    }
}

