/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.model.Node;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.DetectionFailedException;
import jenkins.plugins.nodejs.tools.Platform;

class ToolsUtils {
    private ToolsUtils() {
    }

    public static Platform getPlatform(Node node) throws DetectionFailedException {
        return Platform.of(node);
    }

    public static CPU getCPU(Node node) throws DetectionFailedException {
        return ToolsUtils.getCPU(node, false);
    }

    public static CPU getCPU(Node node, boolean force32bit) throws DetectionFailedException {
        CPU nodeCPU = CPU.of(node);
        if (force32bit) {
            if (!ToolsUtils.support32Bit(nodeCPU)) {
                throw new DetectionFailedException(Messages.SystemTools_unsupported32bitArchitecture());
            }
            if (nodeCPU == CPU.amd64) {
                nodeCPU = CPU.i386;
            }
        }
        return nodeCPU;
    }

    private static boolean support32Bit(CPU cpu) {
        switch (cpu) {
            case armv6l: 
            case armv7l: 
            case i386: 
            case amd64: {
                return true;
            }
        }
        return false;
    }
}

