/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.NodeJSInstaller;
import jenkins.plugins.nodejs.tools.Platform;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class NodeJSInstallation
extends ToolInstallation
implements EnvironmentSpecific<NodeJSInstallation>,
NodeSpecific<NodeJSInstallation> {
    @DataBoundConstructor
    public NodeJSInstallation(@Nonnull String name, @Nonnull String home, List<? extends ToolProperty<?>> properties) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
    }

    public NodeJSInstallation forEnvironment(EnvVars environment) {
        return new NodeJSInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public NodeJSInstallation forNode(@Nonnull Node node, TaskListener log) throws IOException, InterruptedException {
        return new NodeJSInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public void buildEnvVars(EnvVars env) {
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put("NODEJS_HOME", home);
        env.override("PATH+NODEJS", this.getBin());
    }

    public String getExecutable(Launcher launcher) throws InterruptedException, IOException {
        return (String)launcher.getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){
            private static final long serialVersionUID = -8509941141741046422L;

            public String call() throws IOException {
                Platform platform;
                File exe;
                Node node = Computer.currentComputer().getNode();
                if (node != null && (exe = NodeJSInstallation.this.getExeFile(platform = Platform.of(node))).exists()) {
                    return exe.getPath();
                }
                return null;
            }
        });
    }

    private File getExeFile(@Nonnull Platform platform) {
        File bin = new File(this.getHome(), platform.binFolder);
        return new File(bin, platform.nodeFileName);
    }

    private String getBin() {
        Boolean isUnix = Computer.currentComputer().isUnix();
        return new File(this.getHome(), (isUnix == null || isUnix.booleanValue() ? Platform.LINUX : Platform.WINDOWS).binFolder).getPath();
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<NodeJSInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.NodeJSInstallation_displayName();
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new NodeJSInstaller(null, null, 72L));
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            boolean result = super.configure(req, json);
            this.save();
            return result;
        }
    }
}

