/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import com.google.common.base.Throwables;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jenkins.plugins.nodejs.NodeJSPlugin;
import jenkins.plugins.nodejs.tools.DecoratedLauncher;
import jenkins.plugins.nodejs.tools.Messages;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.NodeJSInstaller;
import org.kohsuke.stapler.DataBoundConstructor;

public class NpmPackagesBuildWrapper
extends BuildWrapper {
    private String nodeJSInstallationName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public NpmPackagesBuildWrapper(String nodeJSInstallationName) {
        this.nodeJSInstallationName = nodeJSInstallationName;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public String getNodeJSInstallationName() {
        return this.nodeJSInstallationName;
    }

    public Launcher decorateLauncher(final AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return new DecoratedLauncher(launcher){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                String[] starterEnvs;
                try {
                    starterEnvs = starter.envs();
                }
                catch (NullPointerException ex) {
                    starterEnvs = new String[]{};
                }
                EnvVars vars = this.toEnvVars(starterEnvs);
                NodeJSInstallation nodeJSInstallation = NodeJSPlugin.instance().findInstallationByName(NpmPackagesBuildWrapper.this.nodeJSInstallationName);
                try {
                    nodeJSInstallation = nodeJSInstallation.forNode(build.getBuiltOn(), this.listener);
                }
                catch (InterruptedException e) {
                    Throwables.propagate((Throwable)e);
                }
                nodeJSInstallation = nodeJSInstallation.forEnvironment(vars);
                String overridenPaths = (String)vars.get((Object)"PATH");
                overridenPaths = overridenPaths + File.pathSeparator + NodeJSInstaller.binFolderOf(nodeJSInstallation, build.getBuiltOn());
                vars.override("PATH", overridenPaths);
                return super.launch(starter.envs(Util.mapToEnv((Map)vars)));
            }

            private EnvVars toEnvVars(String[] envs) {
                EnvVars vars = new EnvVars();
                for (String line : envs) {
                    vars.addLine(line);
                }
                return vars;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(NpmPackagesBuildWrapper.class);
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public NodeJSInstallation[] getInstallations() {
            return NodeJSPlugin.instance().getInstallations();
        }

        public String getDisplayName() {
            return Messages.NpmPackagesBuildWrapper_displayName();
        }
    }
}

