/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import hudson.Plugin;
import hudson.model.Hudson;
import java.io.IOException;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;

public class NodeJSPlugin
extends Plugin {
    NodeJSInstallation[] installations;

    public void start() throws Exception {
        super.start();
        this.load();
        if (this.installations == null) {
            this.installations = new NodeJSInstallation[0];
        }
    }

    public NodeJSInstallation[] getInstallations() {
        return this.installations;
    }

    public NodeJSInstallation findInstallationByName(String name) {
        for (NodeJSInstallation nodeJSInstallation : this.getInstallations()) {
            if (!name.equals(nodeJSInstallation.getName())) continue;
            return nodeJSInstallation;
        }
        throw new IllegalArgumentException("NodeJS Installation not found : " + name);
    }

    public void setInstallations(NodeJSInstallation[] installations) {
        this.installations = installations;
        try {
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NodeJSPlugin instance() {
        return (NodeJSPlugin)Hudson.getInstance().getPlugin(NodeJSPlugin.class);
    }
}

