/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.plugins.nested_view.NestedViewGlobalConfig;
import hudson.plugins.nested_view.NestedViewsSearch;
import hudson.search.Search;
import hudson.search.SearchFactory;
import hudson.search.SearchableModelObject;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class NestedViewsSearchFactory
extends SearchFactory {
    private static int tmpSkip = 0;

    public static boolean isTmpSkip() {
        return tmpSkip > 0;
    }

    public static void setTmpSkip(int n) {
        tmpSkip = n;
    }

    public static void resetTmpSkip() {
        --tmpSkip;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Well if several users searches in prallel this would be evil")
    public Search createFor(SearchableModelObject owner) {
        if (NestedViewGlobalConfig.getInstance().isNestedViewSearch()) {
            if (NestedViewsSearchFactory.isTmpSkip()) {
                return new Search(){

                    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
                        super.doIndex(req, rsp);
                        NestedViewsSearchFactory.resetTmpSkip();
                    }
                };
            }
            return new NestedViewsSearch();
        }
        return new Search();
    }
}

