/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import hudson.plugins.nested_view.NestedViewsSearch;
import hudson.plugins.nested_view.NestedViewsSearchFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Query {
    private static final int MIN_LENGTH = 2;
    private final String original;
    private final String withoutArguments;
    private boolean multiline;
    private int searchByNvr = -1;
    private boolean searchByJobComment = false;
    private int searchByBuildComment = -1;
    private int searchByArtifacts = -1;
    private int maxArtifacts = -1;
    private boolean nvrFinalFilter;
    private boolean artifactFinalFilter;
    private boolean buildCommentFinalFilter;
    private boolean projectInfo;
    private boolean jobComment;
    private boolean buildComment;
    private int stats = -1;
    private boolean statsTable = false;
    private int builds = -1;
    private int last = -1;
    private int sort = 1;
    private String yymmddhhmm = null;
    private String where = "vnj";
    private String how = "c";
    private String bool = "";
    private String part = "f";
    private boolean invert = false;

    public String getOriginal() {
        return this.original;
    }

    public String getWhere() {
        return this.where;
    }

    public String getBool() {
        return this.bool;
    }

    public String getPart() {
        return this.part;
    }

    public int getSort() {
        return this.sort;
    }

    public Query(boolean search, String ooriginal) {
        if (search) {
            NestedViewsSearchFactory.resetTmpSkip();
        }
        this.original = ooriginal.trim();
        String query = null;
        try {
            Pattern getQuery = Pattern.compile("-.*:");
            Matcher m = getQuery.matcher(this.original);
            m.find();
            query = m.group();
        }
        catch (Exception getQuery) {
            // empty catch block
        }
        if (query != null) {
            this.withoutArguments = this.original.replace(query, "").trim();
            if (this.withoutArguments.contains(".*")) {
                this.how = "r";
            }
            if (query.contains("X") && search) {
                String l = query.replaceAll(".*X", "");
                int n = 1;
                if (l.length() > 0) {
                    try {
                        l = l.substring(0, 1);
                        n = Integer.parseInt(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NestedViewsSearchFactory.setTmpSkip(n);
            }
            if (query.contains("D") || query.contains("d")) {
                if (search) {
                    if (query.contains("D")) {
                        this.nvrFinalFilter = true;
                        this.searchByNvr = this.getNumber(query, "D", 1);
                    } else {
                        this.searchByNvr = this.getNumber(query, "d", 1);
                    }
                }
                this.bool = "o";
                if (this.builds <= 0) {
                    this.builds = 10;
                }
            }
            if (query.contains("#")) {
                this.jobComment = true;
                if (search) {
                    int hashes = 0;
                    for (int i = 0; i < query.length(); ++i) {
                        if (query.charAt(i) != '#') continue;
                        ++hashes;
                    }
                    if (hashes > 1) {
                        this.searchByJobComment = true;
                    }
                }
            }
            if (query.contains("/")) {
                this.buildComment = true;
                if (search) {
                    int slashes = 0;
                    for (int i = 0; i < query.length(); ++i) {
                        if (query.charAt(i) != '/') continue;
                        ++slashes;
                    }
                    if (slashes > 1) {
                        this.searchByBuildComment = this.getNumber(query, "/", 1);
                    }
                    if (slashes > 2) {
                        this.buildCommentFinalFilter = true;
                    }
                }
                this.bool = "o";
                if (this.builds <= 0) {
                    this.builds = 10;
                }
            }
            if (query.contains("I") || query.contains("i")) {
                if (search) {
                    if (query.contains("I")) {
                        this.artifactFinalFilter = true;
                        this.searchByArtifacts = this.getNumber(query, "I", 1);
                    } else {
                        this.searchByArtifacts = this.getNumber(query, "i", 1);
                    }
                }
                this.bool = "o";
                if (this.builds <= 0) {
                    this.builds = 10;
                }
                if (this.maxArtifacts <= 0) {
                    this.maxArtifacts = 10;
                }
            }
            if (query.contains("A") && search) {
                this.maxArtifacts = this.getNumber(query, "A", 10);
            }
            if (query.contains("m") && search) {
                this.multiline = true;
            }
            if (query.contains("P") && search) {
                this.projectInfo = true;
            }
            if (query.contains("S") && search) {
                if (query.contains("SS")) {
                    this.statsTable = true;
                }
                this.stats = this.getNumber(query, "S", 10);
            }
            if (query.contains("B") && search) {
                this.builds = this.getNumber(query, "B", 10);
            }
            if (query.contains("L") && search) {
                this.last = this.getNumber(query, "L", 0);
                if (this.last == 0) {
                    this.last = 1234567;
                }
            } else {
                this.last = -1;
            }
            if (query.contains("T") && search) {
                long time = this.getLongNumber(query, "T", 0L);
                String stime = "" + time;
                if (stime.length() == 10) {
                    this.yymmddhhmm = stime;
                } else {
                    NestedViewsSearch.LOGGER.log(Level.WARNING, "T have invlaid argument - " + stime + "; is not 10 chars of yymmddhhmm long");
                }
            }
            if (query.contains("t")) {
                this.sort = this.getNumber(query, "t", 1);
            }
            if (query.contains("j") || query.contains("v") || query.contains("n") || query.contains("w")) {
                this.where = "";
            }
            if (query.contains("j")) {
                this.where = this.where + "j";
            }
            if (query.contains("v")) {
                this.where = this.where + "v";
            }
            if (query.contains("n")) {
                this.where = this.where + "n";
            }
            if (query.contains("w")) {
                this.where = this.where + "vn";
            }
            if (query.contains("c")) {
                this.how = "c";
            }
            if (query.contains("e")) {
                this.how = "e";
            }
            if (query.contains("s")) {
                this.how = "s";
            }
            if (query.contains("r")) {
                this.how = "r";
            }
            if (query.contains("R")) {
                this.how = "R";
            }
            if (query.contains("q")) {
                this.how = "q";
            }
            if (query.contains("Q")) {
                this.how = "Q";
            }
            if (query.contains("a")) {
                this.bool = "a";
            }
            if (query.contains("o")) {
                this.bool = "o";
            }
            if (query.contains("f")) {
                this.part = "f";
            }
            if (query.contains("p")) {
                this.part = "p";
            }
            if (query.contains("!")) {
                this.invert = true;
            }
        } else {
            this.withoutArguments = this.original;
            if (this.withoutArguments.contains(".*")) {
                this.how = "r";
            }
        }
    }

    public String getWithoutArguments() {
        return this.withoutArguments;
    }

    public String[] getWithoutArgumentsSplit() {
        return this.withoutArguments.split("\\s+");
    }

    private int getNumber(String query, String switcher, int n) {
        return (int)this.getLongNumber(query, switcher, n);
    }

    private long getLongNumber(String query, String switcher, long n) {
        String l = query.replaceAll(".*" + switcher + "+", "");
        l = l.replaceAll("[^0-9].*", "");
        try {
            n = Long.parseLong(l);
        }
        catch (Exception ex) {
            NestedViewsSearch.LOGGER.log(Level.INFO, "no reasonable number from " + l, ex);
        }
        return n;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isProjectInfo() {
        return this.projectInfo;
    }

    public boolean isJobComment() {
        return this.jobComment;
    }

    public boolean isSearchByJobComment() {
        return this.searchByJobComment;
    }

    public boolean isBuildComment() {
        return this.buildComment;
    }

    public int getStats() {
        return this.stats;
    }

    public boolean isStatsTable() {
        return this.statsTable;
    }

    public int getBuilds() {
        return this.builds;
    }

    public int getLast() {
        return this.last;
    }

    public String getHow() {
        return this.how;
    }

    public int isSearchByNvr() {
        return this.searchByNvr;
    }

    public int isSearchByBuildComment() {
        return this.searchByBuildComment;
    }

    public int isSearchByArtifacts() {
        return this.searchByArtifacts;
    }

    public int getMaxArtifacts() {
        return this.maxArtifacts;
    }

    public boolean isNvrFinalFilter() {
        return this.nvrFinalFilter;
    }

    public boolean isArtifactFinalFilter() {
        return this.artifactFinalFilter;
    }

    public boolean isBuildCommentFinalFilter() {
        return this.buildCommentFinalFilter;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public Date getTimeLimit() {
        try {
            if (this.yymmddhhmm == null) {
                return null;
            }
            return new SimpleDateFormat("yyMMddHHmm").parse(this.yymmddhhmm);
        }
        catch (Exception ex) {
            NestedViewsSearch.LOGGER.log(Level.WARNING, ex.toString(), ex);
            return null;
        }
    }

    public boolean isNonTrivial(boolean suggesting) {
        String loriginal = this.original == null ? "" : this.original.trim();
        String lwithout = this.withoutArguments == null ? "" : this.withoutArguments.trim();
        return !loriginal.equals(".*") && loriginal.length() >= 2 && !lwithout.equals(".*") && lwithout.length() >= 2;
    }

    public String getQuery() {
        if (this.original.startsWith("-") && this.original.contains(":")) {
            return this.original.replaceFirst("-", "").replaceAll(":.*", "");
        }
        return this.original;
    }
}

