/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.nested_view.search.LinkableCandidate;
import hudson.plugins.nested_view.search.NamableWithClass;
import hudson.plugins.nested_view.search.ProjectWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;

public class BuildDetails {
    private final String id;
    private final String displayName;
    private final String result;
    private final String timeStampString;
    private final String prefix;
    private final Date dateTime;
    private final List<Run.Artifact> artifacts;

    public BuildDetails(String prefix, Run run, int archives) {
        this(prefix, run.getId(), run.getDisplayName(), run.getResult(), run.getTimestampString(), run.getTime(), archives > 0 ? run.getArtifactsUpTo(archives) : new ArrayList(0));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="date is not cared")
    public BuildDetails(String prefix, String id, String displayName, Result result, String timeStampString, Date dateTime, List<Run.Artifact> list) {
        this.prefix = prefix;
        this.id = id;
        this.displayName = displayName;
        this.result = result == null ? "RUNNING" : result.toString();
        this.timeStampString = timeStampString;
        this.dateTime = dateTime;
        this.artifacts = list == null ? new ArrayList() : list;
    }

    public List<String> getArtifacts() {
        return this.artifacts.stream().map(a -> a.relativePath).collect(Collectors.toList());
    }

    public String toString() {
        if (this.id != null) {
            return this.prefix + this.id + "/" + this.displayName + "/" + this.result + "/" + this.timeStampString + " ago";
        }
        return this.prefix + "n/a";
    }

    public LinkableCandidate toLinkable(String projectName, SearchArtifactsOptions searchArtifactsOptions, ProjectWrapper listener) {
        if (this.id != null) {
            String link;
            String pre = "";
            String post = "";
            if (this.prefix.isEmpty()) {
                link = this.id + "/" + this.displayName;
            } else {
                link = this.prefix;
                post = this.id + "/" + this.displayName;
            }
            post = post + "/" + this.result + "/" + this.timeStampString + " ago";
            if (this.artifacts.size() > 0) {
                post = post + " (" + this.artifacts.size() + " artifacts)";
            }
            ArrayList<LinkableCandidate> sublinks = new ArrayList<LinkableCandidate>(this.artifacts.size());
            if (searchArtifactsOptions != null) {
                block0: for (Run.Artifact artifact : this.artifacts) {
                    for (String candidate : searchArtifactsOptions.query) {
                        if (searchArtifactsOptions.algorithm == 1 && searchArtifactsOptions.matched != null && searchArtifactsOptions.matched.contains(candidate)) continue;
                        boolean matches = NamableWithClass.matchSingle(artifact.relativePath, candidate, searchArtifactsOptions.how);
                        if (!searchArtifactsOptions.invert) {
                            if (!matches) continue;
                            sublinks.add(new LinkableCandidate("", artifact.relativePath, "", BuildDetails.getJenkinsUrl() + "/job/" + projectName + "/" + this.id + "/artifact/" + artifact.relativePath, new ArrayList<LinkableCandidate>(0)));
                            if (listener == null) continue block0;
                            listener.addArtifactCouont();
                            continue block0;
                        }
                        if (matches) continue;
                        sublinks.add(new LinkableCandidate("", artifact.relativePath, "", BuildDetails.getJenkinsUrl() + "/job/" + projectName + "/" + this.id + "/artifact/" + artifact.relativePath, new ArrayList<LinkableCandidate>(0)));
                        listener.addArtifactCouont();
                        continue block0;
                    }
                }
            }
            return new LinkableCandidate(pre, link, post, BuildDetails.getJenkinsUrl() + "/job/" + projectName + "/" + this.id, sublinks);
        }
        return new LinkableCandidate(this.prefix + "n/a");
    }

    public static String getJenkinsUrl() {
        return Jenkins.get().getRootUrl().replaceAll("[\\/]+$", "");
    }

    public long getDateTime() {
        return this.dateTime.getTime();
    }

    static class SearchArtifactsOptions {
        private final String[] query;
        private final int algorithm;
        private final Collection<String> matched;
        private final String how;
        private final boolean invert;

        public SearchArtifactsOptions(String[] query, int algorithm, Collection<String> matched, String how, boolean invert) {
            this.query = query;
            this.algorithm = algorithm;
            this.matched = matched;
            this.how = how;
            this.invert = invert;
        }
    }
}

