/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import hudson.plugins.nested_view.NestedViewsSearchFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Query {
    private static final int MIN_LENGTH = 2;
    private final String original;
    private final String withoutArguments;
    private boolean multiline;
    private int searchByNvr = -1;
    private boolean finalFilter;
    private boolean projectInfo;
    private int stats = -1;
    private int builds = -1;
    private int last = -1;
    private String where = "vnj";
    private String how = "c";
    private String bool = "";
    private String part = "f";
    private boolean invert = false;

    public String getOriginal() {
        return this.original;
    }

    public String getWhere() {
        return this.where;
    }

    public String getBool() {
        return this.bool;
    }

    public String getPart() {
        return this.part;
    }

    public Query(boolean search, String ooriginal) {
        if (search) {
            NestedViewsSearchFactory.resetTmpSkip();
        }
        this.original = ooriginal.trim();
        String query = null;
        try {
            Pattern getQuery = Pattern.compile("-.*:");
            Matcher m = getQuery.matcher(this.original);
            m.find();
            query = m.group();
        }
        catch (Exception getQuery) {
            // empty catch block
        }
        if (query != null) {
            this.withoutArguments = this.original.replace(query, "").trim();
            if (this.withoutArguments.contains(".*")) {
                this.how = "r";
            }
            if (query.contains("X") && search) {
                String l = query.replaceAll(".*X", "");
                int n = 1;
                if (l.length() > 0) {
                    try {
                        l = l.substring(0, 1);
                        n = Integer.parseInt(l);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NestedViewsSearchFactory.setTmpSkip(n);
            }
            if (query.contains("D") || query.contains("d")) {
                if (search) {
                    if (query.contains("D")) {
                        this.finalFilter = true;
                        this.searchByNvr = this.getNumber(query, "D", 1);
                    } else {
                        this.searchByNvr = this.getNumber(query, "d", 1);
                    }
                }
                this.bool = "o";
                if (this.builds <= 0) {
                    this.builds = 10;
                }
            }
            if (query.contains("m") && search) {
                this.multiline = true;
            }
            if (query.contains("P") && search) {
                this.projectInfo = true;
            }
            if (query.contains("S") && search) {
                this.stats = this.getNumber(query, "S", 10);
            }
            if (query.contains("B") && search) {
                this.builds = this.getNumber(query, "B", 10);
            }
            if (query.contains("L") && search) {
                this.last = this.getNumber(query, "L", 0);
                if (this.last == 0) {
                    this.last = 1234567;
                }
            } else {
                this.last = -1;
            }
            if (query.contains("j") || query.contains("v") || query.contains("n") || query.contains("w")) {
                this.where = "";
            }
            if (query.contains("j")) {
                this.where = this.where + "j";
            }
            if (query.contains("v")) {
                this.where = this.where + "v";
            }
            if (query.contains("n")) {
                this.where = this.where + "n";
            }
            if (query.contains("w")) {
                this.where = this.where + "vn";
            }
            if (query.contains("c")) {
                this.how = "c";
            }
            if (query.contains("e")) {
                this.how = "e";
            }
            if (query.contains("s")) {
                this.how = "s";
            }
            if (query.contains("r")) {
                this.how = "r";
            }
            if (query.contains("R")) {
                this.how = "R";
            }
            if (query.contains("q")) {
                this.how = "q";
            }
            if (query.contains("Q")) {
                this.how = "Q";
            }
            if (query.contains("a")) {
                this.bool = "a";
            }
            if (query.contains("o")) {
                this.bool = "o";
            }
            if (query.contains("f")) {
                this.part = "f";
            }
            if (query.contains("p")) {
                this.part = "p";
            }
            if (query.contains("!")) {
                this.invert = true;
            }
        } else {
            this.withoutArguments = this.original;
            if (this.withoutArguments.contains(".*")) {
                this.how = "r";
            }
        }
    }

    public String getWithoutArguments() {
        return this.withoutArguments;
    }

    public String[] getWithoutArgumentsSplit() {
        return this.withoutArguments.split("\\s+");
    }

    private int getNumber(String query, String switcher, int n) {
        String l = query.replaceAll(".*" + switcher, "");
        l = l.replaceAll("[^0-9].*", "");
        try {
            n = Integer.parseInt(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isProjectInfo() {
        return this.projectInfo;
    }

    public int getStats() {
        return this.stats;
    }

    public int getBuilds() {
        return this.builds;
    }

    public int getLast() {
        return this.last;
    }

    public String getHow() {
        return this.how;
    }

    public int isSearchByNvr() {
        return this.searchByNvr;
    }

    public boolean isFinalFilter() {
        return this.finalFilter;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public boolean isNonTrivial(boolean suggesting) {
        String loriginal = this.original == null ? "" : this.original.trim();
        String lwithout = this.withoutArguments == null ? "" : this.withoutArguments.trim();
        return !loriginal.equals(".*") && loriginal.length() >= 2 && !lwithout.equals(".*") && lwithout.length() >= 2;
    }
}

