/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.nested_view.search.LinkableCandidate;
import jenkins.model.Jenkins;

public class BuildDetails {
    private final String id;
    private final String displayName;
    private final String result;
    private final String timeStampString;
    private final String prefix;

    public BuildDetails(String prefix, Run run) {
        this(prefix, run.getId(), run.getDisplayName(), run.getResult(), run.getTimestampString());
    }

    public BuildDetails(String prefix, String id, String displayName, Result result, String timeStampString) {
        this.prefix = prefix;
        this.id = id;
        this.displayName = displayName;
        this.result = result == null ? "RUNNING" : result.toString();
        this.timeStampString = timeStampString;
    }

    public String toString() {
        if (this.id != null) {
            return this.prefix + this.id + "/" + this.displayName + "/" + this.result + "/" + this.timeStampString + " ago";
        }
        return this.prefix + "n/a";
    }

    public LinkableCandidate toLinkable(String projectName) {
        if (this.id != null) {
            String link;
            String pre = "";
            String post = "";
            if (this.prefix.isEmpty()) {
                link = this.id + "/" + this.displayName;
            } else {
                link = this.prefix;
                post = this.id + "/" + this.displayName;
            }
            post = post + "/" + this.result + "/" + this.timeStampString + " ago";
            return new LinkableCandidate(pre, link, post, BuildDetails.getJenkinsUrl() + "/job/" + projectName + "/" + this.id);
        }
        return new LinkableCandidate(this.prefix + "n/a");
    }

    public static String getJenkinsUrl() {
        return Jenkins.get().getRootUrl().replaceAll("[\\/]+$", "");
    }
}

