/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractProject;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.nested_view.NestedView;
import hudson.search.Search;
import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import hudson.search.SearchResult;
import hudson.search.SuggestedItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class NestedViewsSearch
extends Search {
    private static volatile transient List<NamableWithClass> allCache = new ArrayList<NamableWithClass>(0);
    private static volatile transient int allTTL = 0;
    private static volatile transient Date lastRefresh = new Date(0L);
    private static final long refreshTimeout = 600000L;
    private static final int refreshAmount = 20;
    private static final Logger LOGGER = Logger.getLogger(Search.class.getName());
    private List<NestedViewsSearchResult> hits = new ArrayList<NestedViewsSearchResult>();
    private Query query;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="allTTL and allCache are used to cache base foundation of search. Cache is shared between insntances")
    public NestedViewsSearch() {
        Date currentSearch = new Date();
        long timeDiff = currentSearch.getTime() - lastRefresh.getTime();
        if (--allTTL <= 0 || timeDiff > 600000L) {
            allTTL = 20;
            lastRefresh = currentSearch;
            ArrayList<NamableWithClass> all = new ArrayList<NamableWithClass>(1000);
            Jenkins j = Jenkins.get();
            for (TopLevelItem ti : j.getItems()) {
                if (!(ti instanceof AbstractProject)) continue;
                all.add(new NamableWithClass(ti, ti.getName(), ti.getName()));
            }
            this.addViewsRecursively(j.getViews(), "/", all);
            allCache = all;
        }
    }

    private void addViewsRecursively(Collection<View> views, String s, List<NamableWithClass> all) {
        for (View v : views) {
            if (v instanceof NestedView) {
                NestedView nw = (NestedView)v;
                all.add(new NamableWithClass(v, v.getViewName(), s + v.getViewName()));
                this.addViewsRecursively(((NestedView)v).getViews(), s + v.getViewName() + "/", all);
                continue;
            }
            all.add(new NamableWithClass(v, v.getViewName(), s + v.getViewName()));
        }
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String query = req.getParameter("q");
        if (query != null) {
            this.query = new Query(query);
            if (this.query.isNonTrivial(false)) {
                for (NamableWithClass item : allCache) {
                    if (!item.matches(this.query)) continue;
                    this.hits.add(new NestedViewsSearchResult(item.getUsefulName(), item.getUrl()));
                }
            }
        }
        Collections.sort(this.hits);
        RequestDispatcher v = req.getView((Object)this, "search-results.jelly");
        v.forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public SearchResult getSuggestions(StaplerRequest req, @QueryParameter String query) {
        SearchResult suggestedItems = super.getSuggestions(req, query);
        this.query = new Query(query);
        if (this.query.isNonTrivial(true)) {
            for (NamableWithClass item : allCache) {
                if (!item.matches(this.query)) continue;
                suggestedItems.add((Object)new SuggestedItem((SearchItem)new NestedViewsSearchResult(item.getUsefulName(), item.getUrl())));
            }
        }
        return suggestedItems;
    }

    public List<HelpItem> getSearchHelp() throws IOException {
        ArrayList<HelpItem> r = new ArrayList<HelpItem>();
        r.add(new HelpItem("the modifier(s) must start with `-` and end with `:`", ""));
        r.add(new HelpItem("r", "regex. Regex will be used also if query contains .*"));
        r.add(new HelpItem("R", "regex, but appended and prepended by .*"));
        r.add(new HelpItem("c", "contains (default)"));
        r.add(new HelpItem("s", "starts with"));
        r.add(new HelpItem("e", "ends with"));
        r.add(new HelpItem("q", "equals"));
        r.add(new HelpItem("Q", "equals honoring case"));
        r.add(new HelpItem("a", "and - query will be split on spaces, and all must match"));
        r.add(new HelpItem("o", "or - query will be split on spaces, and at least one must match"));
        r.add(new HelpItem("p", "match just name"));
        r.add(new HelpItem("f", "match full path (default)"));
        r.add(new HelpItem("j", "search only in jobs (default is in all -jw (-jvn))"));
        r.add(new HelpItem("v", "search only in views (default is in all) -jw (-jvn)"));
        r.add(new HelpItem("n", "search only in nested views (default is in all -jw (-jvn))"));
        r.add(new HelpItem("w", "search only in views and nested views (default is in all -jw (-jvn))"));
        r.add(new HelpItem("!", "invert result"));
        r.add(new HelpItem("eg \"-Rjo: dacapo sp[ei]c\"", "will find all Jobs which Matches .*dacapo.* or .*sp[ei]c.* "));
        return r;
    }

    public List<NestedViewsSearchResult> getHits() {
        return this.hits;
    }

    public static class HelpItem {
        private final String key;
        private final String description;

        public HelpItem(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class NestedViewsSearchResult
    implements SearchItem,
    Comparable {
        private final String searchName;
        private final String searchUrl;

        public String getSearchName() {
            return this.searchName;
        }

        public String getSearchUrl() {
            return this.searchUrl;
        }

        public SearchIndex getSearchIndex() {
            return null;
        }

        public NestedViewsSearchResult(String searchName, String searchUrl) {
            this.searchName = searchName;
            this.searchUrl = searchUrl;
        }

        public String toString() {
            return this.searchName;
        }

        public String toPlainOldHref() {
            return "<a href=\"" + this.searchUrl + "\">" + this.searchName + "</a>";
        }

        @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="intentional. We check the types when filling the allCached, and the classes have not much in common")
        public int compareTo(Object o) {
            return this.toString().length() - o.toString().length();
        }
    }

    private static class NamableWithClass {
        private final String name;
        private final String fullPath;
        private Object item;

        private NamableWithClass(Object item, String name, String fullPath) {
            this.item = item;
            this.name = name;
            this.fullPath = fullPath;
        }

        public String getName() {
            return this.name;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public String getUsefulName() {
            if (this.item instanceof AbstractProject) {
                return this.name;
            }
            if (this.item instanceof NestedView) {
                return this.fullPath + "/";
            }
            return this.fullPath;
        }

        public String getUrl() {
            String rootUrl = Jenkins.get().getRootUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            if (this.item instanceof AbstractProject) {
                return rootUrl + "/job/" + this.name;
            }
            return rootUrl + this.getFullPath().replace("/", "/view/");
        }

        public boolean matches(Query query) {
            if (query.invert) {
                return !this.matchesImpl(query);
            }
            return this.matchesImpl(query);
        }

        private boolean matchesImpl(Query query) {
            String nameOrPath = this.getFullPath();
            if (query.part.equals("p")) {
                nameOrPath = this.getName();
            }
            boolean clazzPass = false;
            if (query.where.contains("j") && this.item instanceof AbstractProject) {
                clazzPass = true;
            }
            if (query.where.contains("w") && (this.item instanceof View || this.item instanceof NestedView)) {
                clazzPass = true;
            }
            if (query.where.contains("n") && this.item instanceof NestedView) {
                clazzPass = true;
            }
            if (query.where.contains("v") && this.item instanceof View && !(this.item instanceof NestedView)) {
                clazzPass = true;
            }
            if (!clazzPass) {
                return false;
            }
            if (query.bool.equals("a")) {
                String[] parts;
                for (String part : parts = query.withoutArguments.split("\\s+")) {
                    if (this.matchSingle(nameOrPath, part, query)) continue;
                    return false;
                }
                return true;
            }
            if (query.bool.equals("o")) {
                String[] parts;
                for (String part : parts = query.withoutArguments.split("\\s+")) {
                    if (!this.matchSingle(nameOrPath, part, query)) continue;
                    return true;
                }
                return false;
            }
            return this.matchSingle(nameOrPath, query.withoutArguments, query);
        }

        private boolean matchSingle(String nameOrPath, String queryOrPart, Query query) {
            if (query.how.equals("s")) {
                return nameOrPath.startsWith(queryOrPart);
            }
            if (query.how.equals("e")) {
                return nameOrPath.endsWith(queryOrPart);
            }
            if (query.how.equals("r")) {
                return nameOrPath.matches(queryOrPart);
            }
            if (query.how.equals("R")) {
                return nameOrPath.matches(".*" + queryOrPart + ".*");
            }
            if (query.how.equals("q")) {
                return nameOrPath.equalsIgnoreCase(queryOrPart);
            }
            if (query.how.equals("Q")) {
                return nameOrPath.equals(queryOrPart);
            }
            return nameOrPath.contains(queryOrPart);
        }
    }

    private static class Query {
        private static final int MIN_LENGTH = 2;
        private final String original;
        private final String withoutArguments;
        private String where = "vnj";
        private String how = "c";
        private String bool = "";
        private String part = "f";
        private boolean invert = false;

        public Query(String ooriginal) {
            this.original = ooriginal.trim();
            String query = null;
            try {
                Pattern getQuery = Pattern.compile("-.*:");
                Matcher m = getQuery.matcher(this.original);
                m.find();
                query = m.group();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (query != null) {
                this.withoutArguments = this.original.replace(query, "").trim();
                if (this.withoutArguments.contains(".*")) {
                    this.how = "r";
                }
                if (query.contains("j") || query.contains("v") || query.contains("n") || query.contains("w")) {
                    this.where = "";
                }
                if (query.contains("j")) {
                    this.where = this.where + "j";
                }
                if (query.contains("v")) {
                    this.where = this.where + "v";
                }
                if (query.contains("n")) {
                    this.where = this.where + "n";
                }
                if (query.contains("w")) {
                    this.where = this.where + "vn";
                }
                if (query.contains("c")) {
                    this.how = "c";
                }
                if (query.contains("e")) {
                    this.how = "e";
                }
                if (query.contains("s")) {
                    this.how = "s";
                }
                if (query.contains("r")) {
                    this.how = "r";
                }
                if (query.contains("R")) {
                    this.how = "R";
                }
                if (query.contains("q")) {
                    this.how = "q";
                }
                if (query.contains("Q")) {
                    this.how = "Q";
                }
                if (query.contains("a")) {
                    this.bool = "a";
                }
                if (query.contains("o")) {
                    this.bool = "o";
                }
                if (query.contains("f")) {
                    this.part = "f";
                }
                if (query.contains("p")) {
                    this.part = "p";
                }
                if (query.contains("!")) {
                    this.invert = true;
                }
            } else {
                this.withoutArguments = this.original;
                if (this.withoutArguments.contains(".*")) {
                    this.how = "r";
                }
            }
        }

        public boolean isNonTrivial(boolean suggesting) {
            String loriginal = this.original == null ? "" : this.original.trim();
            String lwithout = this.withoutArguments == null ? "" : this.withoutArguments.trim();
            return !loriginal.equals(".*") && loriginal.length() >= 2 && !lwithout.equals(".*") && lwithout.length() >= 2;
        }
    }
}

