/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModifiableItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.plugins.nested_view.Messages;
import hudson.plugins.nested_view.NestedViewColumns;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.views.ListViewColumn;
import hudson.views.ViewsTabBar;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedView
extends View
implements ViewGroup,
StaplerProxy {
    private static final Result WORST_RESULT = Result.FAILURE;
    private final CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList();
    private String defaultView;
    private NestedViewColumns columns;

    @DataBoundConstructor
    public NestedView(String name) {
        super(name);
    }

    public List<TopLevelItem> getItems() {
        return Collections.emptyList();
    }

    public boolean contains(TopLevelItem item) {
        return false;
    }

    public String getUrl() {
        return this.getViewUrl();
    }

    public View getPrimaryView() {
        return null;
    }

    public ItemGroup<? extends TopLevelItem> getItemGroup() {
        return this.getOwnerItemGroup();
    }

    public List<Action> getViewActions() {
        return this.getOwner().getViewActions();
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ItemGroup<? extends TopLevelItem> itemGroup = this.getItemGroup();
        if (itemGroup instanceof ModifiableItemGroup) {
            return ((ModifiableItemGroup)itemGroup).doCreateItem(req, rsp);
        }
        return null;
    }

    public FormValidation doCheckViewName(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String name = Util.fixEmpty((String)value);
        if (name == null) {
            return FormValidation.ok();
        }
        if (this.getView(name) != null) {
            return FormValidation.error((String)hudson.model.Messages.Hudson_ViewAlreadyExists((Object)name));
        }
        try {
            Jenkins.checkGoodName((String)name);
        }
        catch (Failure e) {
            return FormValidation.error((String)e.getMessage());
        }
        return FormValidation.ok();
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty((String)value);
        return view == null || this.getView(view) == null ? FormValidation.ok() : FormValidation.error((String)hudson.model.Messages.Hudson_ViewAlreadyExists((Object)view));
    }

    public synchronized void onJobRenamed(Item item, String oldName, String newName) {
        for (View v : this.views) {
            v.onJobRenamed(item, oldName, newName);
        }
    }

    protected synchronized void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        this.defaultView = Util.fixEmpty((String)req.getParameter("defaultView"));
        if (this.columns == null) {
            this.columns = new NestedViewColumns();
        }
        if (this.columns.getColumns() == null) {
            this.columns.setColumns((DescribableList<ListViewColumn, Descriptor<ListViewColumn>>)new DescribableList((Saveable)this));
        }
        this.columns.updateFromForm(req, req.getSubmittedForm(), "columnsToShow");
    }

    public boolean canDelete(View view) {
        return true;
    }

    public void deleteView(View view) throws IOException {
        this.views.remove(view);
        this.save();
    }

    @Exported
    public Collection<View> getViews() {
        ArrayList<View> copy = new ArrayList<View>(this.views);
        Collections.sort(copy, View.SORTER);
        return copy;
    }

    public View getView(String name) {
        for (View v : this.views) {
            if (!v.getViewName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public View getDefaultView() {
        return this.isDefault() ? null : this.getView(this.defaultView);
    }

    public NestedViewColumns getColumnsToShow() {
        return this.columns;
    }

    public void onViewRenamed(View view, String oldName, String newName) {
    }

    public void save() throws IOException {
        this.owner.save();
    }

    public void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create((StaplerRequest)req, (StaplerResponse)rsp, (ViewGroup)this));
        this.save();
    }

    void addView(View view) {
        this.views.add(view);
    }

    void setOwner(ViewGroup owner) {
        this.owner = owner;
    }

    public Result getWorstResult() {
        Result check;
        Result result = Result.NOT_BUILT;
        boolean found = false;
        ArrayList<View> normalViews = new ArrayList<View>();
        ArrayList<NestedView> nestedViews = new ArrayList<NestedView>();
        for (View view : this.views) {
            if (view instanceof NestedView) {
                nestedViews.add((NestedView)view);
                continue;
            }
            normalViews.add(view);
        }
        for (View view : normalViews) {
            check = NestedView.getWorstResultForNormalView(view);
            if (check == null) continue;
            found = true;
            if (NestedView.isWorst(check)) {
                return check;
            }
            result = NestedView.getWorse(check, result);
        }
        for (NestedView nestedView : nestedViews) {
            check = nestedView.getWorstResult();
            if (check == null) continue;
            found = true;
            if (NestedView.isWorst(check)) {
                return check;
            }
            result = NestedView.getWorse(check, result);
        }
        return found ? result : null;
    }

    private static boolean isWorst(Result r) {
        return r.isCompleteBuild() == WORST_RESULT.isCompleteBuild() && r.isWorseOrEqualTo(WORST_RESULT);
    }

    private static Result getWorse(Result r1, Result r2) {
        if (!r1.isCompleteBuild() && r2.isCompleteBuild()) {
            return r2;
        }
        if (r1.isCompleteBuild() && !r2.isCompleteBuild()) {
            return r1;
        }
        return r1.isWorseThan(r2) ? r1 : r2;
    }

    private static Result getWorstResultForNormalView(View v) {
        boolean found = false;
        Result result = Result.NOT_BUILT;
        for (TopLevelItem item : v.getItems()) {
            Run lastCompletedBuild;
            if (!(item instanceof Job) || item instanceof AbstractProject && ((AbstractProject)item).isDisabled() || (lastCompletedBuild = ((Job)item).getLastCompletedBuild()) == null) continue;
            found = true;
            Result check = lastCompletedBuild.getResult();
            if (NestedView.isWorst(check)) {
                return check;
            }
            result = NestedView.getWorse(check, result);
        }
        return found ? result : null;
    }

    public static Result getWorstResult(View v) {
        if (v instanceof NestedView) {
            return ((NestedView)v).getWorstResult();
        }
        return NestedView.getWorstResultForNormalView(v);
    }

    public HealthReportContainer getHealth() {
        LinkedHashSet items = new LinkedHashSet(100);
        ArrayDeque<View> viewsStack = new ArrayDeque<View>(20);
        viewsStack.push(this);
        do {
            View currentView;
            if ((currentView = (View)viewsStack.pop()) instanceof NestedView) {
                for (View v : ((NestedView)currentView).views) {
                    viewsStack.push(v);
                }
            } else {
                items.addAll(currentView.getItems());
            }
        } while (!viewsStack.isEmpty());
        HealthReportContainer hrc = new HealthReportContainer();
        for (TopLevelItem item : items) {
            if (!(item instanceof Job)) continue;
            hrc.sum += ((Job)item).getBuildHealth().getScore();
            hrc.count++;
        }
        hrc.report = hrc.count > 0 ? new HealthReport(hrc.sum / hrc.count, Messages._ViewHealth(hrc.count)) : new HealthReport(100, Messages._NoJobs());
        return hrc;
    }

    private static HealthReportContainer getHealthForNormalView(View view) {
        HealthReportContainer hrc = new HealthReportContainer();
        for (TopLevelItem item : view.getItems()) {
            Job job;
            if (!(item instanceof Job) || (job = (Job)item).getBuildHealthReports().isEmpty()) continue;
            hrc.sum += job.getBuildHealth().getScore();
            hrc.count++;
        }
        hrc.report = hrc.count > 0 ? new HealthReport(hrc.sum / hrc.count, Messages._ViewHealth(hrc.count)) : null;
        return hrc;
    }

    public static HealthReportContainer getViewHealth(View v) {
        if (v instanceof NestedView) {
            return ((NestedView)v).getHealth();
        }
        return NestedView.getHealthForNormalView(v);
    }

    public ViewsTabBar getViewsTabBar() {
        return Hudson.getInstance().getViewsTabBar();
    }

    public Object getTarget() {
        return "".equals(Stapler.getCurrentRequest().getRestOfPath()) ? new DefaultViewProxy() : this;
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Messages.DisplayName();
        }
    }

    public class DefaultViewProxy {
        public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            if (NestedView.this.getDefaultView() != null) {
                rsp.sendRedirect2("view/" + NestedView.this.defaultView);
            } else {
                req.getView((Object)NestedView.this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HealthReportContainer {
        private HealthReport report;
        private int sum = 0;
        private int count = 0;

        private HealthReportContainer() {
        }

        public HealthReport getBuildHealth() {
            return this.report;
        }

        public List<HealthReport> getBuildHealthReports() {
            return this.report != null ? Collections.singletonList(this.report) : Collections.emptyList();
        }
    }
}

