/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.logparser.LogParserAction;
import hudson.plugins.logparser.LogParserParser;
import hudson.plugins.logparser.LogParserResult;
import hudson.plugins.logparser.ParserRuleFile;
import hudson.plugins.logparser.action.LogParserProjectAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class LogParserPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    public boolean unstableOnWarning;
    public boolean failBuildOnError;
    public boolean showGraphs;
    public String parsingRulesPath = null;
    public boolean useProjectRule;
    public String projectRulePath = null;

    @Deprecated
    private LogParserPublisher(boolean unstableOnWarning, boolean failBuildOnError, boolean showGraphs, String parsingRulesPath, boolean useProjectRule, String projectRulePath) {
        this.unstableOnWarning = unstableOnWarning;
        this.failBuildOnError = failBuildOnError;
        this.showGraphs = showGraphs;
        this.parsingRulesPath = parsingRulesPath;
        this.useProjectRule = useProjectRule;
        this.projectRulePath = projectRulePath;
    }

    @DataBoundConstructor
    public LogParserPublisher(boolean useProjectRule, String projectRulePath, String parsingRulesPath) {
        if (useProjectRule) {
            this.projectRulePath = Util.fixEmpty((String)projectRulePath);
            this.parsingRulesPath = null;
        } else {
            this.parsingRulesPath = Util.fixEmpty((String)parsingRulesPath);
            this.projectRulePath = null;
        }
        this.useProjectRule = useProjectRule;
    }

    @DataBoundSetter
    public void setUnstableOnWarning(boolean unstableOnWarning) {
        this.unstableOnWarning = unstableOnWarning;
    }

    @DataBoundSetter
    public void setFailBuildOnError(boolean failBuildOnError) {
        this.failBuildOnError = failBuildOnError;
    }

    @DataBoundSetter
    public void setShowGraphs(boolean showGraphs) {
        this.showGraphs = showGraphs;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    @Deprecated
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.perform((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
        return true;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        LogParserResult result = new LogParserResult();
        try {
            boolean preformattedHtml = !((DescriptorImpl)this.getDescriptor()).getLegacyFormatting();
            FilePath parsingRulesFile = this.useProjectRule ? new FilePath(workspace, this.projectRulePath) : new FilePath(new File(this.parsingRulesPath));
            LogParserParser parser = new LogParserParser(parsingRulesFile, preformattedHtml, launcher.getChannel());
            result = parser.parseLog(build);
            if (this.failBuildOnError && result.getTotalErrors() > 0) {
                build.setResult(Result.FAILURE);
            } else if (this.unstableOnWarning && result.getTotalWarnings() > 0) {
                build.setResult(Result.UNSTABLE);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "log-parser plugin ERROR: Cannot parse log " + build, e);
            result.setFailedToParseError(e.toString());
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "log-parser plugin ERROR: Cannot parse log " + build, e);
            result.setFailedToParseError(e.toString());
            build.setResult(Result.ABORTED);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "log-parser plugin ERROR: Cannot parse log " + build, e);
            result.setFailedToParseError(e.toString());
            build.setResult(Result.ABORTED);
        }
        LogParserAction action = new LogParserAction(build, result);
        build.addAction((Action)action);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public ParserRuleFile[] getParserRuleChoices() {
        return ((DescriptorImpl)this.getDescriptor()).getParsingRulesGlobal();
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        if (this.showGraphs) {
            return new LogParserProjectAction(project);
        }
        return null;
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private volatile ParserRuleFile[] parsingRulesGlobal = new ParserRuleFile[0];
        private boolean useLegacyFormatting = false;

        private DescriptorImpl() {
            super(LogParserPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Console output (build log) parsing";
        }

        public String getHelpFile() {
            return "/plugin/log-parser/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ParserRuleFile[] getParsingRulesGlobal() {
            return this.parsingRulesGlobal;
        }

        public boolean getLegacyFormatting() {
            return this.useLegacyFormatting;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.parsingRulesGlobal = req.bindParametersToList(ParserRuleFile.class, "log-parser.").toArray(new ParserRuleFile[0]);
            this.useLegacyFormatting = json.getJSONObject("log-parser").getBoolean("useLegacyFormatting");
            this.save();
            return true;
        }
    }
}

