/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.auth;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import java.io.PrintStream;
import jenkins.plugins.http_request.auth.Authenticator;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class CredentialNtlmAuthentication
implements Authenticator {
    private final StandardUsernamePasswordCredentials credential;
    private final String username;
    private final String domain;

    public CredentialNtlmAuthentication(StandardUsernamePasswordCredentials credential) {
        this.credential = credential;
        String[] split = credential.getUsername().split("\\\\");
        Integer pieces = split.length;
        if (pieces.equals(2)) {
            this.username = split[1];
            this.domain = split[0];
        } else if (pieces.equals(1)) {
            this.username = split[0];
            this.domain = null;
        } else {
            throw new IllegalStateException("Username contains more than one \\");
        }
    }

    @Override
    public String getKeyName() {
        return this.credential.getId();
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, PrintStream logger) {
        return CredentialNtlmAuthentication.auth(clientBuilder, context, requestBase, this.username, this.credential.getPassword().getPlainText(), this.domain);
    }

    static CloseableHttpClient auth(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, String username, String password, String domain) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(requestBase.getURI().getHost(), requestBase.getURI().getPort()), (Credentials)new NTCredentials(username, password, requestBase.getURI().getHost(), domain));
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        return clientBuilder.build();
    }
}

