/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.auth;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import java.io.PrintStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import jenkins.plugins.http_request.auth.Authenticator;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class CredentialBasicAuthentication
implements Authenticator {
    private static final long serialVersionUID = 8034231374732499786L;
    private final StandardUsernamePasswordCredentials credential;
    private final Map<HttpHost, StandardUsernamePasswordCredentials> extraCredentials = new Hashtable<HttpHost, StandardUsernamePasswordCredentials>();

    public CredentialBasicAuthentication(StandardUsernamePasswordCredentials credential) {
        this.credential = credential;
    }

    public void addCredentials(HttpHost host, StandardUsernamePasswordCredentials credentials) {
        if (host == null || credentials == null) {
            throw new IllegalArgumentException("Null target host or credentials");
        }
        this.extraCredentials.put(host, this.credential);
    }

    @Override
    public String getKeyName() {
        return this.credential.getId();
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, PrintStream logger) {
        this.prepare(clientBuilder, context, requestBase);
        return clientBuilder.build();
    }

    public void prepare(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase) {
        this.prepare(clientBuilder, context, URIUtils.extractHost((URI)requestBase.getURI()));
    }

    public void prepare(HttpClientBuilder clientBuilder, HttpContext context, HttpHost targetHost) {
        CredentialBasicAuthentication.auth(clientBuilder, context, targetHost, this.credential.getUsername(), this.credential.getPassword().getPlainText(), this.extraCredentials);
    }

    static void auth(HttpClientBuilder clientBuilder, HttpContext context, HttpHost targetHost, String username, String password) {
        CredentialBasicAuthentication.auth(clientBuilder, context, targetHost, username, password, null);
    }

    static void auth(HttpClientBuilder clientBuilder, HttpContext context, HttpHost targetHost, String username, String password, Map<HttpHost, StandardUsernamePasswordCredentials> extraCreds) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        BasicAuthCache authCache = new BasicAuthCache();
        provider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        authCache.put(targetHost, (AuthScheme)new BasicScheme());
        if (extraCreds != null && !extraCreds.isEmpty()) {
            for (Map.Entry<HttpHost, StandardUsernamePasswordCredentials> creds : extraCreds.entrySet()) {
                provider.setCredentials(new AuthScope(creds.getKey().getHostName(), creds.getKey().getPort()), (Credentials)new UsernamePasswordCredentials(creds.getValue().getUsername(), creds.getValue().getPassword().getPlainText()));
                authCache.put(creds.getKey(), (AuthScheme)new BasicScheme());
            }
        }
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
    }
}

