/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request.auth;

import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import java.io.IOException;
import java.io.PrintStream;
import jenkins.plugins.http_request.auth.Authenticator;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class CertificateAuthentication
implements Authenticator {
    private final StandardCertificateCredentials credentials;

    public CertificateAuthentication(StandardCertificateCredentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public String getKeyName() {
        return this.credentials.getId();
    }

    @Override
    public CloseableHttpClient authenticate(HttpClientBuilder clientBuilder, HttpContext context, HttpRequestBase requestBase, PrintStream logger) throws IOException {
        try {
            clientBuilder.setSSLContext(SSLContexts.custom().loadKeyMaterial(this.credentials.getKeyStore(), this.credentials.getPassword().getPlainText().toCharArray()).build());
            return clientBuilder.build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

