/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.http_request;

import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.plugins.http_request.auth.Authenticator;
import jenkins.plugins.http_request.auth.BasicDigestAuthentication;
import jenkins.plugins.http_request.auth.FormAuthentication;
import jenkins.plugins.http_request.util.HttpRequestNameValuePair;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class HttpRequestGlobalConfig
extends GlobalConfiguration {
    private List<BasicDigestAuthentication> basicDigestAuthentications = new ArrayList<BasicDigestAuthentication>();
    private List<FormAuthentication> formAuthentications = new ArrayList<FormAuthentication>();
    private static final XStream2 XSTREAM2 = new XStream2();

    public HttpRequestGlobalConfig() {
        this.load();
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void xStreamCompatibility() {
        XSTREAM2.addCompatibilityAlias("jenkins.plugins.http_request.HttpRequest$DescriptorImpl", HttpRequestGlobalConfig.class);
        XSTREAM2.addCompatibilityAlias("jenkins.plugins.http_request.util.NameValuePair", HttpRequestNameValuePair.class);
    }

    protected XmlFile getConfigFile() {
        File rootDir = Jenkins.get().getRootDir();
        File xmlFile = new File(rootDir, "jenkins.plugins.http_request.HttpRequest.xml");
        return new XmlFile((XStream)XSTREAM2, xmlFile);
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public static FormValidation validateKeyName(String value) {
        List<Authenticator> list = HttpRequestGlobalConfig.get().getAuthentications();
        int count = 0;
        for (Authenticator basicAuthentication : list) {
            if (!basicAuthentication.getKeyName().equals(value)) continue;
            ++count;
        }
        if (count > 1) {
            return FormValidation.error((String)"The Key Name must be unique");
        }
        return FormValidation.validateRequired((String)value);
    }

    public static HttpRequestGlobalConfig get() {
        return (HttpRequestGlobalConfig)((Object)GlobalConfiguration.all().get(HttpRequestGlobalConfig.class));
    }

    public List<BasicDigestAuthentication> getBasicDigestAuthentications() {
        return this.basicDigestAuthentications;
    }

    public void setBasicDigestAuthentications(List<BasicDigestAuthentication> basicDigestAuthentications) {
        this.basicDigestAuthentications = basicDigestAuthentications;
    }

    public List<FormAuthentication> getFormAuthentications() {
        return this.formAuthentications;
    }

    public void setFormAuthentications(List<FormAuthentication> formAuthentications) {
        this.formAuthentications = formAuthentications;
    }

    public List<Authenticator> getAuthentications() {
        ArrayList<Authenticator> list = new ArrayList<Authenticator>();
        list.addAll(this.basicDigestAuthentications);
        list.addAll(this.formAuthentications);
        return list;
    }

    public Authenticator getAuthentication(String keyName) {
        for (Authenticator authenticator : this.getAuthentications()) {
            if (!authenticator.getKeyName().equals(keyName)) continue;
            return authenticator;
        }
        return null;
    }
}

