/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.jenkinsci.plugins.htmlresource.config;

import com.cwctravel.jenkinsci.plugins.htmlresource.config.HTMLResource;
import com.cwctravel.jenkinsci.plugins.htmlresource.util.ByIndexSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class HTMLResourceSet {
    private static final Logger LOGGER = Logger.getLogger(HTMLResourceSet.class.getName());
    protected Set<HTMLResource> htmlResourceSet = new TreeSet<HTMLResource>();

    public HTMLResource getHTMLResourceById(String id) {
        for (HTMLResource htmlResource : this.htmlResourceSet) {
            if (!htmlResource.getId().equals(id)) continue;
            return htmlResource;
        }
        return null;
    }

    public void removeHTMLResource(String id) {
        HTMLResource htmlResource = this.getHTMLResourceById(id);
        this.htmlResourceSet.remove(htmlResource);
        this.normalizeIndices();
    }

    public void addOrReplace(HTMLResource htmlResource) {
        if (htmlResource != null) {
            HTMLResource oldHTMLResource = this.getHTMLResourceById(htmlResource.getId());
            if (oldHTMLResource != null) {
                this.htmlResourceSet.remove(oldHTMLResource);
                this.htmlResourceSet.add(htmlResource);
            } else {
                this.htmlResourceSet.add(htmlResource);
            }
            this.normalizeIndices();
        }
    }

    public void normalizeIndices() {
        ArrayList<HTMLResource> htmlResources = new ArrayList<HTMLResource>();
        htmlResources.addAll(this.htmlResourceSet);
        Collections.sort(htmlResources, new ByIndexSorter());
        for (int i = 0; i < htmlResources.size(); ++i) {
            HTMLResource htmlResource = (HTMLResource)htmlResources.get(i);
            htmlResource.setIndex(i);
        }
    }

    public void moveHTMLResourceUp(HTMLResource htmlResource) {
        if (htmlResource != null) {
            int resourceIndex = htmlResource.getIndex();
            int ceilingIndex = -1;
            HTMLResource ceilingIndexResource = null;
            for (HTMLResource currentHtmlResource : this.htmlResourceSet) {
                int currentResourceIndex = currentHtmlResource.getIndex();
                if (currentResourceIndex < 0 || currentResourceIndex >= resourceIndex || ceilingIndex >= currentResourceIndex) continue;
                ceilingIndex = currentResourceIndex;
                ceilingIndexResource = currentHtmlResource;
            }
            if (ceilingIndexResource != null) {
                ceilingIndexResource.setIndex(resourceIndex);
                htmlResource.setIndex(ceilingIndex);
            }
        }
    }

    public void moveHTMLResourceDown(HTMLResource htmlResource) {
        if (htmlResource != null) {
            int resourceIndex = htmlResource.getIndex();
            int floorIndex = this.htmlResourceSet.size();
            HTMLResource floorIndexResource = null;
            for (HTMLResource currentHtmlResource : this.htmlResourceSet) {
                int currentResourceIndex = currentHtmlResource.getIndex();
                if (currentResourceIndex <= resourceIndex || floorIndex <= currentResourceIndex) continue;
                floorIndex = currentResourceIndex;
                floorIndexResource = currentHtmlResource;
            }
            if (floorIndexResource != null) {
                floorIndexResource.setIndex(resourceIndex);
                htmlResource.setIndex(floorIndex);
            }
        }
    }

    public final List<HTMLResource> getHTMLResources() {
        ArrayList<HTMLResource> htmlResources = new ArrayList<HTMLResource>();
        htmlResources.addAll(this.htmlResourceSet);
        Collections.sort(htmlResources, new ByIndexSorter());
        return htmlResources;
    }

    public void setHTMLResources(Set<HTMLResource> htmlResourceSet) {
        this.htmlResourceSet = htmlResourceSet;
    }
}

