/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.SecretBytes;
import com.google.api.client.util.Strings;
import com.google.jenkins.plugins.credentials.oauth.Messages;
import com.google.jenkins.plugins.credentials.oauth.ServiceAccountConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class P12ServiceAccountConfig
extends ServiceAccountConfig {
    private static final long serialVersionUID = 8706353638974721795L;
    private static final Logger LOGGER = Logger.getLogger(P12ServiceAccountConfig.class.getSimpleName());
    private static final String DEFAULT_P12_SECRET = "notasecret";
    private static final String DEFAULT_P12_ALIAS = "privatekey";
    private final String emailAddress;
    @CheckForNull
    private String filename;
    @CheckForNull
    private SecretBytes secretP12Key;
    @Deprecated
    @CheckForNull
    private transient String p12KeyFile;

    @DataBoundConstructor
    public P12ServiceAccountConfig(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Deprecated
    public P12ServiceAccountConfig(String emailAddress, FileItem p12KeyFileUpload, String prevP12KeyFile) {
        this(emailAddress);
        this.setP12KeyFileUpload(p12KeyFileUpload);
        if (this.filename == null && prevP12KeyFile != null) {
            this.setFilename(prevP12KeyFile);
            this.setSecretP12Key(P12ServiceAccountConfig.getSecretBytesFromFile(prevP12KeyFile));
        }
    }

    @Deprecated
    @DataBoundSetter
    public void setP12KeyFileUpload(FileItem p12KeyFile) {
        if (p12KeyFile != null && p12KeyFile.getSize() > 0L) {
            this.filename = P12ServiceAccountConfig.extractFilename(p12KeyFile.getName());
            this.secretP12Key = SecretBytes.fromBytes((byte[])p12KeyFile.get());
        }
    }

    @DataBoundSetter
    public void setFilename(String filename) {
        if (!Strings.isNullOrEmpty((String)filename)) {
            this.filename = P12ServiceAccountConfig.extractFilename(filename);
        }
    }

    @DataBoundSetter
    public void setSecretP12Key(SecretBytes secretP12Key) {
        if (secretP12Key != null && secretP12Key.getPlainData().length > 0) {
            this.secretP12Key = secretP12Key;
        }
    }

    @Deprecated
    @CheckForNull
    private static SecretBytes getSecretBytesFromFile(@CheckForNull String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        try {
            return SecretBytes.fromBytes((byte[])FileUtils.readFileToByteArray((File)new File(filename)));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, String.format("Failed to read previous key from %s", filename), e);
            return null;
        }
    }

    @CheckForNull
    private static String extractFilename(@CheckForNull String path) {
        if (path == null) {
            return null;
        }
        return path.replaceFirst("^.+[/\\\\]", "");
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private Object readResolve() {
        if (this.secretP12Key == null) {
            return new P12ServiceAccountConfig(this.getEmailAddress(), null, this.getP12KeyFile());
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(P12ServiceAccountConfig.class);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @CheckForNull
    public String getFilename() {
        return this.filename;
    }

    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public SecretBytes getSecretP12Key() {
        return this.secretP12Key;
    }

    @Deprecated
    public String getP12KeyFile() {
        return this.p12KeyFile;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public FileItem getP12KeyFileUpload() {
        return null;
    }

    @Override
    public String getAccountId() {
        return this.getEmailAddress();
    }

    @Override
    public PrivateKey getPrivateKey() {
        try {
            KeyStore p12KeyStore = this.getP12KeyStore();
            if (p12KeyStore == null) {
                return null;
            }
            return (PrivateKey)p12KeyStore.getKey(DEFAULT_P12_ALIAS, DEFAULT_P12_SECRET.toCharArray());
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.log(Level.SEVERE, "Failed to read private key", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private KeyStore getP12KeyStore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore;
        ByteArrayInputStream in = null;
        if (this.secretP12Key == null) {
            return null;
        }
        try {
            KeyStore keyStore2 = KeyStore.getInstance("PKCS12");
            in = new ByteArrayInputStream(this.secretP12Key.getPlainData());
            keyStore2.load(in, DEFAULT_P12_SECRET.toCharArray());
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return keyStore;
    }

    @Extension
    public static final class DescriptorImpl
    extends ServiceAccountConfig.Descriptor {
        public String getDisplayName() {
            return Messages.P12ServiceAccountConfig_DisplayName();
        }
    }
}

