/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine.ssh;

import com.google.jenkins.plugins.computeengine.ssh.SshKeysHelper;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.Map;

public class GoogleKeyPair
implements Serializable {
    private final Secret privateKey;
    private final String publicKey;
    private final String user;

    private GoogleKeyPair(String publicKey, Secret privateKey, String user) {
        this.publicKey = user + ":" + publicKey + " " + user;
        this.privateKey = privateKey;
        this.user = user;
    }

    public static GoogleKeyPair generate(String user) {
        Map<String, String> keys = SshKeysHelper.generate();
        return new GoogleKeyPair(keys.get("public"), Secret.fromString((String)keys.get("private")), user);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public Secret getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "Public key:\n" + this.publicKey + "\n\nPrivate key:\n" + this.privateKey.getEncryptedValue();
    }
}

