/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.computeengine;

import com.google.cloud.graphite.platforms.plugin.client.ClientFactory;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.jenkins.plugins.computeengine.client.ClientUtil;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import java.io.IOException;
import jenkins.model.Jenkins;

public abstract class NetworkConfiguration
implements Describable<NetworkConfiguration> {
    private final String network;
    private final String subnetwork;

    public NetworkConfiguration(String network, String subnetwork) {
        this.network = network;
        this.subnetwork = subnetwork;
    }

    public Descriptor<NetworkConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public String toString() {
        return String.format("Network: %s%nSubnetwork: %s", this.getNetwork(), this.getSubnetwork());
    }

    public String getNetwork() {
        return this.network;
    }

    public String getSubnetwork() {
        return this.subnetwork;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        String this$subnetwork = this.getSubnetwork();
        String other$subnetwork = other.getSubnetwork();
        return !(this$subnetwork == null ? other$subnetwork != null : !this$subnetwork.equals(other$subnetwork));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetworkConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        String $subnetwork = this.getSubnetwork();
        result = result * 59 + ($subnetwork == null ? 43 : $subnetwork.hashCode());
        return result;
    }

    public static abstract class NetworkConfigurationDescriptor
    extends Descriptor<NetworkConfiguration> {
        private static ComputeClient computeClient;

        public static void setComputeClient(ComputeClient client) {
            computeClient = client;
        }

        public static ComputeClient computeClient(Jenkins context, String credentialsId) throws IOException {
            if (computeClient != null) {
                return computeClient;
            }
            ClientFactory clientFactory = ClientUtil.getClientFactory((ItemGroup)context, credentialsId);
            return clientFactory.computeClient();
        }

        public abstract String getDisplayName();
    }
}

